/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.controller;

import com.jfoenix.controls.JFXDrawer;
import com.jfoenix.controls.JFXHamburger;
import com.jfoenix.transitions.hamburger.HamburgerBackArrowBasicTransition;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.logging.Logger;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Accordion;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TitledPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Duration;
import rs.petcom.enums.FiscalPrinterDriver;
import rs.petcom.master.ControlledScreen;
import rs.petcom.master.PosPrint.ESCPosPrint;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.DailyTurnover;
import rs.petcom.master.dal.Log;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.PosMenu;
import rs.petcom.master.dal.PriceList;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.WorkDayClosing;
import rs.petcom.master.dal.person.PersonCategoryEnum;
import rs.petcom.master.fical.FiscalPrintFLink;
import rs.petcom.master.fical.FiscalPrinter;
import rs.petcom.master.fical.Izvestaji;
import rs.petcom.master.fical.XmlBill;
import rs.petcom.master.gui.menu.MenuButton;

public class BackOfficeLightController
implements ControlledScreen {
    private static final Logger LOGGER = Logger.getLogger("global");
    private ScreensController controller;
    private Timeline timerSat;
    private final SimpleDateFormat formatClock = new SimpleDateFormat("HH:mm:ss");
    private Parent work;
    boolean postoji = false;
    File file = null;
    String line;
    HashMap<String, java.lang.Object> hm = new HashMap();
    boolean vracaDIfromZD = false;
    @FXML
    private ImageView imgLogo;
    @FXML
    private Label userLabel;
    @FXML
    private Label clockLabel;
    @FXML
    private JFXHamburger jfxBurger;
    @FXML
    private BorderPane rootPane;
    @FXML
    private BorderPane workPane;
    @FXML
    private GridPane topGridPane;
    @FXML
    private Button logoutButton;
    @FXML
    private Label lokacijaLabel;
    private JFXHamburger menuHamburger;
    HamburgerBackArrowBasicTransition hsArrowBasicTransition;
    private Accordion menuAccordion;
    private JFXDrawer menuDrawer;
    private VBox vBoxMenu;

    public void setScreenParent(ScreensController screenPage) {
        this.controller = screenPage;
    }

    public void init() {
        this.work = this.controller.loadFxml(ScreensController.DIALOG_BACKOFFICE_START_IMAGE, null);
        this.workPane.setCenter((Node)this.work);
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/applicationTrgovina.css");
            this.rootPane.getStylesheets().add((java.lang.Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovinaGlavna.css");
            this.imgLogo.setImage(new Image("/rs/petcom/master/img/T_Master_Logotipi.png"));
        }
        this.timerSat = new Timeline(new KeyFrame[]{new KeyFrame(Duration.seconds((double)1.0), (EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                BackOfficeLightController.this.clockLabel.setText(BackOfficeLightController.this.formatClock.format(new Date()));
            }
        }, new KeyValue[0])});
        this.timerSat.setCycleCount(-1);
        this.timerSat.play();
        this.userLabel.setText(this.controller.getUser().getUserName());
        this.userLabel.setStyle("-fx-background-color: #21252e;-fx-text-fill:white;");
        if (this.controller.getSettings().isTrainingMode()) {
            this.userLabel.setText(this.controller.getUser().getUserName() + "- OBUKA");
            this.userLabel.setStyle("-fx-background-color: #FFBF00;-fx-text-fill:black;-fx-font-weight: bold; -fx-margin: 10 10 10 10;");
        }
        this.clockLabel.setText(this.formatClock.format(new Date()));
        this.vBoxMenu = new VBox();
        this.vBoxMenu.setPrefWidth(0.0);
        this.workPane.setLeft((Node)this.vBoxMenu);
        this.menuHamburger = new JFXHamburger();
        this.hsArrowBasicTransition = new HamburgerBackArrowBasicTransition(this.menuHamburger);
        this.hsArrowBasicTransition.setRate(-1.0);
        this.topGridPane.add((Node)this.menuHamburger, 0, 1);
        this.menuDrawer = new JFXDrawer();
        this.menuAccordion = new Accordion();
        this.menuAccordion.setMinSize(224.0, 100.0);
        this.menuDrawer.open();
        this.menuDrawer.setSidePane(new Node[]{this.menuAccordion});
        this.loadMenu();
        this.menuHamburger.addEventFilter(MouseEvent.MOUSE_PRESSED, e -> {
            this.hsArrowBasicTransition.setRate(this.hsArrowBasicTransition.getRate() * -1.0);
            this.hsArrowBasicTransition.play();
            if (this.menuDrawer.isShown()) {
                this.menuDrawer.close();
                this.menuDrawer.getSidePane().clear();
                this.vBoxMenu.setPrefWidth(0.0);
                this.menuAccordion.getPanes().clear();
            } else {
                this.vBoxMenu.getChildren().clear();
                this.menuDrawer.open();
                this.vBoxMenu.setPrefHeight(100.0);
                this.menuDrawer.setSidePane(new Node[]{this.menuAccordion});
                this.loadMenu();
            }
        });
    }

    public void setParameter(java.lang.Object parameter) {
    }

    public java.lang.Object getParameter() {
        return null;
    }

    private void loadMenu() {
        this.menuAccordion.getPanes().clear();
        ArrayList menuList = PosMenu.getLightList((Long)this.controller.getUser().getUserID(), (Connection)this.controller.getSettings().getConnection());
        if (menuList != null && menuList.size() < 1) {
            this.controller.alert("Obavestenje", "Izabranom korisniku nije pode\u0161eno \u0161ta sve mo\u017ee da koristi u administraciji. Ukoliko imate nejasno\u0107a obratite se tehni\u010dkoj podr\u0161ci", this.rootPane.getScene().getWindow());
            this.logout();
        }
        for (int i = 0; i < menuList.size(); ++i) {
            TitledPane tp = new TitledPane();
            tp.setText(((PosMenu)menuList.get(i)).getTitle());
            if (this.rootPane.getScene() != null) {
                tp.setMinWidth(this.rootPane.getScene().getWidth() * 20.0 / 100.0);
            } else {
                tp.setMinWidth(Toolkit.getDefaultToolkit().getScreenSize().getWidth() * 20.0 / 100.0);
            }
            this.loadMenuItems(((PosMenu)menuList.get(i)).getPosMenuID(), tp);
            this.menuAccordion.getPanes().add((java.lang.Object)tp);
        }
        this.vBoxMenu.getChildren().add((java.lang.Object)this.menuDrawer);
        this.menuDrawer.setSidePane(new Node[]{this.menuAccordion});
    }

    private void loadMenuItems(int PosMenuID, TitledPane titledPane) {
        ScrollPane sb = new ScrollPane();
        VBox vBox = new VBox();
        vBox.getStyleClass().add((java.lang.Object)"menuVbox");
        for (PosMenu pm : PosMenu.getListLight((int)PosMenuID, (Long)this.controller.getUser().getUserID(), (Connection)this.controller.getSettings().getConnection())) {
            if (!pm.isIsCommand()) continue;
            MenuButton mb = new MenuButton(pm.getTitle(), pm.getCode());
            mb.setWrapText(true);
            mb.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent event) {
                    BackOfficeLightController.this.menuAction(((MenuButton)event.getSource()).getMenuCode(), event.getSource());
                }
            });
            vBox.getChildren().add((java.lang.Object)mb);
        }
        sb.setFitToHeight(true);
        sb.setFitToWidth(true);
        sb.setContent((Node)vBox);
        titledPane.setContent((Node)sb);
    }

    protected void menuAction(String code, java.lang.Object source) {
        Parent work = null;
        System.out.println(code);
        block120 : switch (code) {
            case "BLKUIK": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_BLAGAJNA_KNJIGA_ULAZA_IZLAZA_KOMITENATA, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "BLGKI": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_BLAGAJNA_KNJIGA_IZLAZA, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "BLGKU": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_BLAGAJNA_KNJIGA_ULAZA, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "IN": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_EVIDENCIJA_ZA_NI, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "FINI": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_FISCAL_CORRECTION, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "FIIZ": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_FISKALNI_IZVESTAJI, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "FIPS": {
                FiscalPrinterDriver fpd = this.controller.getSettings().getFpDriver();
                switch (fpd) {
                    case FLink: {
                        FiscalPrintFLink fLink = new FiscalPrintFLink(this.controller);
                        fLink.printXReport();
                        break block120;
                    }
                    case Lpfr: {
                        ESCPosPrint posPrint = new ESCPosPrint(this.controller);
                        posPrint.printCurrentSales("crossSection");
                        break block120;
                    }
                }
                break;
            }
            case "FIPA": {
                ESCPosPrint posPrint = new ESCPosPrint(this.controller);
                posPrint.printCurrentSalesWithArticles();
                break;
            }
            case "FIDI": {
                int jesNoDI = this.controller.yesNoDialog("Dnevni izvestaj!", "Da li ste sigurni da \u017eelite da istampate dnevni izvestaj", this.rootPane.getScene().getWindow());
                boolean vracaDI = false;
                if (jesNoDI == ScreensController.MODAL_RESULT_YES) {
                    vracaDI = FiscalPrinter.printReport((ScreensController)this.controller, (String)"3");
                }
                if (!vracaDI || !Boolean.parseBoolean(this.controller.getSettings().getActualByName("dnevni.izvestaj.aktivan"))) break;
                Stage taskUpdateStage = this.controller.getSettings().getInfoStage("Molimo Vas sacekajte da izadje prozor, kako biste upisali broj dnevnog izvestaja", this.rootPane.getScene().getWindow());
                Task<Boolean> loadingCsvTask = new Task<Boolean>(){

                    protected Boolean call() throws Exception {
                        try {
                            int vremeCekanja = 0;
                            while (!BackOfficeLightController.this.postoji) {
                                Thread.sleep(200L);
                                BackOfficeLightController.this.file = new File(BackOfficeLightController.this.controller.getSettings().getFiscalFolder() + "fromfp\\" + FiscalPrinter.getPutanjaDnevnogIzvestaja() + ".txt");
                                if (!BackOfficeLightController.this.file.exists() && (vremeCekanja += 200) <= 20000) continue;
                                BackOfficeLightController.this.postoji = true;
                                break;
                            }
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        return BackOfficeLightController.this.postoji;
                    }
                };
                loadingCsvTask.setOnSucceeded(eventValue -> {
                    taskUpdateStage.hide();
                    Double vrednostDI = null;
                    int brojDI = 0;
                    if (this.file.exists() && this.postoji) {
                        try {
                            FileInputStream fis = new FileInputStream(this.file);
                            InputStreamReader isr = new InputStreamReader((InputStream)fis, Charset.forName("UTF-8"));
                            BufferedReader br = new BufferedReader(isr);
                            while ((this.line = br.readLine()) != null) {
                                String[] red = this.line.split(";");
                                brojDI = Integer.parseInt(red[0].trim());
                                vrednostDI = Double.parseDouble(red[1].trim());
                                this.postoji = false;
                            }
                            br.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    this.hm.put("controller", this.controller);
                    this.hm.put("brojDI", brojDI);
                    this.hm.put("vrednostDI", vrednostDI);
                    int potvrdi = this.controller.showModalDialog("Dnevni izvestaj", ScreensController.SCREEN_BACKOFFICE_DNEVNI_IZVESTAJ, this.hm, this.rootPane.getScene().getWindow());
                });
                loadingCsvTask.setOnFailed(eventValue -> {
                    taskUpdateStage.hide();
                    this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no u\u010ditavanje", this.rootPane.getScene().getWindow());
                });
                loadingCsvTask.exceptionProperty().addListener((obs, old, newValue) -> {
                    if (newValue != null) {
                        Exception ex = (Exception)newValue;
                        ex.printStackTrace();
                    }
                });
                new Thread((Runnable)loadingCsvTask).start();
                break;
            }
            case "IZPPO": {
                Izvestaji.PrometPoOperaterima((String)this.controller.getSettings().getFiscalFolder(), (Long)this.controller.getUser().getUserID(), (int)this.controller.getPointOfSale().getPointOfSaleID(), (Connection)this.controller.getSettings().getConnection());
                break;
            }
            case "IZPSO": {
                Izvestaji.PrometPoOperaterima((String)this.controller.getSettings().getFiscalFolder(), (Long)new Long(0L), (int)this.controller.getPointOfSale().getPointOfSaleID(), (Connection)this.controller.getSettings().getConnection());
                break;
            }
            case "IZPAO": {
                Izvestaji.ProdatiArtikli((String)this.controller.getSettings().getFiscalFolder(), (Long)this.controller.getUser().getUserID(), (PointOfSale)this.controller.getPointOfSale(), (Connection)this.controller.getSettings().getConnection());
                break;
            }
            case "IZPA": {
                Izvestaji.ProdatiArtikli((String)this.controller.getSettings().getFiscalFolder(), (Long)new Long(0L), (PointOfSale)this.controller.getPointOfSale(), (Connection)this.controller.getSettings().getConnection());
                break;
            }
            case "RUC": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_REPORTS_RAZLIKA_U_CENI, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "FIPO": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_FINANSIJSKI_POPUST, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "LOYGR": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_LOYALTY_GROUP, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "IZPP": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_REPORTS_PREGLED_PRODAJE, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "PROART": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_IZVESTAJI_PRODAJE_PRODATI_ARTIKLI, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "EXCTAX": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_IZVESTAJI_EXCISE_TAX, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "IZLPR": {
                work = this.controller.loadFxml(ScreensController.DIALOG_BACKOFFICE_REPORTS_LIST_OF_SALE, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "IZVPRPODANIMA": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_IZVESTAJI_PRODAJE_PO_DANIMA, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "IZPPU": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_REPORTS_PREGLED_PRODAJE_USLUGA, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "IZDPU": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_REPORTS_DPU_LIST, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "IZSZ": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_REPORTS_STOCK_REPORT, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "IZSZB": {
                work = this.controller.loadFxml(ScreensController.DIALOG_BACKOFFICE_REPORTS_STOCK_REPORT_BASE, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "IZTR": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_REPORTS_TRAKA_RADA, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "IZPKR": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_REPORTS_PREGLED_KOREKCIJA, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "IZKEP": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_REPORTS_KEP, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "KEPK": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_REPORTS_KEPK, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "IZPC": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_REPORTS_PAY_CARD, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "IZSPK": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_REPORTS_SPECIFIKACIJA_KALKULACIJA, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "IZSK": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                this.hm.put("personCategory", PersonCategoryEnum.LOYALITY);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_REPORTS_LOYALITY_BILL, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "IZSKR": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                this.hm.put("personCategory", PersonCategoryEnum.LOYALITY);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_REPORTS_LOYALITY, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DONIVE": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_REPORTS_NIVELACIJA, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DOSTIK": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_PRINT_STICKERS, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "SOSU": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_SO_SETUP, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "SOSB": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_SO_SYNCHRONIZATION, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "SOPR": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_SO_PRESENT, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "BRART": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_QUICK_GROUP_PRODUCTS, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DORPOP": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_RADNI_POPIS, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DOPOP": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_POPIS, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "OTPIS": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_OTPIS, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DOPO": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_POVRAT, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "SIDO": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                this.hm.put("personCategory", PersonCategoryEnum.SUPPLIER);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_PERSONS, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "SIKU": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                this.hm.put("personCategory", PersonCategoryEnum.BUYER);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_PERSONS, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "SIKUF": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                this.hm.put("personCategory", PersonCategoryEnum.FIZICKO_LICE);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_FIZICKO_LICE, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "STACE": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_PRICE_LIST_PRINT, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "ADMKU": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_ADMIN_DEFERRED, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "ADMBP": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_ADMIN_DATA_DELETE, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "SOPK": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_ADMIN_PAYCARD, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "ODPLU": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DEFERRED_RECIVE, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "SIGO": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_CASH_BUYER, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "AKCZ": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_EXCISE, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DONA": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_NALOG_ZA_ISPRAVKU_LPFR, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "ADKO": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_PERSONS, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "PRINT": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_PRINTER, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "GROUP": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_SIFRARNICI_PRODUCT_GROUP, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "GROFR": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_GROUP, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "KORSI": {
                HashMap<String, ScreensController> hm4 = new HashMap<String, ScreensController>();
                hm4.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_KORISNICI_SISTEMA, hm4);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "SIDP": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_SIFRARNICI_ADITIONAL_FIELDS, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "SIPL": {
                work = this.controller.loadFxml(ScreensController.SCREEN_PRICE_LISTS, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "SIPA": {
                work = this.controller.loadFxml(ScreensController.SCREEN_OFFER_PRICE_LISTS, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "SICK": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BUYER_OFFER_PRICE_LISTS, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "SILO": {
                this.hm.put("personCategory", PersonCategoryEnum.LOYALITY);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_LOYALITY, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "LOYPO": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_LOYALITY_SETTINGS, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "GIFT": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_GIFT_CARD_SETTINGS, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "SOBUP": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_SERVICE_DATABASE_BACK_UP, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "PRENO": {
                HashMap<String, ScreensController> hm5 = new HashMap<String, ScreensController>();
                hm5.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_PRICE_LISTS, hm5);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "SOEX": {
                HashMap<String, ScreensController> hm6 = new HashMap<String, ScreensController>();
                hm6.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_SERVICE_EXPORT, hm6);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "PVFP": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_CHANGE_TIME_ON_FP, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "SOCI": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_CSV_IMPORT, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "SOJM": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_UNIT_IMPORT, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "SOPO": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_SERVICE_OBJECT_CONFIG_TRGOVINA, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DNEVNIK": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_lOG_RECORD, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "SOPD": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_SERVICE_DEPARTMENT_CONFIG_TRGOVINA, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "SOPOS": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_SERVICE_POINT_OF_SALE_CONFIG_TRGOVINA, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "POCOM": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_SERVICE_COMPANY_CONFIG_TRGOVINA, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "SOSKL": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_SERVICE_WAREHOUSE_CENTRAL_TRGOVINA, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "NAPL": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_SERVICE_PAYMENT_METHOD, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "SEPS": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_SERVICE_VAT_CONFIG, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "ZDZD": {
                final boolean workDay24h = Boolean.parseBoolean(this.controller.getSettings().getActualByName("24h.radno.vreme"));
                int jesNo = this.controller.yesNoDialog("Zatvaranje dana!", "Da li ste sigurni da \u017eelite da zatvorite dan?\n\n", this.rootPane.getScene().getWindow());
                if (jesNo != ScreensController.MODAL_RESULT_YES) {
                    return;
                }
                ESCPosPrint posPrintEnd = new ESCPosPrint(this.controller);
                posPrintEnd.printCurrentSales("endDay");
                boolean odobreno = false;
                boolean greska = false;
                try {
                    if (!this.controller.getSettings().getSetting("kontrola.zakljucenja.dana", this.controller.getPointOfSale()).equals("true")) {
                        odobreno = true;
                    }
                    if (!odobreno) {
                        this.hm = WorkDay.allowClose((ScreensController)this.controller);
                        if (((Boolean)this.hm.get("allowed")).booleanValue()) {
                            odobreno = true;
                        }
                    }
                }
                catch (IOException e) {
                    this.controller.alert("Gre\u0161ka prilikom o\u010ditavanja sa fiskalne kase!", "Zatvaranje dana nije mogu\u0107e jer je do\u0161lo do gre\u0161ke pri o\u010ditavanju podataka sa fiskalnog pritnera!\n\n", this.rootPane.getScene().getWindow());
                    odobreno = false;
                    greska = true;
                }
                if (!odobreno && (jesNo = this.controller.yesNoDialog("Zatvaranje dana bez sravnjenja!", "Iznosi na fiskalnom printeru i u bazi podataka se razlikuju!\n\n" + this.hm.get("text") + "\n\nDa li ste sigurni da \u017eelite da zatvorite dan?", this.rootPane.getScene().getWindow())) == ScreensController.MODAL_RESULT_YES) {
                    this.controller.setAuthorizationRequest(6);
                    HashMap<String, ScreensController> hm2 = new HashMap<String, ScreensController>();
                    hm2.put("controller", this.controller);
                    int mr = this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 ? this.controller.showModalDialog("Autorizacija", ScreensController.SCREEN_AUTHORISATION_TRGOVINA, hm2, this.rootPane.getScene().getWindow()) : this.controller.showModalDialog("Autorizacija", ScreensController.SCREEN_AUTHORISATION, hm2, this.rootPane.getScene().getWindow());
                    if (mr == ScreensController.MODAL_RESULT_OK) {
                        LOGGER.info("Odobrenje za zatvaranje neispravnog dana. Neslaganje fiskala i programa. Odobrio: " + ((User)hm2.get("user")).getUserName());
                        Log.writeLog((User)((User)hm2.get("user")), (String)("PointOfSaleID: " + this.controller.getPointOfSale().getName() + " - Odobrenje za zatvaranje spornog dana."), (Connection)this.controller.getSettings().getConnection());
                        odobreno = true;
                    }
                }
                if (odobreno) {
                    int i;
                    this.workPane.getChildren().clear();
                    this.menuAccordion.getPanes().clear();
                    this.workPane.setCenter(this.controller.getSettings().getProgressInfoStage("Zatvaranje dana u toku. Ne gasiti aplikaciju."));
                    LOGGER.info("Korisnik: " + this.controller.getUser().getUserName() + " Zatvaranje dana");
                    for (i = 0; i < this.controller.getSettings().getWdProductsReport(); ++i) {
                        Izvestaji.ProdatiArtikli((String)this.controller.getSettings().getFiscalFolder(), (Long)new Long(0L), (PointOfSale)this.controller.getPointOfSale(), (Connection)this.controller.getSettings().getConnection());
                    }
                    for (i = 0; i < this.controller.getSettings().getWdOperatorReport(); ++i) {
                        Izvestaji.PrometPoOperaterima((String)this.controller.getSettings().getFiscalFolder(), (Long)new Long(0L), (int)this.controller.getPointOfSale().getPointOfSaleID(), (Connection)this.controller.getSettings().getConnection());
                    }
                    for (i = 0; i < this.controller.getSettings().getWdStateReport(); ++i) {
                        FiscalPrinter.printReport((ScreensController)this.controller, (String)"1");
                    }
                    for (i = 0; i < this.controller.getSettings().getWdPluReport(); ++i) {
                        FiscalPrinter.printReport((ScreensController)this.controller, (String)"2");
                    }
                    for (i = 0; i < this.controller.getSettings().getWdDailyReport(); ++i) {
                        this.vracaDIfromZD = FiscalPrinter.printReport((ScreensController)this.controller, (String)"3");
                    }
                    new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Loose catch block
                         */
                        @Override
                        public void run() {
                            block25: {
                                WorkDay wd;
                                block24: {
                                    wd = null;
                                    boolean documentLockIsActive = Boolean.parseBoolean(BackOfficeLightController.this.controller.getSettings().getActualByName("documentLock.active"));
                                    if (PointOfSale.getPosList((Object)BackOfficeLightController.this.controller.getObject(), (Connection)BackOfficeLightController.this.controller.getSettings().getConnection()).size() > 1) {
                                        while (WorkDay.isTableLocked((Connection)BackOfficeLightController.this.controller.getSettings().getConnection())) {
                                            try {
                                                Thread.sleep(10000L);
                                            }
                                            catch (InterruptedException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                    } else {
                                        for (WorkDay workDay : WorkDay.getFullList((ScreensController)BackOfficeLightController.this.controller)) {
                                            if (!workDay.isClosingInProgress()) continue;
                                            workDay.setClosingInProgress(false);
                                            workDay.updateClosingInProgress(BackOfficeLightController.this.controller);
                                        }
                                    }
                                    wd = WorkDay.getFromDb((PointOfSale)BackOfficeLightController.this.controller.getPointOfSale(), (Connection)BackOfficeLightController.this.controller.getSettings().getConnection());
                                    wd.setLockTable(true, BackOfficeLightController.this.controller.getSettings().getConnection());
                                    if (workDay24h) {
                                        BackOfficeLightController.this.controller.getSettings().getConnection().setAutoCommit(false);
                                        wd.closeWorkDay(BackOfficeLightController.this.controller.getUser(), BackOfficeLightController.this.controller.getPointOfSale(), BackOfficeLightController.this.controller.getSettings().getConnection());
                                        if (!documentLockIsActive && !wd.isOpenInDep(BackOfficeLightController.this.controller.getSettings().getConnection())) {
                                            boolean uradjena = wd.createNivelation(BackOfficeLightController.this.controller);
                                            wd.createNivelationSellingChangePrice(BackOfficeLightController.this.controller);
                                            if (!uradjena && PriceList.getList((Object)BackOfficeLightController.this.controller.getObject(), (boolean)uradjena, (Connection)BackOfficeLightController.this.controller.getSettings().getConnection()).size() > 1) {
                                                wd.createNewNivelationBetweenPriceList(BackOfficeLightController.this.controller);
                                            }
                                        }
                                        BackOfficeLightController.this.controller.getSettings().getConnection().commit();
                                        break block24;
                                    }
                                    WorkDayClosing wdClosing = new WorkDayClosing(BackOfficeLightController.this.controller, wd);
                                    wdClosing.closeWorkDay();
                                    if (documentLockIsActive || wd.isOpenInDep(BackOfficeLightController.this.controller.getSettings().getConnection())) break block24;
                                    boolean uradjena = wd.createNivelation(BackOfficeLightController.this.controller);
                                    wd.createNivelationSellingChangePrice(BackOfficeLightController.this.controller);
                                    if (uradjena || PriceList.getList((Object)BackOfficeLightController.this.controller.getObject(), (boolean)uradjena, (Connection)BackOfficeLightController.this.controller.getSettings().getConnection()).size() <= 1) break block24;
                                    wd.createNewNivelationBetweenPriceList(BackOfficeLightController.this.controller);
                                }
                                try {
                                    BackOfficeLightController.this.controller.getSettings().getConnection().setAutoCommit(true);
                                    if (wd != null) {
                                        wd.setLockTable(false, BackOfficeLightController.this.controller.getSettings().getConnection());
                                    }
                                    Platform.runLater((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            if (BackOfficeLightController.this.vracaDIfromZD && Boolean.parseBoolean(BackOfficeLightController.this.controller.getSettings().getActualByName("dnevni.izvestaj.aktivan"))) {
                                                Task<Boolean> loadingCsvTask = new Task<Boolean>(){

                                                    protected Boolean call() throws Exception {
                                                        try {
                                                            System.out.println("prvi korak");
                                                            int vremeCekanja = 0;
                                                            while (!BackOfficeLightController.this.postoji) {
                                                                Thread.sleep(200L);
                                                                BackOfficeLightController.this.file = new File(BackOfficeLightController.this.controller.getSettings().getFiscalFolder() + "fromfp\\" + FiscalPrinter.getPutanjaDnevnogIzvestaja() + ".txt");
                                                                if (!BackOfficeLightController.this.file.exists() && (vremeCekanja += 200) <= 20000) continue;
                                                                BackOfficeLightController.this.postoji = true;
                                                                break;
                                                            }
                                                        }
                                                        catch (InterruptedException e) {
                                                            e.printStackTrace();
                                                        }
                                                        return BackOfficeLightController.this.postoji;
                                                    }
                                                };
                                                if (Boolean.parseBoolean(BackOfficeLightController.this.controller.getSettings().getActualByName("excel.microcer"))) {
                                                    DailyTurnover dtTurnover = DailyTurnover.getByID((ScreensController)BackOfficeLightController.this.controller, (long)DailyTurnover.insertMC((ScreensController)BackOfficeLightController.this.controller));
                                                    try {
                                                        XmlBill.writeCloseDayPOStoERP((DailyTurnover)dtTurnover, (ScreensController)BackOfficeLightController.this.controller);
                                                    }
                                                    catch (Exception e) {
                                                        e.printStackTrace();
                                                    }
                                                    System.out.println("Mikrocer je aktivan zatvaram dan");
                                                    BackOfficeLightController.this.logout();
                                                } else {
                                                    loadingCsvTask.setOnSucceeded(eventValue -> {
                                                        System.out.println("drugi korak");
                                                        Double vrednostDI = null;
                                                        int brojDI = 0;
                                                        if (BackOfficeLightController.this.file.exists() && BackOfficeLightController.this.postoji) {
                                                            try {
                                                                FileInputStream fis = new FileInputStream(BackOfficeLightController.this.file);
                                                                InputStreamReader isr = new InputStreamReader((InputStream)fis, Charset.forName("UTF-8"));
                                                                BufferedReader br = new BufferedReader(isr);
                                                                while ((BackOfficeLightController.this.line = br.readLine()) != null) {
                                                                    String[] red = BackOfficeLightController.this.line.split(";");
                                                                    brojDI = Integer.parseInt(red[0].trim());
                                                                    vrednostDI = Double.parseDouble(red[1].trim());
                                                                    BackOfficeLightController.this.postoji = false;
                                                                }
                                                                br.close();
                                                            }
                                                            catch (IOException e) {
                                                                e.printStackTrace();
                                                            }
                                                        }
                                                        BackOfficeLightController.this.hm.put("controller", BackOfficeLightController.this.controller);
                                                        BackOfficeLightController.this.hm.put("brojDI", brojDI);
                                                        BackOfficeLightController.this.hm.put("vrednostDI", vrednostDI != null ? vrednostDI : 0.0);
                                                        System.out.println("Sad sam ovde");
                                                        BackOfficeLightController.this.controller.showModalDialog("Dnevni izvestaj", ScreensController.SCREEN_BACKOFFICE_DNEVNI_IZVESTAJ, BackOfficeLightController.this.hm, BackOfficeLightController.this.rootPane.getScene().getWindow());
                                                        BackOfficeLightController.this.logout();
                                                    });
                                                }
                                                loadingCsvTask.setOnFailed(eventValue -> BackOfficeLightController.this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no u\u010ditavanje", BackOfficeLightController.this.rootPane.getScene().getWindow()));
                                                loadingCsvTask.exceptionProperty().addListener((obs, old, newValue) -> {
                                                    if (newValue != null) {
                                                        Exception ex = (Exception)newValue;
                                                        ex.printStackTrace();
                                                    }
                                                });
                                                new Thread((Runnable)loadingCsvTask).start();
                                            } else {
                                                BackOfficeLightController.this.logout();
                                            }
                                        }
                                    });
                                }
                                catch (SQLException e) {
                                    e.printStackTrace();
                                    Platform.runLater((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            BackOfficeLightController.this.logout();
                                        }
                                    });
                                }
                                break block25;
                                catch (SQLException e) {
                                    try {
                                        try {
                                            BackOfficeLightController.this.controller.getSettings().getConnection().rollback();
                                        }
                                        catch (SQLException e1) {
                                            e1.printStackTrace();
                                        }
                                        e.printStackTrace();
                                        Platform.runLater((Runnable)new Runnable(){

                                            @Override
                                            public void run() {
                                                e.printStackTrace();
                                                BackOfficeLightController.this.controller.alert("Gre\u0161ka prilikom upisa u bazu!", "Do\u0161lo je do gre\u0161ke prilikom upisa u bazu. Radni dan nije propisno zatvoren.", BackOfficeLightController.this.rootPane.getScene().getWindow());
                                            }
                                        });
                                    }
                                    catch (Throwable throwable) {
                                        try {
                                            BackOfficeLightController.this.controller.getSettings().getConnection().setAutoCommit(true);
                                            if (wd != null) {
                                                wd.setLockTable(false, BackOfficeLightController.this.controller.getSettings().getConnection());
                                            }
                                            Platform.runLater((Runnable)new /* invalid duplicate definition of identical inner class */);
                                        }
                                        catch (SQLException e2) {
                                            e2.printStackTrace();
                                            Platform.runLater((Runnable)new /* invalid duplicate definition of identical inner class */);
                                        }
                                        throw throwable;
                                    }
                                    try {
                                        BackOfficeLightController.this.controller.getSettings().getConnection().setAutoCommit(true);
                                        if (wd != null) {
                                            wd.setLockTable(false, BackOfficeLightController.this.controller.getSettings().getConnection());
                                        }
                                        Platform.runLater((Runnable)new /* invalid duplicate definition of identical inner class */);
                                    }
                                    catch (SQLException e3) {
                                        e3.printStackTrace();
                                        Platform.runLater((Runnable)new /* invalid duplicate definition of identical inner class */);
                                    }
                                }
                            }
                        }
                    }.start();
                    break;
                }
                if (greska) break;
                this.controller.alert("Zatvaranje dana nije dozvoljeno!", "Zatvaranje dana nije mogu\u0107e jer se unosi na fiskalu i u bazi ne sla\u017eu!", this.rootPane.getScene().getWindow());
                break;
            }
            case "ZDZDBF": {
                int i = this.controller.yesNoDialog("Zatvaranje dana bez dnevnog izve\u0161taja", "Da li ste sigurni?", this.rootPane.getScene().getWindow());
                if (i == ScreensController.MODAL_RESULT_NO) {
                    return;
                }
                this.controller.setAuthorizationRequest(9);
                HashMap<String, ScreensController> hm2 = new HashMap<String, ScreensController>();
                hm2.put("controller", this.controller);
                int mr = this.controller.showModalDialog("Autorizacija", ScreensController.SCREEN_AUTHORISATION, hm2, this.rootPane.getScene().getWindow());
                if (mr != ScreensController.MODAL_RESULT_OK) break;
                this.workPane.getChildren().clear();
                this.menuAccordion.getPanes().clear();
                this.workPane.setCenter(this.controller.getSettings().getProgressInfoStage("Zatvaranje dana u toku. Ne gasiti aplikaciju."));
                new Thread(){

                    /*
                     * Loose catch block
                     */
                    @Override
                    public void run() {
                        block13: {
                            WorkDay wd = WorkDay.getFromDb((PointOfSale)BackOfficeLightController.this.controller.getPointOfSale(), (Connection)BackOfficeLightController.this.controller.getSettings().getConnection());
                            wd.closeWorkDay(BackOfficeLightController.this.controller.getUser(), BackOfficeLightController.this.controller.getPointOfSale(), BackOfficeLightController.this.controller.getSettings().getConnection());
                            boolean documentLockIsActive = Boolean.parseBoolean(BackOfficeLightController.this.controller.getSettings().getActualByName("documentLock.active"));
                            BackOfficeLightController.this.controller.getSettings().getConnection().setAutoCommit(false);
                            if (!documentLockIsActive && !wd.isOpenInDep(BackOfficeLightController.this.controller.getSettings().getConnection())) {
                                wd.createNivelation(BackOfficeLightController.this.controller);
                                wd.createNivelationSellingChangePrice(BackOfficeLightController.this.controller);
                            }
                            BackOfficeLightController.this.controller.getSettings().getConnection().commit();
                            try {
                                BackOfficeLightController.this.controller.getSettings().getConnection().setAutoCommit(true);
                                Platform.runLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        BackOfficeLightController.this.logout();
                                    }
                                });
                            }
                            catch (SQLException e) {
                                e.printStackTrace();
                            }
                            break block13;
                            catch (SQLException e) {
                                try {
                                    Platform.runLater((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            BackOfficeLightController.this.controller.alert("Gre\u0161ka prilikom upisa u bazu!", "Do\u0161lo je do gre\u0161ke prilikom upisa u bazu. Radni dan nije propisno zatvoren.", BackOfficeLightController.this.rootPane.getScene().getWindow());
                                        }
                                    });
                                    try {
                                        BackOfficeLightController.this.controller.getSettings().getConnection().rollback();
                                    }
                                    catch (SQLException e1) {
                                        e1.printStackTrace();
                                    }
                                }
                                catch (Throwable throwable) {
                                    try {
                                        BackOfficeLightController.this.controller.getSettings().getConnection().setAutoCommit(true);
                                        Platform.runLater((Runnable)new /* invalid duplicate definition of identical inner class */);
                                    }
                                    catch (SQLException e2) {
                                        e2.printStackTrace();
                                    }
                                    throw throwable;
                                }
                                try {
                                    BackOfficeLightController.this.controller.getSettings().getConnection().setAutoCommit(true);
                                    Platform.runLater((Runnable)new /* invalid duplicate definition of identical inner class */);
                                }
                                catch (SQLException e3) {
                                    e3.printStackTrace();
                                }
                            }
                        }
                    }
                }.start();
                break;
            }
            case "NVSI": {
                break;
            }
            case "JRTS": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_PRICE_LIST, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "ARTI": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_PRODUCTS, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "ARTIT": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_PRODUCTS_TRGOVINA_NEW, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "POSAT": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_ANALIZA_I_STATISTIKA_PO_SATIMA, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "PODAN": {
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_ANALIZA_I_STATISTIKA_PO_DANIMA, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DOIR": {
                this.hm = new HashMap();
                this.hm.put("documentCode", "R");
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOCUMENTS, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "INACTIVEDOIR": {
                this.hm = new HashMap();
                this.hm.put("documentCode", "R");
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_INACTIVE_DOCUMENTS, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DOIWR": {
                this.hm = new HashMap();
                this.hm.put("documentCode", "WR");
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_WEB_DOCUMENTS, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DLNZI": {
                this.hm = new HashMap();
                this.hm.put("documentCode", "NI");
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOCUMENT_CORRECTION_LIST, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DONI": {
                this.hm = new HashMap();
                this.hm.put("documentCode", "NI");
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOCUMENTS, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DOPR": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_PRIJEMNCIE, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DOPRIJT": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_PRIJEMNCIE_TRGOVINA, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DOVPF": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_VELEPRODAJNA_FAKTURA_TRGOVINA, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DOVPFCM": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_VELEPRODAJNA_FAKTURA_MAGACIN_TRGOVINA, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DOPRIJTCM": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_PRIJEMNCIE_CENTRALNI_MAGACIN_TRGOVINA, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DOPS": {
                this.hm = new HashMap();
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_POCETNO_STANJE, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DOSPP": {
                this.hm = new HashMap();
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_SRAVNJENJE_PO_POPISU, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DOPRE": {
                this.hm = new HashMap();
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_PRESIFRIRANJE, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DOPROF": {
                this.hm = new HashMap();
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_PREGLED_PROFAKTURA, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DOTP": {
                this.hm = new HashMap();
                this.hm.put("sirinaAkordijana", this.menuAccordion.getWidth());
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_PREGLED_OTPREMNICA, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DORK": {
                this.hm = new HashMap();
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_ROBNA_KARTICA, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DIOTP": {
                this.hm = new HashMap();
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_PREGLED_INTERNIH_OTPREMNICA, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DOIPR": {
                this.hm = new HashMap();
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_PREGLED_INTERNIH_PRIJEMNICA, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "RESER": {
                this.hm = new HashMap();
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_PREGLED_REZERVACIJA, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "ORDER": {
                this.hm = new HashMap();
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_PREGLED_PORUDZBENICA, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DIOTPW": {
                this.hm = new HashMap();
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_PREGLED_INTERNIH_OTPREMNICA_SKLADISTE, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DOIPRW": {
                this.hm = new HashMap();
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_PREGLED_INTERNIH_PRIJEMNICA_SKLADISTE, null);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "DOAS": {
                this.hm = new HashMap();
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_DOC_PRESIFRIRANJE, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "COCE": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_POPIS_KONTROLA_EDIT, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "COPS": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_POPIS_KONTROLA_LIST, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "ADRU": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_REKAPITULACIJA_UTROSAKA_I_NIVELACIJA, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "PRODODPO": {
                this.hm = new HashMap();
                this.hm.put("controller", this.controller);
                work = this.controller.loadFxml(ScreensController.SCREEN_BACKOFFICE_ADITIONAL_FIELDS_SALES_REPORT, this.hm);
                this.workPane.setCenter((Node)work);
                break;
            }
            case "EXIT": {
                try {
                    this.controller.getScreen(ScreensController.SCREEN_TRGOVINA, this.controller.getRoot(), ScreensController.SCREEN_BACKOFFICE);
                    break;
                }
                catch (IllegalStateException e) {
                    this.controller.getScreen(ScreensController.SCREEN_LOGIN_TRGOVINA, this.controller.getRoot(), ScreensController.SCREEN_BACKOFFICE);
                }
            }
        }
    }

    @FXML
    private void logout() {
        this.controller.getScreen(ScreensController.SCREEN_LOGIN_TRGOVINA, this.controller.getRoot(), ScreensController.SCREEN_BACKOFFICE);
    }
}

