/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice.additionalgroup;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.collections.transformation.SortedList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import rs.petcom.master.DialogController;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.product.AditionalField;
import rs.petcom.master.dal.product.AditionalFieldDetails;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.dal.product.ProductDepartment;

public class AditionalFieldsFrontControllerTrgovina
implements DialogController {
    ScreensController controller;
    private int modalResult;
    rs.petcom.master.dal.Object sviObjekti = new rs.petcom.master.dal.Object(-1, "Svi objekti");
    Department svaOdeljenja = new Department(-1, "Sva odeljenja");
    ObservableList<ProductDepartment> productDepartments;
    ObservableList<Product> products;
    @FXML
    private BorderPane rootPane;
    @FXML
    private TableView<AditionalField> tableAditionalFields;
    @FXML
    private TableColumn<AditionalField, Boolean> tcFront;
    @FXML
    private TableColumn<AditionalField, Boolean> tcBack;
    @FXML
    private TableColumn<AditionalField, String> tcNameAditionalField;
    @FXML
    private TableView<AditionalFieldDetails> tableAditionalFieldsDetails;
    @FXML
    private TableColumn<AditionalFieldDetails, String> tcNameAditionalFieldDetails;
    @FXML
    private VBox vBox1;
    @FXML
    private VBox vBox2;
    @FXML
    private TextField tfFilter;
    @FXML
    private TextField tfFilterDetails;

    public void setParameter(HashMap<String, Object> parameter) {
        this.controller = (ScreensController)parameter.get("controller");
        if (this.controller.getVrstaPrograma() == 4 || this.controller.getVrstaPrograma() == 0 || this.controller.getVrstaPrograma() == 6) {
            this.rootPane.getStylesheets().clear();
            this.rootPane.getStylesheets().add((Object)"rs/petcom/backoffice/css/trgovina/backofficeTrgovina.css");
        }
        this.vBox1.setPrefWidth(this.controller.getRoot().getScene().getWidth() * 20.0 / 100.0);
        this.vBox2.setPrefWidth(this.controller.getRoot().getScene().getWidth() * 20.0 / 100.0);
        this.loadAditionalFields();
    }

    public HashMap<String, Object> getParameter() {
        return null;
    }

    public int getModalResult() {
        return this.modalResult;
    }

    public void setModalResult(int modalResult) {
        this.modalResult = modalResult;
    }

    public void initialize() {
        this.tcNameAditionalField.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tcFront.setCellValueFactory((Callback)new PropertyValueFactory("Front"));
        this.tcFront.setCellFactory(column -> new TableCell<AditionalField, Boolean>(){

            protected void updateItem(Boolean item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!empty) {
                    if (!item.booleanValue()) {
                        this.setText("Ne");
                    } else {
                        this.setText("Da");
                    }
                } else {
                    this.setText("");
                }
            }
        });
        this.tcBack.setCellValueFactory((Callback)new PropertyValueFactory("Backoffice"));
        this.tcBack.setCellFactory(column -> new TableCell<AditionalField, Boolean>(){

            protected void updateItem(Boolean item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!empty) {
                    if (!item.booleanValue()) {
                        this.setText("Ne");
                    } else {
                        this.setText("Da");
                    }
                } else {
                    this.setText("");
                }
            }
        });
        this.tcNameAditionalFieldDetails.setCellValueFactory((Callback)new PropertyValueFactory("Name"));
        this.tcNameAditionalFieldDetails.setStyle("-fx-alignment: CENTER-LEFT;");
        this.tcNameAditionalFieldDetails.setCellFactory(TextFieldTableCell.forTableColumn());
        this.tcNameAditionalFieldDetails.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<AditionalFieldDetails, String>>(){

            public void handle(TableColumn.CellEditEvent<AditionalFieldDetails, String> t) {
                ((AditionalFieldDetails)t.getTableView().getItems().get(t.getTablePosition().getRow())).setName((String)t.getNewValue());
                AditionalFieldDetails aditionalFieldDetails = (AditionalFieldDetails)t.getTableView().getItems().get(t.getTablePosition().getRow());
                aditionalFieldDetails.update(AditionalFieldsFrontControllerTrgovina.this.controller.getSettings().getConnection());
            }
        });
        this.tableAditionalFields.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<AditionalField>(){

            public void onChanged(ListChangeListener.Change<? extends AditionalField> arg0) {
                AditionalFieldsFrontControllerTrgovina.this.loadAditionalFieldsDetails();
            }
        });
    }

    @FXML
    public void actionAdd(ActionEvent event) {
        HashMap<String, ScreensController> hm = new HashMap<String, ScreensController>();
        hm.put("controller", this.controller);
        hm.put("aditionalField", null);
        this.controller.showModalDialog("Otpis - Detalji", ScreensController.SCREEN_BACKOFFICE_SIFRARNICI_ADITIONAL_FIELDS_DIALOG, hm, this.rootPane.getScene().getWindow());
        this.refreshField();
        this.refreshFieldDetails();
    }

    @FXML
    public void actionUpdate(ActionEvent event) {
        if (this.tableAditionalFields.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("aditionalField", this.tableAditionalFields.getSelectionModel().getSelectedItem());
            this.controller.showModalDialog("Otpis - Detalji", ScreensController.SCREEN_BACKOFFICE_SIFRARNICI_ADITIONAL_FIELDS_DIALOG, hm, this.rootPane.getScene().getWindow());
            this.refreshField();
            this.refreshFieldDetails();
        } else {
            this.controller.alert("Obavestenje", "Morate odabrati dodatnu grupu u tabeli, koju zelite da izmenite", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    public void actionAddDetails(ActionEvent event) {
        if (this.tableAditionalFields.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("aditionalFieldDetails", null);
            hm.put("aditionalField", this.tableAditionalFields.getSelectionModel().getSelectedItem());
            this.controller.showModalDialog("Otpis - Detalji", ScreensController.SCREEN_BACKOFFICE_SIFRARNICI_ADITIONAL_FIELDS_SUBGROUP_DIALOG, hm, this.rootPane.getScene().getWindow());
            this.refreshField();
            this.refreshFieldDetails();
        } else {
            this.controller.alert("Obavestenje", "Morate odabrati dodatnu grupu u tabeli, kojoj zelite da dodate podgrupu", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    public void actionUpdateDetails(ActionEvent event) {
        if (this.tableAditionalFieldsDetails.getSelectionModel().getSelectedItem() != null) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("aditionalField", this.tableAditionalFields.getSelectionModel().getSelectedItem());
            hm.put("aditionalFieldDetails", this.tableAditionalFieldsDetails.getSelectionModel().getSelectedItem());
            this.controller.showModalDialog("Otpis - Detalji", ScreensController.SCREEN_BACKOFFICE_SIFRARNICI_ADITIONAL_FIELDS_SUBGROUP_DIALOG, hm, this.rootPane.getScene().getWindow());
            this.refreshField();
            this.refreshFieldDetails();
        } else {
            this.controller.alert("Obavestenje", "Morate odabrati dodatnu podgrupu u tabeli, koju zelite da izmenite", this.rootPane.getScene().getWindow());
        }
    }

    @FXML
    public void actionDelete(ActionEvent event) {
        if (this.tableAditionalFields.getSelectionModel().getSelectedItem() != null) {
            try {
                ((AditionalField)this.tableAditionalFields.getSelectionModel().getSelectedItem()).delete(this.controller.getSettings().getConnection());
                this.refreshField();
            }
            catch (SQLException e) {
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no obrisano polje: " + e.getMessage(), this.rootPane.getScene().getWindow());
                e.printStackTrace();
            }
        }
    }

    @FXML
    public void actionDeleteDetails(ActionEvent event) {
        if (this.tableAditionalFieldsDetails.getSelectionModel().getSelectedItem() != null) {
            try {
                ((AditionalFieldDetails)this.tableAditionalFieldsDetails.getSelectionModel().getSelectedItem()).delete(this.controller.getSettings().getConnection());
                this.refreshFieldDetails();
            }
            catch (SQLException e) {
                this.controller.alert("Obave\u0161tenje", "Neuspe\u0161no obrisano polje: " + e.getMessage(), this.rootPane.getScene().getWindow());
                e.printStackTrace();
            }
        }
    }

    @FXML
    private void closeAction() {
        this.modalResult = ScreensController.MODAL_RESULT_CANCEL;
        ((Stage)this.rootPane.getScene().getWindow()).close();
    }

    private void loadAditionalFields() {
        this.tfFilter.setText("");
        this.tableAditionalFields.setItems(AditionalField.getList((Connection)this.controller.getSettings().getConnection()));
        this.filter();
    }

    private void loadAditionalFieldsDetails() {
        this.tfFilterDetails.setText("");
        try {
            this.tableAditionalFieldsDetails.setItems(AditionalFieldDetails.getListByAditionalFieldID((long)((AditionalField)this.tableAditionalFields.getSelectionModel().getSelectedItem()).getAditionalFieldID(), (Connection)this.controller.getSettings().getConnection()));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.filterDetails();
    }

    private void refreshField() {
        this.tableAditionalFields.getSelectionModel().clearSelection();
        this.loadAditionalFields();
        this.tableAditionalFields.refresh();
    }

    private void refreshFieldDetails() {
        this.tableAditionalFieldsDetails.getSelectionModel().clearSelection();
        this.loadAditionalFieldsDetails();
        this.tableAditionalFieldsDetails.refresh();
    }

    private void filter() {
        FilteredList filteredData = new FilteredList(this.tableAditionalFields.getItems(), p -> true);
        this.tfFilter.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(aditionalField -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return aditionalField.getName().toLowerCase().contains(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.tableAditionalFields.comparatorProperty());
        this.tableAditionalFields.setItems((ObservableList)sortedData);
    }

    private void filterDetails() {
        FilteredList filteredData = new FilteredList(this.tableAditionalFieldsDetails.getItems(), p -> true);
        this.tfFilterDetails.textProperty().addListener((observable, oldValue, newValue) -> filteredData.setPredicate(aditionalFieldDetails -> {
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String lowerCaseFilter = newValue.toLowerCase();
            return aditionalFieldDetails.getName().toLowerCase().contains(lowerCaseFilter);
        }));
        SortedList sortedData = new SortedList((ObservableList)filteredData);
        sortedData.comparatorProperty().bind((ObservableValue)this.tableAditionalFieldsDetails.comparatorProperty());
        this.tableAditionalFieldsDetails.setItems((ObservableList)sortedData);
    }
}

