/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.backoffice;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.IpAddress;

public class Main
extends Application {
    private ScreensController screensController = null;
    private StackPane root = new StackPane();

    public void start(final Stage primaryStage) {
        ResourceBundle bundle;
        File file = new File("./ipaddress.cnf");
        if (!file.exists()) {
            file = new File("./ipaddress.cnf");
            try {
                FileOutputStream outputStream = new FileOutputStream("./ipaddress.cnf");
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
                bufferedWriter.write("osnovna=localhost;masterdb");
                bufferedWriter.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        IpAddress ipAddress = new IpAddress();
        ipAddress.getList();
        if (ipAddress.getIpAddressList().size() > 1) {
            Locale.setDefault(new Locale("sr"));
            bundle = ResourceBundle.getBundle("locale");
            this.screensController = new ScreensController(5, ipAddress);
            this.screensController.setRoot(this.root);
            this.screensController.setBundle(bundle);
            this.screensController.getScreen(ScreensController.DIALOG_CHOOSE_IP_ADDRESS, this.root, "");
        } else {
            Locale.setDefault(new Locale("sr"));
            bundle = ResourceBundle.getBundle("locale");
            this.screensController = new ScreensController(0, (IpAddress)ipAddress.getIpAddressList().get(0));
            this.screensController.setRoot(this.root);
            this.screensController.setBundle(bundle);
            this.screensController.getScreen(ScreensController.SCREEN_LOGIN_TRGOVINA, this.root, "");
        }
        try {
            Scene scene = new Scene((Parent)this.root);
            primaryStage.setFullScreenExitKeyCombination((KeyCombination)new KeyCodeCombination(KeyCode.ESCAPE, new KeyCombination.Modifier[0]));
            primaryStage.setMaximized(this.screensController.getSettings().isFullscreen());
            primaryStage.maximizedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                    if (newValue.booleanValue()) {
                        primaryStage.setMaximized(true);
                    }
                }
            });
            primaryStage.setTitle("Tmaster - 5COM D.O.O.");
            primaryStage.setScene(scene);
            primaryStage.getIcons().add((Object)new Image("rs/petcom/master/img/T.jpg"));
            primaryStage.show();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Main.launch((String[])args);
    }
}

