/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.print;

import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Locale;
import java.util.ResourceBundle;
import javafx.concurrent.Task;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Separator;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.stage.Modality;
import javafx.stage.Screen;
import javafx.stage.Stage;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;

public class JRPrintPreview
extends Stage {
    public static final int REPORT_DPI_RESOLUTION = 72;
    protected final int SPACING = 25;
    protected final float MIN_ZOOM = 0.5f;
    protected final float MAX_ZOOM = 10.0f;
    protected final int[] zooms = new int[]{50, 75, 100, 125, 150, 175, 200, 250, 400, 800};
    protected float zoom = 0.0f;
    protected float realZoom = 0.0f;
    protected DecimalFormat zoomDecimalFormat = new DecimalFormat("#.##");
    protected JasperPrint jasperPrint;
    protected double screenResolution = 72.0;
    protected JasperReportsContext jasperReportsContext;
    protected ResourceBundle resourceBundle;
    protected ToggleButton btnActualSize = new ToggleButton();
    protected ToggleButton btnFitPage = new ToggleButton();
    protected ToggleButton btnFitWidth = new ToggleButton();
    protected Button btnFirst = new Button();
    protected Button btnLast = new Button();
    protected Button btnNext = new Button();
    protected Button btnPrevious = new Button();
    protected Button btnPrint = new Button();
    protected Button btnZoomIn = new Button();
    protected Button btnZoomOut = new Button();
    protected ComboBox<String> cmbZoom = new ComboBox();
    protected Label lblStatus = new Label();
    protected VBox vBoxPage = new VBox();
    protected HBox statusBar = new HBox();
    protected ScrollPane scrollPane = new ScrollPane();
    protected ToolBar toolBar = new ToolBar();
    protected TextField txtGoTo = new TextField();
    protected DropShadow dropShadow = new DropShadow();
    protected int pageIndex;

    public JRPrintPreview(JasperPrint jasperPrint) {
        this(jasperPrint, null);
    }

    public JRPrintPreview(JasperPrint jasperPrint, ResourceBundle resBundle) {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance(), jasperPrint, resBundle);
    }

    public JRPrintPreview(JasperReportsContext jasperReportsContext, JasperPrint jasperPrint, ResourceBundle resBundle) {
        this.jasperReportsContext = jasperReportsContext;
        this.jasperPrint = jasperPrint;
        this.initResources(resBundle);
        this.screenResolution = Screen.getPrimary().getDpi();
        this.initComponents();
        this.setZoomRatio(1.0f);
        double width = this.vBoxPage.getBoundsInParent().getWidth() + 50.0 + 13.0;
        this.setWidth(width > 1000.0 ? 1000.0 : width);
    }

    protected void initResources(ResourceBundle resBundle) {
        this.resourceBundle = resBundle == null ? ResourceBundle.getBundle("net/sf/jasperreports/view/viewer", Locale.getDefault()) : resBundle;
    }

    private void initComponents() {
        this.setTitle("Print preview");
        this.initModality(Modality.APPLICATION_MODAL);
        ToggleGroup group = new ToggleGroup();
        this.btnActualSize.setToggleGroup(group);
        this.btnFitPage.setToggleGroup(group);
        this.btnFitWidth.setToggleGroup(group);
        this.btnActualSize.setSelected(true);
        this.setMinHeight(150.0);
        this.setMinWidth(500.0);
        this.setHeight(480.0);
        this.btnPrint.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/print.GIF"))));
        this.btnPrint.setTooltip(new Tooltip(this.resourceBundle.getString("print")));
        this.btnPrint.setPrefSize(23.0, 23.0);
        this.btnPrint.setOnAction(e -> this.onBtnPrint());
        this.btnPrint.setFocusTraversable(false);
        this.btnFirst.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/first.GIF"))));
        this.btnFirst.setTooltip(new Tooltip(this.resourceBundle.getString("first.page")));
        this.btnFirst.setPrefSize(23.0, 23.0);
        this.btnFirst.setOnAction(e -> this.onBtnFirstPressed());
        this.btnFirst.setFocusTraversable(false);
        this.btnPrevious.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/previous.GIF"))));
        this.btnPrevious.setTooltip(new Tooltip(this.resourceBundle.getString("previous.page")));
        this.btnPrevious.setPrefSize(23.0, 23.0);
        this.btnPrevious.setOnAction(e -> this.onBtnPreviousPressed());
        this.btnPrevious.setFocusTraversable(false);
        this.btnNext.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/next.GIF"))));
        this.btnNext.setTooltip(new Tooltip(this.resourceBundle.getString("next.page")));
        this.btnNext.setPrefSize(23.0, 23.0);
        this.btnNext.setOnAction(e -> this.onBtnNextPressed());
        this.btnNext.setFocusTraversable(false);
        this.btnLast.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/last.GIF"))));
        this.btnLast.setTooltip(new Tooltip(this.resourceBundle.getString("last.page")));
        this.btnLast.setPrefSize(23.0, 23.0);
        this.btnLast.setOnAction(e -> this.onBtnLastPressed());
        this.btnLast.setFocusTraversable(false);
        this.txtGoTo.setTooltip(new Tooltip(this.resourceBundle.getString("go.to.page")));
        this.txtGoTo.setAlignment(Pos.CENTER);
        this.txtGoTo.setPrefSize(40.0, 23.0);
        this.txtGoTo.setOnAction(e -> this.onGoToTextChanged());
        this.txtGoTo.setFocusTraversable(false);
        this.btnActualSize.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/actualsize.GIF"))));
        this.btnActualSize.setTooltip(new Tooltip(this.resourceBundle.getString("actual.size")));
        this.btnActualSize.setPrefSize(23.0, 23.0);
        this.btnActualSize.setOnAction(e -> {
            if (((ToggleButton)e.getSource()).isSelected()) {
                this.onActualSizePressed();
            }
        });
        this.btnActualSize.setFocusTraversable(false);
        this.btnFitPage.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/fitpage.GIF"))));
        this.btnFitPage.setTooltip(new Tooltip(this.resourceBundle.getString("fit.page")));
        this.btnFitPage.setPrefSize(23.0, 23.0);
        this.btnFitPage.setOnAction(e -> {
            if (((ToggleButton)e.getSource()).isSelected()) {
                this.onFitPagePressed();
            }
        });
        this.btnFitPage.setFocusTraversable(false);
        this.btnFitWidth.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/fitwidth.GIF"))));
        this.btnFitWidth.setTooltip(new Tooltip(this.resourceBundle.getString("fit.width")));
        this.btnFitWidth.setPrefSize(23.0, 23.0);
        this.btnFitWidth.setOnAction(e -> {
            if (((ToggleButton)e.getSource()).isSelected()) {
                this.onSetFitToWidthPressed();
            }
        });
        this.btnFitWidth.setFocusTraversable(false);
        this.toolBar.getItems().addAll((Object[])new Node[]{this.btnActualSize, this.btnFitPage, this.btnFitWidth, new Separator(), this.btnZoomIn, this.btnZoomOut, this.cmbZoom, new Separator(), this.btnFirst, this.btnPrevious, this.txtGoTo, this.btnNext, this.btnLast, new Separator(), this.btnPrint});
        this.btnZoomIn.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/zoomin.GIF"))));
        this.btnZoomIn.setTooltip(new Tooltip(this.resourceBundle.getString("zoom.in")));
        this.btnZoomIn.setPrefSize(23.0, 23.0);
        this.btnZoomIn.setOnAction(e -> this.onBtnZoomIn());
        this.btnZoomIn.setFocusTraversable(false);
        this.btnZoomOut.setGraphic((Node)new ImageView(new Image(((Object)((Object)this)).getClass().getResourceAsStream("/net/sf/jasperreports/view/images/zoomout.GIF"))));
        this.btnZoomOut.setTooltip(new Tooltip(this.resourceBundle.getString("zoom.out")));
        this.btnZoomOut.setPrefSize(23.0, 23.0);
        this.btnZoomOut.setOnAction(e -> this.onBtnZoomOut());
        this.btnZoomOut.setFocusTraversable(false);
        this.cmbZoom.setEditable(true);
        this.cmbZoom.setTooltip(new Tooltip(this.resourceBundle.getString("zoom.ratio")));
        this.cmbZoom.setPrefSize(80.0, 24.0);
        for (int zoom : this.zooms) {
            this.cmbZoom.getItems().add((Object)(zoom + "%"));
        }
        this.cmbZoom.getSelectionModel().select(2);
        this.cmbZoom.setFocusTraversable(false);
        this.cmbZoom.setOnAction(e -> this.onComboBoxZoomChanged());
        this.cmbZoom.addEventHandler(KeyEvent.KEY_PRESSED, e -> {
            if (e.getCode() == KeyCode.ENTER) {
                this.onComboBoxZoomChanged();
            }
        });
        this.vBoxPage.setSpacing(25.0);
        this.vBoxPage.setPadding(new Insets(25.0));
        this.vBoxPage.setAlignment(Pos.CENTER);
        this.scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
        this.scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.scrollPane.setContent((Node)this.vBoxPage);
        this.scrollPane.viewportBoundsProperty().addListener((arg0, arg1, arg2) -> {
            if (this.btnFitWidth.isSelected()) {
                this.onSetFitToWidthPressed();
            }
            this.scrollPane.setFitToWidth(this.vBoxPage.prefWidth(-1.0) < arg2.getWidth());
            this.scrollPane.setFitToHeight(this.vBoxPage.prefHeight(-1.0) < arg2.getHeight());
        });
        this.scrollPane.vvalueProperty().addListener((observable, oldValue, newValue) -> {
            double low;
            double hi;
            int pagesNo = this.jasperPrint.getPages().size();
            double pageInterval = 1.0 / (double)pagesNo;
            int tmpPageIndex = this.pageIndex;
            if (hi < newValue.doubleValue() && this.pageIndex < pagesNo) {
                for (hi = low + pageInterval; hi < newValue.doubleValue(); hi += pageInterval) {
                    ++tmpPageIndex;
                }
                this.setPageIndex(tmpPageIndex);
            } else if (low > newValue.doubleValue() && this.pageIndex > 0) {
                for (low = (double)this.pageIndex * pageInterval; low > newValue.doubleValue(); low -= pageInterval) {
                    --tmpPageIndex;
                }
                this.setPageIndex(tmpPageIndex);
            }
        });
        this.lblStatus.setFont(new Font("Dialog", 10.0));
        this.statusBar.setAlignment(Pos.CENTER);
        this.statusBar.setMaxHeight(24.0);
        this.statusBar.getChildren().add((Object)this.lblStatus);
        VBox root = new VBox();
        VBox.setVgrow((Node)this.scrollPane, (Priority)Priority.ALWAYS);
        root.getChildren().addAll((Object[])new Node[]{this.toolBar, this.scrollPane, this.statusBar});
        this.setScene(new Scene((Parent)root));
        this.dropShadow.setColor(Color.GREY);
        this.dropShadow.setOffsetX(2.0);
        this.dropShadow.setOffsetY(2.0);
    }

    protected void refresh() {
        this.vBoxPage.getChildren().clear();
        for (int pageIndex = 0; pageIndex < this.jasperPrint.getPages().size(); ++pageIndex) {
            try {
                BufferedImage awtImage = (BufferedImage)JasperPrintManager.getInstance((JasperReportsContext)this.jasperReportsContext).printToImage(this.jasperPrint, pageIndex, this.realZoom);
                WritableImage image = SwingFXUtils.toFXImage((BufferedImage)awtImage, null);
                ImageView iv = new ImageView((Image)image);
                iv.setEffect((Effect)this.dropShadow);
                this.setPageIndex(0);
                this.vBoxPage.getChildren().add((Object)iv);
                continue;
            }
            catch (JRException ex) {
                ex.printStackTrace();
            }
        }
    }

    protected void setZoomRatio(float newZoom) {
        if (newZoom > 0.0f) {
            this.cmbZoom.getEditor().setText(this.zoomDecimalFormat.format(newZoom * 100.0f) + "%");
            if (this.zoom != newZoom) {
                this.zoom = newZoom;
                this.realZoom = (float)((double)this.zoom * this.screenResolution / 72.0);
                this.refresh();
            }
        }
        this.btnZoomIn.setDisable(this.zoom >= (float)this.zooms[this.zooms.length - 1] / 100.0f);
        this.btnZoomOut.setDisable(this.zoom <= (float)this.zooms[0] / 100.0f);
    }

    private void setRealZoomRatio(float newZoom) {
        if (newZoom > 0.0f && this.realZoom != newZoom) {
            this.zoom = (float)((double)(newZoom * 72.0f) / this.screenResolution);
            this.realZoom = newZoom;
            this.cmbZoom.getEditor().setText(this.zoomDecimalFormat.format(this.zoom * 100.0f) + "%");
            this.refresh();
        }
        this.btnZoomIn.setDisable(this.zoom >= (float)this.zooms[this.zooms.length - 1] / 100.0f);
        this.btnZoomOut.setDisable(this.zoom <= (float)this.zooms[0] / 100.0f);
    }

    protected int getZoomRatio() {
        try {
            return this.zoomDecimalFormat.parse(this.cmbZoom.getEditor().getText()).intValue();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return (int)this.zoom;
        }
    }

    private void onBtnZoomIn() {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
        int index = Arrays.binarySearch(this.zooms, this.getZoomRatio());
        if (index < 0) {
            this.cmbZoom.getSelectionModel().select((Object)(this.zoomDecimalFormat.format(this.zooms[-index - 1]) + "%"));
        } else if (index < this.cmbZoom.getItems().size() - 1) {
            this.cmbZoom.getSelectionModel().select((Object)(this.zoomDecimalFormat.format(this.zooms[index + 1]) + "%"));
        }
    }

    private void onBtnZoomOut() {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
        int index = Arrays.binarySearch(this.zooms, this.getZoomRatio());
        if (index > 0) {
            this.cmbZoom.getSelectionModel().select((Object)(this.zoomDecimalFormat.format(this.zooms[index - 1]) + "%"));
        } else if (index < -1) {
            this.cmbZoom.getSelectionModel().select((Object)(this.zoomDecimalFormat.format(this.zooms[-index - 2]) + "%"));
        }
    }

    private void onComboBoxZoomChanged() {
        try {
            if (this.cmbZoom.getValue() != null) {
                float newZoom = this.zoomDecimalFormat.parse((String)this.cmbZoom.getValue()).floatValue() / 100.0f;
                if (newZoom < 0.5f) {
                    newZoom = 0.5f;
                }
                if (newZoom > 10.0f) {
                    newZoom = 10.0f;
                }
                this.setZoomRatio(newZoom);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private void onGoToTextChanged() {
        try {
            int pageNumber = Integer.parseInt(this.txtGoTo.getText());
            if (pageNumber > 0 && pageNumber <= this.jasperPrint.getPages().size()) {
                this.setPage(pageNumber - 1);
            }
        }
        catch (NumberFormatException e) {
            this.setPageIndex(this.pageIndex);
        }
    }

    private void onBtnFirstPressed() {
        this.setPage(0);
    }

    private void onBtnPreviousPressed() {
        this.setPage(this.pageIndex - 1);
    }

    private void onBtnNextPressed() {
        this.setPage(this.pageIndex + 1);
    }

    private void onBtnLastPressed() {
        this.setPage(this.jasperPrint.getPages().size() - 1);
    }

    private void setPage(int index) {
        double contentsHeight = this.vBoxPage.getBoundsInLocal().getHeight();
        double viewportHeight = this.scrollPane.getViewportBounds().getHeight();
        ImageView iv = (ImageView)this.vBoxPage.getChildren().get(index);
        this.scrollPane.setVvalue(iv.getBoundsInParent().getMinY() / (contentsHeight - viewportHeight));
        this.setPageIndex(index);
    }

    protected void setPageIndex(int index) {
        int pagesNo = this.jasperPrint.getPages().size();
        this.btnFirst.setDisable(index == 0);
        this.btnPrevious.setDisable(index == 0);
        this.btnLast.setDisable(index == pagesNo - 1);
        this.btnNext.setDisable(index == pagesNo - 1);
        this.txtGoTo.setDisable(pagesNo == 1);
        this.txtGoTo.setText(String.valueOf(index + 1));
        this.lblStatus.setText(MessageFormat.format(this.resourceBundle.getString("page"), index + 1, pagesNo));
        this.pageIndex = index;
    }

    private void onSetFitToWidthPressed() {
        this.cmbZoom.getSelectionModel().clearSelection();
        this.setRealZoomRatio((float)(this.scrollPane.getViewportBounds().getWidth() - 50.0 - 2.0) / (float)this.jasperPrint.getPageFormat(this.pageIndex).getPageWidth().intValue());
    }

    private void onActualSizePressed() {
        this.cmbZoom.getSelectionModel().select(2);
    }

    private void onFitPagePressed() {
        PrintPageFormat pageFormat = this.jasperPrint.getPageFormat(this.pageIndex);
        float heightRatio = ((float)this.scrollPane.getViewportBounds().getHeight() - 50.0f) / (float)pageFormat.getPageHeight().intValue();
        float widthRatio = ((float)this.scrollPane.getViewportBounds().getWidth() - 50.0f) / (float)pageFormat.getPageWidth().intValue();
        this.cmbZoom.getSelectionModel().clearSelection();
        this.setRealZoomRatio(heightRatio < widthRatio ? heightRatio : widthRatio);
    }

    private void onBtnPrint() {
        Task<Boolean> task = new Task<Boolean>(){

            protected Boolean call() throws Exception {
                try {
                    JRPrintPreview.this.btnPrint.setDisable(true);
                    JRPrintPreview.this.getScene().setCursor(Cursor.WAIT);
                    Boolean bl = JasperPrintManager.getInstance((JasperReportsContext)JRPrintPreview.this.jasperReportsContext).print(JRPrintPreview.this.jasperPrint, true);
                    return bl;
                }
                catch (JRException ex) {
                    ex.printStackTrace();
                }
                finally {
                    JRPrintPreview.this.getScene().setCursor(Cursor.DEFAULT);
                    JRPrintPreview.this.btnPrint.setDisable(false);
                }
                return false;
            }
        };
        task.run();
    }
}

