/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.print;

import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;

public class DynamicReportBuilder {
    public static final String COL_EXPR_PREFIX = "col";
    public static final String COL_HEADER_EXPR_PREFIX = "header";
    private static final int TOTAL_PAGE_WIDTH = 545;
    private static final int SPACE_BETWEEN_COLS = 5;
    private static final int COLUMN_HEIGHT = 12;
    private static final int BAND_HEIGHT = 15;
    private static final int MARGIN = 10;
    private JasperDesign jasperDesign;
    private int numColumns;

    public DynamicReportBuilder(JasperDesign jasperDesign, int numColumns) {
        this.jasperDesign = jasperDesign;
        this.numColumns = numColumns;
    }

    public void addDynamicColumns() throws JRException {
        JRDesignBand detailBand = new JRDesignBand();
        JRDesignBand headerBand = new JRDesignBand();
        JRDesignStyle normalStyle = this.getNormalStyle();
        JRDesignStyle columnHeaderStyle = this.getColumnHeaderStyle();
        this.jasperDesign.addStyle((JRStyle)normalStyle);
        this.jasperDesign.addStyle((JRStyle)columnHeaderStyle);
        int xPos = 10;
        int columnWidth = (545 - 5 * (this.numColumns - 1)) / this.numColumns;
        for (int i = 0; i < this.numColumns; ++i) {
            JRDesignField field = new JRDesignField();
            field.setName(COL_EXPR_PREFIX + i);
            field.setValueClass(String.class);
            this.jasperDesign.addField((JRField)field);
            JRDesignField headerField = new JRDesignField();
            headerField.setName(COL_HEADER_EXPR_PREFIX + i);
            headerField.setValueClass(String.class);
            this.jasperDesign.addField((JRField)headerField);
            headerBand.setHeight(15);
            JRDesignTextField colHeaderField = new JRDesignTextField();
            colHeaderField.setX(xPos);
            colHeaderField.setY(2);
            colHeaderField.setWidth(columnWidth);
            colHeaderField.setHeight(12);
            colHeaderField.setStyle((JRStyle)columnHeaderStyle);
            JRDesignExpression headerExpression = new JRDesignExpression();
            headerExpression.setText("$F{header" + i + "}");
            colHeaderField.setExpression((JRExpression)headerExpression);
            headerBand.addElement((JRDesignElement)colHeaderField);
            detailBand.setHeight(15);
            JRDesignTextField textField = new JRDesignTextField();
            textField.setX(xPos);
            textField.setY(2);
            textField.setWidth(columnWidth);
            textField.setHeight(12);
            textField.setStyle((JRStyle)normalStyle);
            JRDesignExpression expression = new JRDesignExpression();
            expression.setText("$F{col" + i + "}");
            textField.setExpression((JRExpression)expression);
            detailBand.addElement((JRDesignElement)textField);
            xPos = xPos + columnWidth + 5;
        }
        this.jasperDesign.setColumnHeader((JRBand)headerBand);
        ((JRDesignSection)this.jasperDesign.getDetailSection()).addBand((JRBand)detailBand);
    }

    private JRDesignStyle getNormalStyle() {
        JRDesignStyle normalStyle = new JRDesignStyle();
        normalStyle.setName("Sans_Normal");
        normalStyle.setDefault(true);
        normalStyle.setFontName("SansSerif");
        normalStyle.setPdfFontName("Helvetica");
        normalStyle.setPdfEncoding("Cp1252");
        normalStyle.setPdfEmbedded(false);
        return normalStyle;
    }

    private JRDesignStyle getColumnHeaderStyle() {
        JRDesignStyle columnHeaderStyle = new JRDesignStyle();
        columnHeaderStyle.setName("Sans_Header");
        columnHeaderStyle.setDefault(false);
        columnHeaderStyle.setFontName("SansSerif");
        columnHeaderStyle.setBold(true);
        columnHeaderStyle.setPdfFontName("Helvetica");
        columnHeaderStyle.setPdfEncoding("Cp1252");
        columnHeaderStyle.setPdfEmbedded(false);
        return columnHeaderStyle;
    }
}

