/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.utility;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDate;
import java.util.Map;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Kep;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.product.AditionalField;
import rs.petcom.master.dal.product.Product;

public class KepUtility {
    private ScreensController controller;
    private Connection connection;
    private final int INITIAL_STOCK = 0;
    private final int INITIAL_STOCK_EOY = 11;

    public KepUtility(ScreensController controller) {
        this.controller = controller;
        this.connection = controller.getSettings().getConnection();
    }

    public ObservableList<Kep> getKep(LocalDate fromDate, LocalDate toDate, long wdIdFrom, long wdIdTo, Map<String, Double> sumarizedValues) {
        ObservableList kepList = FXCollections.observableArrayList();
        Date from = Settings.sqlDateFromLocalDate(fromDate);
        Date to = Settings.sqlDateFromLocalDate(toDate);
        double sum_debit = 0.0;
        double sum_debitReleaf = 0.0;
        String parameterQuery = "SET @dateFrom = CAST(? AS DATE), @dateTo = CAST(? AS DATE), @workDayFrom = ? , @workDayTo = ? ;";
        String query = "SELECT * FROM\r\n(\tSELECT \r\n\tCAST(d.Date AS DATE) AS documentDate, ROUND(SUM(dd.Quantity * dd.NewPrice),2) \tAS documentValue,\r\n\tCONCAT ('Po\u010detno Stanje: ', d.Number,'/',d.Year) AS description, 1 AS debit, d.DocumentId , 0 AS docType\r\n\t\r\n \tFROM document d\r\n\t\tJOIN documentdetails dd ON d.DocumentID = dd.DocumentID\r\n\t\tWHERE d.DocumentTypeID = 11 \r\n\t\tAND CAST(d.Date AS DATE) BETWEEN @dateFrom AND @dateTo\r\ngroup BY d.DocumentID\r\n\r\n\tUNION \r\n\t\r\n\tSELECT documentDate, (documentValue  - servicesValue) AS documentValue, description, debit, DocumentId, docType FROM(\r\n\tSELECT CAST(d.Date AS DATE) AS documentDate, \r\n\tROUND(SUM(d.SumWithDiscount),2) AS documentValue,\r\n\tCOALESCE((SELECT ROUND(SUM(dd1.Quantity * dd1.PriceWithDiscount),2) FROM documentdetails dd1\r\n\t\tJOIN document d1 ON dd1.DocumentID = d1.DocumentID\r\n\t\tWHERE d1.DocumentTypeID = 22 AND CAST(d1.Date AS DATE) = CAST(d.Date AS DATE) ),0)AS Ni,\r\n\tCOALESCE(\r\n\t(SELECT ROUND(SUM(dd.Quantity * dd.PriceWithDiscount),2) FROM documentdetails dd \r\n\tJOIN document d1 ON dd.DocumentID = d1.DocumentID\r\n\tJOIN product p ON dd.ProductID = p.ProductID\r\n\t\tWHERE d1.DocumentTypeID = 3  AND d1.WorkDayID =d.WorkDayID AND p.ProductCategoryID =2),0) AS servicesValue,\r\n\t'Dnevni Pazar' AS description, 0 AS debit, d.DocumentId, 1 AS docType\r\n\t\r\n\tFROM document d \r\n\t\tWHERE d.DocumentTypeID = 3 AND d.DocumentStatusID =1\r\n\t\tAND d.WorkDayID BETWEEN @workDayFrom AND @workDayTo \r\ngroup BY d.WorkDayID) AS trt\r\n\r\n\tUNION\r\n\t\r\nSELECT \r\n\tCAST(d.DeliveryDate AS DATE) AS documentDate, ROUND(SUM(dd.Quantity * dd.NewPrice),2) \tAS documentValue,\r\n\tCONCAT ('Kalkulacija: ', d.Number,'/',d.Year,', ', p.Name) AS description, 1 AS debit, d.DocumentId , 2 AS docType\r\n\t\r\n \tFROM document d\r\n\t\tJOIN documentdetails dd ON d.DocumentID = dd.DocumentID\r\n\t\tJOIN person p ON d.PersonID = p.PersonID\r\n\t\tWHERE d.DocumentTypeID = 1 \r\n\t\tAND CAST(d.DeliveryDate AS DATE) BETWEEN @dateFrom AND @dateTo\r\ngroup BY d.DocumentID\r\n\r\n\tUNION \r\n\r\nSELECT\r\n\tCAST(d.Date AS DATE) AS documentDate, ROUND(SUM(dd.Quantity*(dd.NewPrice - dd.Price)),2) AS documentValue, \r\n\tCONCAT('Nivelacija: ', d.Number , '/',d.Year) AS description, 1 AS debit, d.DocumentId, 3 AS docType\r\n\t\r\n\tFROM document d\r\n\t\tJOIN documentdetails dd ON d.DocumentID = dd.DocumentID\r\n\t\tWHERE d.DocumentTypeID = 15\r\n\t\tAND CAST(d.Date AS DATE) BETWEEN @dateFrom AND @dateTo\r\ngroup BY d.DocumentID \r\n\r\n\tUNION\r\n\r\nSELECT\r\n\tCAST(d.Date AS DATE) AS documentDate, ROUND(SUM(dd.Quantity * dd.Price * -1),2) AS documentValue,\r\n\tCONCAT('Nalog za ispravku: ', d.Number , '/',d.Year) AS description, 0 AS debit, d.DocumentId, 4 AS docType\r\n\t\r\n\tFROM document d\r\n\t\tJOIN documentdetails dd ON d.DocumentID = dd.DocumentID\r\n\t\tWHERE d.DocumentTypeID = 22\r\n\t\tAND CAST(d.Date AS DATE) BETWEEN @dateFrom AND @dateTo\r\ngroup BY d.DocumentID \t\r\n\r\n\tUNION\r\n\r\nSELECT \r\n\tCAST(d.Date AS DATE) AS documentDate, ROUND(SUM(dd.Quantity * dd.NewPrice * -1),2) \tAS documentValue,\r\n\tCONCAT ('Povrat dobavlja\u010du: ', d.Number,'/',d.Year) AS description, 1 AS debit, d.DocumentId, 5 AS docType\r\n\t\r\n \tFROM document d\r\n\t\tJOIN documentdetails dd ON d.DocumentID = dd.DocumentID\r\n\t\tWHERE d.DocumentTypeID = 9 \r\n\t\tAND CAST(d.Date AS DATE) BETWEEN @dateFrom AND @dateTo\r\ngroup BY d.DocumentID\r\n\r\n\tUNION \r\n\r\nSELECT \r\n\tCAST(d.Date AS DATE) AS documentDate, ROUND(SUM(dd.Quantity * dd.NewPrice * -1),2) \tAS documentValue,\r\n\tCONCAT ('Otpis: ', d.Number,'/',d.Year) AS description, 1 AS debit, d.DocumentId, 6 AS docType\r\n\t\r\n \tFROM document d\r\n\t\tJOIN documentdetails dd ON d.DocumentID = dd.DocumentID\r\n\t\tWHERE d.DocumentTypeID = 7 \r\n\t\tAND CAST(d.Date AS DATE) BETWEEN  @dateFrom AND @dateTo\r\ngroup BY d.DocumentID\r\n\r\n\tUNION \r\n\r\nSELECT \r\n\tCAST(d.Date AS DATE) AS documentDate, ROUND(SUM(dd.Quantity * dd.PriceWithDiscount * -1),2) \tAS documentValue,\r\n\tCONCAT ('Otpremnica: ', d.Number,'/',d.Year) AS description, 1 AS debit, d.DocumentId, 7 AS docType\r\n\t\r\n \tFROM document d\r\n\t\tJOIN documentdetails dd ON d.DocumentID = dd.DocumentID\r\n\t\tWHERE d.DocumentTypeID = 6\r\n\t\tAND CAST(d.Date AS DATE) BETWEEN @dateFrom AND @dateTo\r\ngroup BY d.DocumentID\r\n\r\n\tUNION \r\n\t\r\nSELECT \r\n\tCAST(d.Date AS DATE) AS documentDate, ROUND(SUM(dd.Quantity * dd.NewPrice),2) \tAS documentValue,\r\n\tCONCAT ('Interna prijemnica: ', d.Number,'/',d.Year) AS description, 1 AS debit, d.DocumentId, 8 AS docType\r\n\t\r\n \tFROM document d\r\n\t\tJOIN documentdetails dd ON d.DocumentID = dd.DocumentID\r\n\t\tWHERE d.DocumentTypeID = 13\r\n\t\tAND CAST(d.Date AS DATE) BETWEEN @dateFrom AND @dateTo\r\ngroup BY d.DocumentID\r\n\r\n\tUNION\r\n\r\nSELECT \r\n\tCAST(d.Date AS DATE) AS documentDate, ROUND(SUM(dd.Quantity * dd.NewPrice * -1),2) \tAS documentValue,\r\n\tCONCAT ('Interna otpremnica: ', d.Number,'/',d.Year) AS description, 1 AS debit, d.DocumentId, 9 AS docType\r\n\t\r\n \tFROM document d\r\n\t\tJOIN documentdetails dd ON d.DocumentID = dd.DocumentID\r\n\t\tWHERE d.DocumentTypeID = 14\r\n\t\tAND CAST(d.Date AS DATE) BETWEEN @dateFrom AND @dateTo\r\ngroup BY d.DocumentID\r\n\r\n\tUNION\r\n\r\nSELECT \r\n\tCAST(d.Date AS DATE) AS documentDate, ROUND(SUM(d.SumWithDiscount),2) AS documentValue,\r\n\t\tCONCAT('Veleprodajna faktura: ', d.Number , '/',d.Year) AS description, 0 AS debit, d.DocumentId, 10 AS docType\r\n\t\r\n\tFROM document d \r\n\t\tWHERE d.DocumentTypeID = 28\r\n\t\tAND CAST(d.Date AS DATE) BETWEEN @dateFrom AND @dateTo\r\ngroup BY d.WorkDayID\r\n\r\n\tUNION \r\n\r\nSELECT \r\n\tCAST((SUBDATE(d.Date, INTERVAL 1 DAY)) AS DATE) AS documentDate, ROUND(SUM(dd.Quantity * dd.NewPrice),2) \tAS documentValue,\r\n\tCONCAT ('Po\u010detno Stanje: ', d.Number,'/',d.Year) AS description, 1 AS debit, d.DocumentId , 11 AS docType\r\n\t\r\n \tFROM document d\r\n\t\tJOIN documentdetails dd ON d.DocumentID = dd.DocumentID\r\n\t\tWHERE d.DocumentTypeID = 11 \r\n\t\tAND CAST(d.Date AS DATE) = \r\n\t\t(SELECT  DATE_ADD(( ADDDATE(@dateFrom, - DAYOFYEAR( @dateFrom)+1))\r\n\t\t,INTERVAL 1 year))\r\ngroup BY d.DocumentID\r\n\r\n) AS trt\r\norder BY documentDate, docType, DocumentId";
        try {
            PreparedStatement ps = this.connection.prepareStatement(parameterQuery);
            ps.setDate(1, from);
            ps.setDate(2, to);
            ps.setLong(3, wdIdFrom);
            ps.setLong(4, wdIdTo);
            ps.executeUpdate();
            ps = this.connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            Kep kep = null;
            while (rs.next()) {
                if (rs.isFirst()) {
                    kep = this.makeFirstKep(rs);
                    sum_debit += kep.getDebit();
                    sum_debitReleaf += kep.getDebitReleaf();
                } else {
                    kep = this.makeKep(rs);
                    sum_debit += kep.getDebit();
                    sum_debitReleaf += kep.getDebitReleaf();
                }
                kepList.add((Object)kep);
            }
            double kepValue = sum_debit - sum_debitReleaf;
            Settings.round(sum_debit, 2);
            sumarizedValues.put("sum_debit", Settings.round(sum_debit, 2));
            sumarizedValues.put("sum_debitReleaf", Settings.round(sum_debitReleaf, 2));
            sumarizedValues.put("kepValue", Settings.round(kepValue, 2));
            return kepList;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return kepList;
        }
    }

    private Kep makeFirstKep(ResultSet rs) throws SQLException {
        int docType = rs.getInt("docType");
        String documentDescription = "Donos";
        LocalDate documentDate = rs.getDate("documentDate").toLocalDate();
        double debit = 0.0;
        double debitReleaf = 0.0;
        if (docType == 0) {
            debit = rs.getDouble("documentValue");
        }
        Kep kep = new Kep();
        kep.setDocumentDate(documentDate);
        kep.setDocumentDescription(documentDescription);
        kep.setDebit(debit);
        kep.setDebitReleaf(debitReleaf);
        return kep;
    }

    private Kep makeKep(ResultSet rs) throws SQLException {
        int docType = rs.getInt("docType");
        if (docType == 0 || docType == 11) {
            return this.initialStockKepCorrection(rs);
        }
        int isDebit = rs.getInt("debit");
        String documentDescription = rs.getString("description");
        LocalDate documentDate = rs.getDate("documentDate").toLocalDate();
        double debit = 0.0;
        double debitReleaf = 0.0;
        if (isDebit == 1) {
            debit = rs.getDouble("documentValue");
        } else {
            debitReleaf = rs.getDouble("documentValue");
        }
        Kep kep = new Kep();
        kep.setDocumentDate(documentDate);
        kep.setDocumentDescription(documentDescription);
        kep.setDebit(debit);
        kep.setDebitReleaf(debitReleaf);
        return kep;
    }

    private Kep initialStockKepCorrection(ResultSet rs) throws SQLException {
        LocalDate documentDate = rs.getDate("documentDate").toLocalDate();
        LocalDate stockDate = documentDate.minusDays(1L);
        String documentDescription = rs.getString("description");
        double debit = 0.0;
        double debitReleaf = 0.0;
        ObservableList listaAditionalFields = FXCollections.observableArrayList();
        ObservableList<Product> productStockList = Product.getNewReceivingReport("", (ObservableList<AditionalField>)listaAditionalFields, "", this.controller, 1, stockDate, false, false, false, false, false, false, false, true, true);
        double stockValue = this.stockValue(productStockList);
        double initialStockValue = rs.getDouble("documentValue");
        double documentValue = initialStockValue - stockValue;
        if (documentValue > 0.0) {
            debit = documentValue;
            documentDescription = "Vi\u0161ak po dokumentu: " + documentDescription;
        } else if (documentValue < 0.0) {
            debitReleaf = -documentValue;
            documentDescription = "Manjak po dokumentu: " + documentDescription;
        }
        Kep kep = new Kep();
        kep.setDocumentDate(documentDate);
        kep.setDocumentDescription(documentDescription);
        kep.setDebit(debit);
        kep.setDebitReleaf(debitReleaf);
        return kep;
    }

    private double stockValue(ObservableList<Product> productStockList) {
        double stockValue = 0.0;
        for (Product p : productStockList) {
            stockValue += p.getStock() * p.getPrice();
        }
        return stockValue;
    }

    public String firstKepYear() {
        String year = "";
        String query = "SELECT YEAR(wd.Date) AS wdYear FROM workday wd group BY wdYear order BY wd.WorkDayID LIMIT 1";
        try {
            Statement st = this.connection.createStatement();
            ResultSet rs = st.executeQuery(query);
            if (rs.next()) {
                year = rs.getString("wdYear");
            }
            return year;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return year;
        }
    }

    public String lastKepYear() {
        String year = "";
        String query = "SELECT YEAR(wd.Date) AS wdYear FROM workday wd group BY wdYear order BY wd.WorkDayID DESC LIMIT 1";
        try {
            Statement st = this.connection.createStatement();
            ResultSet rs = st.executeQuery(query);
            if (rs.next()) {
                year = rs.getString("wdYear");
            }
            return year;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return year;
        }
    }

    public ObservableList<String> KepYears() {
        ObservableList years = FXCollections.observableArrayList();
        String query = "SELECT YEAR(wd.Date) AS wdYear FROM workday wd group BY wdYear\r\norder BY wd.WorkDayID desc";
        try {
            Statement st = this.connection.createStatement();
            ResultSet rs = st.executeQuery(query);
            while (rs.next()) {
                String year = rs.getString("wdYear");
                years.add((Object)year);
            }
            return years;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

