/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.newFiscalization.tax;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import rs.petcom.master.ScreensController;
import rs.petcom.master.newFiscalization.tax.TaxRateResponse;

public class TaxRateRequest {
    private final String address;
    private final ScreensController controller;

    public TaxRateRequest(ScreensController controller) {
        this.address = controller.getSettings().getLpfrPath() + "/api/v3/status";
        this.controller = controller;
    }

    public TaxRateResponse getTaxRates() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        TaxRateResponse taxRate = null;
        try {
            taxRate = (TaxRateResponse)mapper.readValue(this.getResponseLine(), TaxRateResponse.class);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(taxRate);
        return taxRate;
    }

    private String getResponseLine() throws IOException {
        String responseLine = "";
        StringBuilder sb = new StringBuilder();
        HttpURLConnection urlConnection = null;
        urlConnection = "true".equals(this.controller.getSettings().getPrimaryAdressVprf()) ? this.getUrlHttpsConnection() : this.getUrlConnection();
        int code = urlConnection.getResponseCode();
        if (code == 200) {
            InputStream is = urlConnection.getInputStream();
            InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
            BufferedReader bfr = new BufferedReader(isr);
            while ((responseLine = bfr.readLine()) != null) {
                sb.append(responseLine);
            }
        }
        return sb.toString();
    }

    private HttpURLConnection getUrlHttpsConnection() throws IOException {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("pkcs12");
            keyStore.load(new FileInputStream(this.controller.getSettings().getPutanjaSertifikat() + ".p12"), this.controller.getSettings().getPasswordVprf().toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, this.controller.getSettings().getPasswordVprf().toCharArray());
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(kmf.getKeyManagers(), null, null);
            SSLSocketFactory sslSocketFactory = ctx.getSocketFactory();
            String vprfAdresa = this.controller.getSettings().getVprfPath() + "/api/v3/status";
            URL url = new URL(vprfAdresa);
            System.out.println("Vprf putanja " + vprfAdresa);
            HttpsURLConnection urlConnection = (HttpsURLConnection)url.openConnection();
            urlConnection.setRequestMethod("GET");
            urlConnection.setRequestProperty("Content-Type", "application/json");
            urlConnection.setRequestProperty("Accept", "application/json");
            urlConnection.setRequestProperty("JID", this.controller.getSettings().getJID());
            urlConnection.setRequestProperty("PAC", this.controller.getSettings().getPAK());
            urlConnection.setRequestProperty("Host", "");
            urlConnection.setDoOutput(true);
            urlConnection.setSSLSocketFactory(sslSocketFactory);
            return urlConnection;
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (UnrecoverableKeyException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return null;
    }

    private HttpURLConnection getUrlConnection() throws IOException {
        URL url = new URL(this.address);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setRequestMethod("GET");
        urlConnection.setRequestProperty("Content-Type", "application/json");
        urlConnection.setRequestProperty("Accept", "application/json");
        urlConnection.setRequestProperty("Host", "");
        urlConnection.setDoOutput(true);
        return urlConnection;
    }
}

