/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.newFiscalization.status;

import java.util.HashMap;
import javafx.stage.Window;
import rs.petcom.master.ScreensController;
import rs.petcom.master.newFiscalization.status.StatusRequest;
import rs.petcom.master.newFiscalization.status.StatusResponse;

public class LPFRStatus {
    ScreensController controller;
    StatusRequest statusRequest;
    StatusResponse statusResponse;

    public LPFRStatus(ScreensController controller) {
        this.controller = controller;
        this.statusRequest = new StatusRequest(controller);
        this.statusResponse = this.statusRequest.getResponse();
    }

    public String checkStatus(Window owner) {
        System.out.println();
        if (this.statusResponse == null && !"true".equals(this.controller.getSettings().getPrimaryAdressVprf())) {
            this.controller.alert("Obave\u0161tenje", "Nema odgovora od LPFR-a.  Obratite se  tehni\u010dkoj podr\u0161ci.", owner);
            return "Bad LPFR address";
        }
        if (this.statusResponse == null && "true".equals(this.controller.getSettings().getPrimaryAdressVprf())) {
            this.controller.alert("Obave\u0161tenje", "Nema odgovora od VPFR-a.  Obratite se  tehni\u010dkoj podr\u0161ci.", owner);
            return "Bad LPFR address";
        }
        if (!"true".equals(this.controller.getSettings().getPrimaryAdressVprf()) && !this.isCardInReader()) {
            this.controller.alert("Obave\u0161tenje", "Kartica se ne nalazi u \u010dita\u010du. Proverite Va\u0161u karticu ili se obratite tehni\u010dkoj podr\u0161ci.", owner);
            return "Card is not in reader";
        }
        if (this.isPinRequired() && !"true".equals(this.controller.getSettings().getPrimaryAdressVprf())) {
            HashMap<String, Object> hm = new HashMap<String, Object>();
            hm.put("controller", this.controller);
            hm.put("headLine", "Unesite va\u0161 LPFR pin");
            this.controller.showModalDialog("Unos PIN-a", ScreensController.SCREEN_BACKOFFICE_PIN_INSERT, hm, owner);
            return "Pin Required:" + this.isPinRequired();
        }
        if (this.isAuditRequred() && !"true".equals(this.controller.getSettings().getPrimaryAdressVprf())) {
            this.controller.alert("Obave\u0161tenje", "Audit requred. Obratite se tehni\u010dkoj podr\u0161ci", owner);
            return "Audit Required:" + this.isAuditRequred();
        }
        return "";
    }

    private boolean isCardInReader() {
        for (String gsc : this.statusResponse.getGsc()) {
            if (!gsc.contains("1300")) continue;
            return false;
        }
        return true;
    }

    private boolean isAuditRequred() {
        return this.statusResponse.isAuditRequired();
    }

    private boolean isPinRequired() {
        return this.statusResponse.isPinRequired();
    }
}

