/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.newFiscalization.print;

import java.util.HashMap;
import java.util.logging.Logger;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Bill;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.person.Address;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.newFiscalization.invoice.InvoiceBody;
import rs.petcom.master.newFiscalization.invoice.InvoiceResponse;
import rs.petcom.master.utility.FormaterUtil;

public class JasperPrintBill {
    private static Object object;
    private static final Logger LOGGER;

    public static String getInformationCompany(ScreensController screensController) {
        Object object;
        JasperPrintBill.object = object = Object.get(screensController.getSettings().getConnection());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(object.getName());
        stringBuilder.append(JasperPrintBill.addNewLine());
        stringBuilder.append(object.getPIB());
        stringBuilder.append(JasperPrintBill.addNewLine());
        stringBuilder.append(object.getMB());
        stringBuilder.append(JasperPrintBill.addNewLine());
        stringBuilder.append(object.getBankAccount());
        stringBuilder.append(JasperPrintBill.addNewLine());
        return stringBuilder.toString();
    }

    public static String fetAddressCompany(ScreensController screensController) {
        Address address = Address.getByID(object.getAddressID(), screensController.getSettings().getConnection());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Adresa sedi\u0161ta: ");
        stringBuilder.append(address.getAddress());
        stringBuilder.append(JasperPrintBill.addNotch());
        stringBuilder.append(address.getZip());
        stringBuilder.append(JasperPrintBill.addNotch());
        stringBuilder.append(address.getCity());
        return stringBuilder.toString();
    }

    public static String getCusomer(Long documentId, Person personId, ScreensController controller) {
        Person person = personId != null ? Person.getById(personId.getPersonID(), controller) : null;
        String BuyerIdentification2 = Bill.getBillBuyer(documentId, controller);
        StringBuilder stringBuilder = new StringBuilder();
        if (BuyerIdentification2 != null && !BuyerIdentification2.isEmpty()) {
            stringBuilder.append("ID Kupca: ");
            stringBuilder.append(BuyerIdentification2);
            stringBuilder.append(JasperPrintBill.addNewLine());
        }
        if (person != null) {
            stringBuilder.append(" " + person.getName());
            stringBuilder.append(JasperPrintBill.addNewLine());
            stringBuilder.append(" PIB: ");
            stringBuilder.append(person.getPIB());
            stringBuilder.append(JasperPrintBill.addNewLine());
            stringBuilder.append(" MB: ");
            stringBuilder.append(person.getMB());
            stringBuilder.append(JasperPrintBill.addNewLine());
            stringBuilder.append(" " + person.getAddress());
            stringBuilder.append(JasperPrintBill.addNotch());
            stringBuilder.append(person.getZIP());
            stringBuilder.append(person.getCity());
            stringBuilder.append(JasperPrintBill.addNewLine());
            return stringBuilder.toString();
        }
        return stringBuilder.toString();
    }

    public static String getSupplier(InvoiceResponse response, InvoiceBody body) {
        LOGGER.info("Vrednost biznis name je " + response.getBusinessName());
        LOGGER.info("Mesto prodaje: name je " + response.getLocationName());
        StringBuilder header = new StringBuilder();
        header.append(" PIB: ");
        header.append(response.getTin());
        header.append(JasperPrintBill.addNewLine());
        header.append(" Preduze\u0107e: ");
        if (FormaterUtil.isCyrillic(response.getBusinessName())) {
            header.append(JasperPrintBill.transliterate(response.getBusinessName()));
        } else {
            header.append(response.getBusinessName());
        }
        header.append(JasperPrintBill.addNewLine());
        header.append(" Mesto prodaje: ");
        if (FormaterUtil.isCyrillic(response.getLocationName())) {
            header.append(JasperPrintBill.transliterate(response.getLocationName()));
        } else {
            header.append(response.getLocationName());
        }
        header.append(JasperPrintBill.addNewLine());
        header.append(" Adresa: ");
        if (FormaterUtil.isCyrillic(response.getAddress())) {
            header.append(JasperPrintBill.transliterate(response.getAddress()));
        } else {
            header.append(response.getAddress());
        }
        header.append(JasperPrintBill.addNewLine());
        header.append(" Op\u0161tina: ");
        if (FormaterUtil.isCyrillic(response.getDistrict())) {
            header.append(JasperPrintBill.transliterate(response.getDistrict()));
        } else {
            header.append(response.getDistrict());
        }
        header.append(JasperPrintBill.addNewLine());
        header.append(JasperPrintBill.aditional(body));
        return header.toString();
    }

    public static String transliterate(String message) {
        HashMap<Character, String> translate = new HashMap<Character, String>();
        translate.put(Character.valueOf(','), ",");
        translate.put(Character.valueOf('.'), ".");
        translate.put(Character.valueOf('/'), "/");
        translate.put(Character.valueOf('-'), "-");
        translate.put(Character.valueOf(' '), " ");
        translate.put(Character.valueOf('\u0430'), "a");
        translate.put(Character.valueOf('\u0431'), "b");
        translate.put(Character.valueOf('\u0432'), "v");
        translate.put(Character.valueOf('\u0433'), "g");
        translate.put(Character.valueOf('\u0434'), "d");
        translate.put(Character.valueOf('\u0452'), "\u0111");
        translate.put(Character.valueOf('\u0435'), "e");
        translate.put(Character.valueOf('\u0436'), "\u017e");
        translate.put(Character.valueOf('\u0437'), "z");
        translate.put(Character.valueOf('\u0438'), "i");
        translate.put(Character.valueOf('\u0458'), "j");
        translate.put(Character.valueOf('\u043a'), "k");
        translate.put(Character.valueOf('\u043b'), "l");
        translate.put(Character.valueOf('\u0459'), "lj");
        translate.put(Character.valueOf('\u043c'), "m");
        translate.put(Character.valueOf('\u043d'), "n");
        translate.put(Character.valueOf('\u045a'), "nj");
        translate.put(Character.valueOf('\u043e'), "o");
        translate.put(Character.valueOf('\u043f'), "p");
        translate.put(Character.valueOf('\u0440'), "r");
        translate.put(Character.valueOf('\u0441'), "s");
        translate.put(Character.valueOf('\u0442'), "t");
        translate.put(Character.valueOf('\u045b'), "\u0107");
        translate.put(Character.valueOf('\u0443'), "u");
        translate.put(Character.valueOf('\u0444'), "f");
        translate.put(Character.valueOf('\u0445'), "h");
        translate.put(Character.valueOf('\u0446'), "c");
        translate.put(Character.valueOf('\u0447'), "\u010d");
        translate.put(Character.valueOf('\u045f'), "d\u017e");
        translate.put(Character.valueOf('\u0448'), "\u0161");
        translate.put(Character.valueOf('A'), "A");
        translate.put(Character.valueOf('\u0411'), "B");
        translate.put(Character.valueOf('\u0412'), "V");
        translate.put(Character.valueOf('\u0413'), "G");
        translate.put(Character.valueOf('\u0414'), "D");
        translate.put(Character.valueOf('\u0402'), "\u0110");
        translate.put(Character.valueOf('\u0415'), "E");
        translate.put(Character.valueOf('\u0416'), "\u017d");
        translate.put(Character.valueOf('\u0417'), "Z");
        translate.put(Character.valueOf('\u0418'), "I");
        translate.put(Character.valueOf('\u0408'), "J");
        translate.put(Character.valueOf('\u041a'), "K");
        translate.put(Character.valueOf('\u041b'), "L");
        translate.put(Character.valueOf('\u0409'), "Lj");
        translate.put(Character.valueOf('\u041c'), "M");
        translate.put(Character.valueOf('\u041d'), "N");
        translate.put(Character.valueOf('\u040a'), "Nj");
        translate.put(Character.valueOf('\u041e'), "O");
        translate.put(Character.valueOf('\u041f'), "P");
        translate.put(Character.valueOf('\u0420'), "R");
        translate.put(Character.valueOf('\u0421'), "S");
        translate.put(Character.valueOf('\u0422'), "T");
        translate.put(Character.valueOf('\u040b'), "\u0106");
        translate.put(Character.valueOf('\u0423'), "U");
        translate.put(Character.valueOf('\u0424'), "F");
        translate.put(Character.valueOf('\u0425'), "H");
        translate.put(Character.valueOf('\u0426'), "C");
        translate.put(Character.valueOf('\u0427'), "\u010c");
        translate.put(Character.valueOf('\u040f'), "D\u017e");
        translate.put(Character.valueOf('\u0428'), "\u0160");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < message.length(); ++i) {
            if (translate.containsKey(Character.valueOf(message.charAt(i)))) {
                builder.append((String)translate.get(Character.valueOf(message.charAt(i))));
                continue;
            }
            System.out.println("vrednost cirilica " + message.charAt(i));
            builder.append(message.charAt(i));
        }
        return builder.toString();
    }

    public static String aditional(InvoiceBody body) {
        String cashier;
        StringBuilder aditional = new StringBuilder();
        String string = cashier = body != null ? body.getCashier() : null;
        if (cashier != null && !cashier.isEmpty()) {
            aditional.append(" Kasir: ");
            aditional.append(cashier);
            aditional.append("\r\n");
        }
        aditional.append(" Esir Broj: ");
        aditional.append(body != null ? body.getInvoiceNumber() : "");
        aditional.append("\r\n");
        return aditional.toString();
    }

    private static String addVerticalline() {
        return " | ";
    }

    private static String addNewLine() {
        return "\n";
    }

    private static String addNotch() {
        return ", ";
    }

    static {
        LOGGER = Logger.getLogger("global");
    }
}

