/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.newFiscalization.invoice;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javafx.collections.ObservableList;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import rs.petcom.enums.InvoiceType;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PaymentMethod;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.DocumentPayment;
import rs.petcom.master.newFiscalization.invoice.InvoiceBody;
import rs.petcom.master.newFiscalization.invoice.InvoiceResponse;
import rs.petcom.master.newFiscalization.invoice.Item;
import rs.petcom.master.newFiscalization.invoice.Payment;

public class RefundInvoiceRequest {
    private ScreensController controller;
    private Connection connection;
    private String address;
    private String buyer;
    private ObjectMapper mapper;
    private User user;
    private Document document;
    private ObservableList<DocumentDetails> refundDetails;
    private InvoiceBody body;
    private PaymentMethod payment;
    private String vprfPath;
    private String JID;
    private String PAK;
    private String primaryAdress;
    private String passwordVprf;

    public RefundInvoiceRequest(ScreensController controller, ObservableList<DocumentDetails> refundDetails, String buyer, PaymentMethod payment, Document document) {
        this.address = controller.getSettings().getLpfrPath() + "/api/v3/invoices";
        this.controller = controller;
        this.refundDetails = refundDetails;
        this.buyer = buyer;
        this.payment = payment;
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.connection = controller.getSettings().getConnection();
        this.document = document == null ? Document.getByID(((DocumentDetails)refundDetails.get(0)).getDocumentID(), this.connection) : document;
        this.user = controller.getUser();
        this.body = new InvoiceBody();
        this.vprfPath = controller.getSettings().getVprfPath() + "/api/v3/invoices";
        this.PAK = controller.getSettings().getPAK();
        this.JID = controller.getSettings().getJID();
        this.primaryAdress = controller.getSettings().getPrimaryAdressVprf();
        this.passwordVprf = controller.getSettings().getPasswordVprf();
    }

    public InvoiceBody getBody() {
        return this.body;
    }

    public InvoiceResponse getInvoiceResponse(InvoiceType invoiceType) {
        InvoiceResponse response = null;
        try {
            response = (InvoiceResponse)this.mapper.readValue(this.getResponseLine(invoiceType), InvoiceResponse.class);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(response);
        return response;
    }

    public Document getDocument() {
        return this.document;
    }

    private String getInputString(InvoiceType invoiceType) throws JsonProcessingException {
        String vatLabel = "";
        double amount = 0.0;
        LinkedList<DocumentPayment> payments = DocumentPayment.getCombinedPaymentByDocumentId(this.document.getDocumentID(), this.controller);
        LocalDateTime ldt = Settings.LocalDateTimefromDate(this.document.getDate());
        String ldtStr = Settings.formatLocalDateTime(ldt, "yyyy-MM-dd HH:mm:ss");
        this.body.setInvoiceType(invoiceType.getType());
        this.body.setTransactionType("Refund");
        this.body.setCashier(this.user.getUserName());
        this.body.setReferentDocumentNumber(this.document.getReferentNumber());
        this.body.setReferentDocumentDT(this.document.getReferentDateTime());
        this.body.setBuyerId(this.buyer);
        this.body.setInvoiceNumber("1129/2.1");
        Item[] items = new Item[this.refundDetails.size()];
        for (int i = 0; i < this.refundDetails.size(); ++i) {
            DocumentDetails detail = (DocumentDetails)this.refundDetails.get(i);
            vatLabel = Vat.getById(detail.getVatID(), this.connection).getCode();
            Item item = new Item();
            item.setName(detail.getProductName());
            item.setQuantity(detail.getQuantity());
            item.setUnitPrice(detail.getPrice());
            item.setLabels(new String[]{vatLabel});
            item.setTotalAmount(detail.getValue());
            items[i] = item;
            amount += detail.getValue();
        }
        this.body.setItems(items);
        Payment p = new Payment();
        p.setPaymentType(this.payment.getCode());
        p.setAmount(amount);
        this.body.setPayment(new Payment[]{p});
        return this.mapper.writeValueAsString((Object)this.body);
    }

    private String getResponseLine(InvoiceType invoiceType) throws IOException {
        String responseLine = "";
        StringBuilder sb = new StringBuilder();
        HttpURLConnection urlConnection = null;
        String input = this.getInputString(invoiceType);
        System.out.println(input);
        if ("true".equals(this.primaryAdress)) {
            urlConnection = this.getUrlHttpsConnection();
            if (urlConnection == null) {
                urlConnection = this.getUrlConnection();
            }
        } else {
            urlConnection = this.getUrlConnection();
        }
        OutputStream os = urlConnection.getOutputStream();
        os.write(input.getBytes("UTF-8"));
        os.flush();
        int code = urlConnection.getResponseCode();
        if (code == 200) {
            InputStream is = urlConnection.getInputStream();
            InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
            BufferedReader bfr = new BufferedReader(isr);
            while ((responseLine = bfr.readLine()) != null) {
                sb.append(responseLine);
            }
        } else {
            InputStream is = urlConnection.getErrorStream();
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader bfr = new BufferedReader(isr);
            while ((responseLine = bfr.readLine()) != null) {
                sb.append(responseLine);
            }
        }
        System.out.println(sb.toString());
        return sb.toString();
    }

    private HttpURLConnection getUrlConnection() throws IOException {
        URL url = new URL(this.address);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setRequestMethod("POST");
        urlConnection.setRequestProperty("Content-Type", "application/json");
        urlConnection.setRequestProperty("Accept", "application/json");
        urlConnection.setRequestProperty("Host", "");
        urlConnection.setDoOutput(true);
        return urlConnection;
    }

    private Payment[] getSinglePayment(List<DocumentPayment> payments, double amount) {
        int docPaymentId = payments.get(0).getPaymentMethodID();
        PaymentMethod method = PaymentMethod.getByID(docPaymentId, this.connection);
        Payment payment = new Payment();
        payment.setPaymentType(method.getCode());
        payment.setAmount(amount);
        return new Payment[]{payment};
    }

    private List<Payment> getMultiPayment(List<DocumentPayment> payments, double amount) {
        ArrayList<Payment> paymentList = new ArrayList<Payment>();
        PaymentMethod method = null;
        int docPaymentId = 0;
        for (DocumentPayment docPayment : payments) {
            docPaymentId = payments.get(0).getPaymentMethodID();
            method = PaymentMethod.getByID(docPaymentId, this.connection);
            if (amount <= docPayment.getPaid()) {
                Payment p = new Payment();
                p.setAmount(amount);
                p.setPaymentType(method.getCode());
                paymentList.add(p);
                return paymentList;
            }
            Payment payment = new Payment();
            payment.setPaymentType(method.getCode());
            payment.setAmount(amount);
            amount -= docPayment.getPaid();
        }
        return paymentList;
    }

    private Payment[] getMultiPaymentArr(List<DocumentPayment> payments, double amount) {
        List<Payment> paymentList = this.getMultiPayment(payments, amount);
        Payment[] paymentArr = new Payment[paymentList.size()];
        for (int i = 0; i < paymentList.size(); ++i) {
            paymentArr[i] = paymentList.get(i);
        }
        return paymentArr;
    }

    private HttpURLConnection getUrlHttpsConnection() throws IOException {
        KeyStore keyStore = null;
        try {
            keyStore = KeyStore.getInstance("pkcs12");
            keyStore.load(new FileInputStream(this.controller.getSettings().getPutanjaSertifikat() + ".p12"), this.passwordVprf.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(keyStore, this.passwordVprf.toCharArray());
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(kmf.getKeyManagers(), null, null);
            SSLSocketFactory sslSocketFactory = ctx.getSocketFactory();
            URL url = new URL(this.vprfPath);
            System.out.println("Vprf adresa " + this.vprfPath);
            HttpsURLConnection urlConnection = (HttpsURLConnection)url.openConnection();
            urlConnection.setRequestMethod("POST");
            urlConnection.setRequestProperty("Content-Type", "application/json");
            urlConnection.setRequestProperty("Accept", "application/json");
            urlConnection.setRequestProperty("JID", this.JID);
            urlConnection.setRequestProperty("PAC", this.PAK);
            urlConnection.setRequestProperty("Host", "");
            urlConnection.setDoOutput(true);
            urlConnection.setSSLSocketFactory(sslSocketFactory);
            return urlConnection;
        }
        catch (KeyStoreException e) {
            e.printStackTrace();
        }
        catch (UnrecoverableKeyException e) {
            e.printStackTrace();
        }
        catch (CertificateException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        return null;
    }
}

