/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.newFiscalization.invoice;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PaymentMethod;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.DocumentPayment;
import rs.petcom.master.newFiscalization.invoice.InvoiceBody;
import rs.petcom.master.newFiscalization.invoice.InvoiceResponse;
import rs.petcom.master.newFiscalization.invoice.Item;
import rs.petcom.master.newFiscalization.invoice.Payment;

public class CopyInvoiceRequest {
    private final String address;
    private ObjectMapper mapper;
    private Document document;
    private Connection connection;
    private ScreensController controller;
    InvoiceBody body;

    public CopyInvoiceRequest(Document document, ScreensController controller) {
        this.document = document;
        this.controller = controller;
        this.connection = controller.getSettings().getConnection();
        this.address = controller.getSettings().getLpfrPath() + "/api/v3/invoices";
        this.mapper = new ObjectMapper();
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.body = new InvoiceBody();
    }

    public InvoiceBody getBody() {
        return this.body;
    }

    public InvoiceResponse getInvoiceResponse() {
        InvoiceResponse response = null;
        try {
            response = (InvoiceResponse)this.mapper.readValue(this.getResponseLine(), InvoiceResponse.class);
        }
        catch (JsonParseException e) {
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println(response);
        return response;
    }

    private String getInputString() throws JsonProcessingException {
        String vatLabel = "";
        double amount = 0.0;
        User user = User.getUserByID(this.document.getSysUserAddID(), this.connection);
        LocalDateTime ldt = Settings.LocalDateTimefromDate(this.document.getDate());
        String ldtStr = Settings.formatLocalDateTime(ldt, "yyyy-MM-dd HH:mm:ss");
        this.body.setInvoiceType("Copy");
        this.body.setTransactionType("Sale");
        this.body.setCashier(user.getUserName());
        this.body.setReferentDocumentNumber(this.document.getReferentNumber());
        this.body.setReferentDocumentDT(ldtStr);
        this.body.setInvoiceNumber("1129/2.1");
        if (this.document.getBuyerIdentification() != null && !this.document.getBuyerIdentification().isEmpty()) {
            this.body.setBuyerId(this.document.getBuyerIdentification());
        }
        LinkedList<DocumentPayment> payments = DocumentPayment.getCombinedPaymentByDocumentId(this.document.getDocumentID(), this.controller);
        ArrayList<DocumentDetails> details = DocumentDetails.getList(this.document.getDocumentID(), this.connection);
        Item[] items = new Item[details.size()];
        for (int i = 0; i < details.size(); ++i) {
            DocumentDetails detail = (DocumentDetails)details.get(i);
            vatLabel = Vat.getById(detail.getVatID(), this.connection).getCode();
            Item item = new Item();
            item.setName(detail.getProductName());
            item.setQuantity(detail.getQuantity());
            item.setUnitPrice(detail.getPrice());
            item.setLabels(new String[]{vatLabel});
            item.setTotalAmount(detail.getValue());
            items[i] = item;
            amount += detail.getValue();
        }
        this.body.setItems(items);
        if (payments.size() == 1) {
            Payment[] paymentArr = this.getSinglePayment(payments, amount);
            this.body.setPayment(paymentArr);
        } else {
            Payment[] paymentArr = this.getMultiPaymentArr(payments);
            this.body.setPayment(paymentArr);
        }
        return this.mapper.writeValueAsString((Object)this.body);
    }

    private String getResponseLine() throws IOException {
        String responseLine = "";
        StringBuilder sb = new StringBuilder();
        HttpURLConnection urlConnection = this.getUrlConnection();
        String input = this.getInputString();
        System.out.println(input);
        OutputStream os = urlConnection.getOutputStream();
        os.write(input.getBytes("UTF-8"));
        os.flush();
        int code = urlConnection.getResponseCode();
        if (code == 200) {
            InputStream is = urlConnection.getInputStream();
            InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
            BufferedReader bfr = new BufferedReader(isr);
            while ((responseLine = bfr.readLine()) != null) {
                sb.append(responseLine);
            }
        } else {
            InputStream is = urlConnection.getErrorStream();
            InputStreamReader isr = new InputStreamReader(is, StandardCharsets.UTF_8);
            BufferedReader bfr = new BufferedReader(isr);
            while ((responseLine = bfr.readLine()) != null) {
                sb.append(responseLine);
            }
        }
        System.out.println("Nesaaa" + sb.toString());
        return sb.toString();
    }

    private HttpURLConnection getUrlConnection() throws IOException {
        URL url = new URL(this.address);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setRequestMethod("POST");
        urlConnection.setRequestProperty("Content-Type", "application/json");
        urlConnection.setRequestProperty("Accept", "application/json");
        urlConnection.setRequestProperty("Host", "");
        urlConnection.setDoOutput(true);
        return urlConnection;
    }

    private Payment[] getSinglePayment(List<DocumentPayment> payments, double amount) {
        int docPaymentId = payments.get(0).getPaymentMethodID();
        PaymentMethod method = PaymentMethod.getByID(docPaymentId, this.connection);
        Payment payment = new Payment();
        payment.setPaymentType(this.adjustPaymentCode(method.getCode()));
        payment.setAmount(amount);
        return new Payment[]{payment};
    }

    private Payment[] getMultiPaymentArr(List<DocumentPayment> payments) {
        Payment[] paymentArr = new Payment[payments.size()];
        for (int i = 0; i < payments.size(); ++i) {
            DocumentPayment payment = payments.get(i);
            PaymentMethod method = PaymentMethod.getByID(payment.getPaymentMethodID(), this.connection);
            Payment p = new Payment();
            p.setAmount(payment.getPaid());
            p.setPaymentType(this.adjustPaymentCode(method.getCode()));
            paymentArr[i] = p;
        }
        return paymentArr;
    }

    private String adjustPaymentCode(String paymentCode) {
        String lcCode = paymentCode.toLowerCase();
        String capCode = lcCode.substring(0, 1).toUpperCase() + lcCode.substring(1);
        return capCode;
    }
}

