/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.licence;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Date;
import rs.petcom.master.licence.LicLogic;
import rs.petcom.master.licence.exception.LicenseNotValid;
import rs.petcom.master.licence.exception.MacAddressReadException;

public class LicControl {
    private static final String licFolder = "./license";

    public static String readLicenseFile(String in, byte cc) throws FileNotFoundException, IOException, MacAddressReadException, MacAddressReadException {
        String licCode = "";
        InputStreamReader fr = null;
        try {
            int c;
            File licFold = new File(licFolder);
            if (!licFold.exists()) {
                licFold.mkdir();
            }
            String ctrlCode = LicLogic.getControlCode(in, cc);
            File f = new File(licFolder + File.separator + ctrlCode + ".lic");
            if (!f.canRead()) {
                f.createNewFile();
            }
            if (f.exists()) {
                fr = new FileReader(f);
            }
            while ((c = fr.read()) > -1) {
                licCode = licCode + (char)c;
            }
            fr.close();
        }
        catch (FileNotFoundException fnfex) {
            fnfex.printStackTrace();
            try {
                fr.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw fnfex;
        }
        catch (IOException ioex) {
            try {
                fr.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ioex;
        }
        return licCode;
    }

    public static Date getLicenseValidity(String in, byte cc) throws FileNotFoundException, IOException, LicenseNotValid, MacAddressReadException {
        String licCode = LicControl.readLicenseFile(in, cc);
        return LicLogic.getLicenseExpiration(licCode);
    }

    public static int getLicenseType(String in, byte cc) throws FileNotFoundException, IOException, LicenseNotValid, MacAddressReadException {
        String licCode = LicControl.readLicenseFile(in, cc);
        int licT = LicLogic.getLicenseType(licCode);
        return licT;
    }

    public static boolean storeLicenseData(String in, byte cc, String in2) {
        boolean ret = false;
        OutputStreamWriter fw = null;
        try {
            String ctrlCode;
            File f;
            File licFold = new File(licFolder);
            if (!licFold.exists()) {
                licFold.mkdir();
            }
            if ((f = new File(licFolder, (ctrlCode = LicLogic.getControlCode(in, cc)) + ".lic")).exists()) {
                f.delete();
            }
            fw = new FileWriter(f);
            fw.append(in2);
            fw.flush();
            fw.close();
            ret = true;
        }
        catch (Exception e) {
            try {
                fw.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }
}

