/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.invoice.dto;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.RoundItem;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.dal.product.Product;
import rs.petcom.master.invoice.dto.AccountingCustomerParty;
import rs.petcom.master.invoice.dto.AccountingSupplierParty;
import rs.petcom.master.invoice.dto.AllowanceCharge;
import rs.petcom.master.invoice.dto.ClassifiedTaxCategory;
import rs.petcom.master.invoice.dto.Delivery;
import rs.petcom.master.invoice.dto.InputAndOutputDocuments;
import rs.petcom.master.invoice.dto.InvoiceDto;
import rs.petcom.master.invoice.dto.InvoiceLine;
import rs.petcom.master.invoice.dto.InvoicePeriod;
import rs.petcom.master.invoice.dto.InvoiceTransactionType;
import rs.petcom.master.invoice.dto.InvoiceType;
import rs.petcom.master.invoice.dto.Item;
import rs.petcom.master.invoice.dto.OrderReference;
import rs.petcom.master.invoice.dto.PayeeFinancialAccount;
import rs.petcom.master.invoice.dto.PaymentMeans;
import rs.petcom.master.invoice.dto.Price;
import rs.petcom.master.invoice.dto.SellersItemIdentification;
import rs.petcom.master.invoice.dto.TaxScheme;

public class Invoice {
    public InvoiceDto createInvoice(ScreensController controller, Person person, String lprfNumber) {
        InvoiceDto invoiceDto = this.getGeneralPart(controller);
        invoiceDto.setId("TM-2023/01-" + String.valueOf(UUID.randomUUID().toString().substring(0, 5)));
        AccountingSupplierParty accountingSupplierParty = AccountingSupplierParty.getSupplier(controller.getObject());
        AccountingCustomerParty accountingCustomerParty = AccountingCustomerParty.getCustomer(person);
        if (accountingCustomerParty.getParty().getPartyIdentification() != null) {
            invoiceDto.setSendToCir("Yes");
        }
        InvoicePeriod invoicePeriod = this.createInvoicePeriod();
        OrderReference orderReference = new OrderReference();
        System.out.println(lprfNumber);
        orderReference.setId(lprfNumber);
        invoiceDto.setOrderReference(orderReference);
        PaymentMeans paymentMeans = this.createPaymentMeans(controller.getObject());
        Delivery delivery = this.getDelivery();
        List<InvoiceLine> invoiceLine = this.invoiceLine(controller);
        invoiceDto.setAccountingCustomerParty(accountingCustomerParty);
        invoiceDto.setAccountingSupplierParty(accountingSupplierParty);
        ArrayList<InvoicePeriod> invoicePeriods = new ArrayList<InvoicePeriod>();
        invoicePeriods.add(invoicePeriod);
        invoiceDto.setInvoicePeriod(invoicePeriods);
        ArrayList<PaymentMeans> paymentMeans1 = new ArrayList<PaymentMeans>();
        paymentMeans1.add(paymentMeans);
        invoiceDto.setPaymentMeans(paymentMeans1);
        invoiceDto.setDelivery(delivery);
        invoiceDto.setInvoiceLine(invoiceLine);
        return invoiceDto;
    }

    private InvoiceDto getGeneralPart(ScreensController controller) {
        InvoiceDto invoiceDto = new InvoiceDto();
        invoiceDto.setFinalSum(BigDecimal.valueOf(controller.getBillList().get(0).getFinalSumWithDiscout()));
        BigDecimal sumWitohoutDiscount = BigDecimal.valueOf(controller.getBillList().get(0).getSumWithDiscout());
        sumWitohoutDiscount = sumWitohoutDiscount.setScale(2, RoundingMode.HALF_UP);
        invoiceDto.setSumWithDiscount(sumWitohoutDiscount);
        invoiceDto.setDiscount(sumWitohoutDiscount.subtract(invoiceDto.getFinalSum()));
        invoiceDto.setIssueDate(LocalDate.now());
        invoiceDto.setDueDate(LocalDate.now());
        invoiceDto.setChanel("Tmaster");
        invoiceDto.setDocumentCurrencyCode("RSD");
        invoiceDto.setInvoiceTypeCode("380");
        invoiceDto.setDocumentTypeId(1L);
        invoiceDto.setInvoiceTransactionType(InvoiceTransactionType.Sale);
        invoiceDto.setInvoiceType(InvoiceType.Normal);
        invoiceDto.setInputAndOutputDocuments(InputAndOutputDocuments.Output);
        invoiceDto.setIdCompany(Long.valueOf(controller.getObject().getIdCompany()));
        invoiceDto.setUserId(controller.getSettings().getUsername());
        return invoiceDto;
    }

    private InvoicePeriod createInvoicePeriod() {
        InvoicePeriod invoicePeriod = new InvoicePeriod();
        invoicePeriod.setDescriptionCode("3");
        return invoicePeriod;
    }

    private PaymentMeans createPaymentMeans(rs.petcom.master.dal.Object object) {
        PaymentMeans paymentMeans = new PaymentMeans();
        paymentMeans.setPaymentID("(mod29) 289");
        paymentMeans.setPaymentMeansCode("30");
        PayeeFinancialAccount payeeFinancialAccount = new PayeeFinancialAccount();
        String[] array = object.getBankAccount().split(":");
        payeeFinancialAccount.setId(array[0]);
        paymentMeans.setPayeeFinancialAccount(payeeFinancialAccount);
        return paymentMeans;
    }

    private Delivery getDelivery() {
        Delivery delivery = new Delivery();
        delivery.setActualDeliveryDate(LocalDate.now());
        return delivery;
    }

    private List<InvoiceLine> invoiceLine(ScreensController controller) {
        ArrayList<InvoiceLine> invoiceLines = new ArrayList<InvoiceLine>();
        AtomicInteger atomicInteger = new AtomicInteger(1);
        controller.getBillList().get(0).getRoundList().get(0).getItemList().forEach(p -> {
            InvoiceLine invoiceLine = new InvoiceLine();
            Product product = p.getProductDepartment().getProduct();
            invoiceLine.setIdUnit(Long.valueOf(product.getUnitID()));
            invoiceLine.setIdVat(Long.valueOf(product.getVatID()));
            invoiceLine.setUnitCode(product.getUnitName());
            invoiceLine.setVatName(product.getVatName());
            invoiceLine.setCurrencyID("RSD");
            Vat vat = Vat.getById(p.getProductDepartment().getProduct().getVatID(), controller.getSettings().getConnection());
            invoiceLine.setItem(this.item(controller, (RoundItem)p, atomicInteger, vat));
            invoiceLine.setPrice(this.price(product, (RoundItem)p, vat));
            invoiceLine.setId(String.valueOf(atomicInteger.getAndAdd(1)));
            invoiceLine.setInvoicedQuantity(BigDecimal.valueOf(p.getQuantity()));
            invoiceLine.setAllowanceCharge(this.allowanceCharge((RoundItem)p, product));
            invoiceLines.add(invoiceLine);
        });
        return invoiceLines;
    }

    private Item item(ScreensController controller, RoundItem roundItem, AtomicInteger atomicInteger, Vat vatValueData) {
        Item item = new Item();
        Product product = roundItem.getProductDepartment().getProduct();
        item.setIdProduct(product.getProductID());
        item.setName(product.getName());
        SellersItemIdentification sellersItemIdentification = new SellersItemIdentification();
        sellersItemIdentification.setId(String.valueOf(atomicInteger.get()));
        ClassifiedTaxCategory classifiedTaxCategory = new ClassifiedTaxCategory();
        classifiedTaxCategory.setId(vatValueData.getCode());
        System.out.println("vat value data " + vatValueData.getCode());
        TaxScheme taxScheme = new TaxScheme();
        taxScheme.setId("VAT");
        classifiedTaxCategory.setTaxScheme(taxScheme);
        BigDecimal vatValue = BigDecimal.valueOf(vatValueData.getValue());
        classifiedTaxCategory.setPercent(vatValue.subtract(BigDecimal.valueOf(1L)));
        classifiedTaxCategory.setPercent(classifiedTaxCategory.getPercent().multiply(BigDecimal.valueOf(100.0)));
        item.setSellersItemIdentification(sellersItemIdentification);
        item.setClassifiedTaxCategory(classifiedTaxCategory);
        return item;
    }

    private AllowanceCharge allowanceCharge(RoundItem roundItem, Product product) {
        AllowanceCharge allowanceCharge = new AllowanceCharge();
        allowanceCharge.setMultiplierFactorNumeric(BigDecimal.valueOf(product.getDiscount()));
        allowanceCharge.setChargeIndicator(false);
        allowanceCharge.setCurrencyId("RSD");
        return allowanceCharge;
    }

    private Price price(Product product, RoundItem roundItem, Vat vatValue) {
        Price price = new Price();
        price.setPriceAmount(BigDecimal.valueOf(product.getPrice()));
        BigDecimal discount = BigDecimal.valueOf(product.getDiscount());
        discount = discount.setScale(2, RoundingMode.HALF_UP);
        price.setDiscount(discount);
        price.setUnitPrice(BigDecimal.valueOf(product.getPrice()));
        if (price.getDiscount().compareTo(BigDecimal.ZERO) == 0) {
            price.setNewPrice(price.getPriceAmount());
        } else {
            BigDecimal newPrice = price.getPriceAmount().multiply(BigDecimal.valueOf(roundItem.getQuantity())).multiply(price.getDiscount().setScale(2, RoundingMode.HALF_UP).divide(BigDecimal.valueOf(100L).setScale(2, RoundingMode.HALF_UP)));
            newPrice = price.getPriceAmount().multiply(BigDecimal.valueOf(roundItem.getQuantity())).subtract(newPrice);
            newPrice = newPrice.divide(BigDecimal.valueOf(roundItem.getQuantity()), 2, RoundingMode.HALF_UP);
            newPrice = newPrice.setScale(2, RoundingMode.HALF_UP);
            price.setNewPrice(newPrice);
        }
        BigDecimal finalPriceRow = price.getNewPrice().multiply(BigDecimal.valueOf(roundItem.getQuantity()));
        finalPriceRow = finalPriceRow.setScale(2, RoundingMode.HALF_UP);
        BigDecimal vat = BigDecimal.valueOf(vatValue.getValue());
        BigDecimal unitTax = finalPriceRow.divide(vat, 2, RoundingMode.HALF_UP);
        BigDecimal tax = finalPriceRow.subtract(unitTax);
        tax = tax.setScale(2, RoundingMode.HALF_UP);
        price.setUnitTaxAmount(tax);
        return price;
    }
}

