/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui.trgovina;

import java.text.NumberFormat;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Bill;
import rs.petcom.master.dal.BuyerOfferPrice;
import rs.petcom.master.dal.BuyerOfferPriceDetailes;
import rs.petcom.master.dal.RoundItem;
import rs.petcom.master.dal.product.Product;

public class BillSummarySumTrgovina
extends GridPane {
    private Label lBillTotalValue = new Label("0,00");
    private TextField lBillDiscountValue = new TextField("0,00");
    private Label lBillTotalSumValue = new Label("0,00");
    NumberFormat nf = NumberFormat.getNumberInstance();
    double discount;

    public BillSummarySumTrgovina() {
        this.nf.setMaximumFractionDigits(2);
        this.nf.setMinimumFractionDigits(2);
        this.nf.setGroupingUsed(true);
        this.setMinHeight(64.0);
        this.setPrefHeight(64.0);
        this.setMaxHeight(Double.MAX_VALUE);
        this.getStyleClass().add((Object)"billSummarySum");
        this.getStyleClass().add((Object)"borderTopBottom");
        ColumnConstraints column1 = new ColumnConstraints(96.0, 96.0, Double.MAX_VALUE);
        column1.setFillWidth(true);
        column1.setHgrow(Priority.ALWAYS);
        ColumnConstraints column2 = new ColumnConstraints(96.0, 96.0, Double.MAX_VALUE);
        column2.setFillWidth(true);
        column2.setHgrow(Priority.ALWAYS);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column1, column2});
        RowConstraints row1 = new RowConstraints(16.0, 16.0, Double.MAX_VALUE);
        row1.setVgrow(Priority.ALWAYS);
        row1.setValignment(VPos.CENTER);
        this.getRowConstraints().add((Object)row1);
        RowConstraints row2 = new RowConstraints(16.0, 16.0, Double.MAX_VALUE);
        row2.setVgrow(Priority.ALWAYS);
        row2.setValignment(VPos.CENTER);
        this.getRowConstraints().add((Object)row2);
        RowConstraints row3 = new RowConstraints(32.0, 32.0, Double.MAX_VALUE);
        row3.setVgrow(Priority.ALWAYS);
        row3.setValignment(VPos.CENTER);
        this.getRowConstraints().add((Object)row3);
        Label lBillTotal = new Label("Total ra\u010dun");
        lBillTotal.getStyleClass().add((Object)"totalLabel");
        lBillTotal.setPadding(new Insets(0.0, 0.0, 0.0, 15.0));
        lBillTotal.setAlignment(Pos.CENTER_LEFT);
        lBillTotal.setMinWidth(96.0);
        lBillTotal.setPrefWidth(96.0);
        lBillTotal.setMaxWidth(Double.MAX_VALUE);
        lBillTotal.setMinHeight(16.0);
        lBillTotal.setPrefHeight(16.0);
        lBillTotal.setMaxHeight(Double.MIN_VALUE);
        Label lBillDiscount = new Label("Popust");
        lBillDiscount.getStyleClass().add((Object)"totalLabel");
        lBillDiscount.setPadding(new Insets(0.0, 0.0, 0.0, 15.0));
        lBillDiscount.setAlignment(Pos.CENTER_LEFT);
        lBillDiscount.setMinWidth(96.0);
        lBillDiscount.setPrefWidth(96.0);
        lBillDiscount.setMaxWidth(Double.MAX_VALUE);
        lBillDiscount.setMinHeight(16.0);
        lBillDiscount.setPrefHeight(16.0);
        lBillDiscount.setMaxHeight(Double.MIN_VALUE);
        Label lBillTotalSum = new Label("Total za naplatu");
        lBillTotalSum.getStyleClass().add((Object)"totalLabelSum");
        lBillTotalSum.setPadding(new Insets(0.0, 0.0, 0.0, 15.0));
        lBillTotalSum.setAlignment(Pos.CENTER_LEFT);
        lBillTotalSum.setMinWidth(96.0);
        lBillTotalSum.setPrefWidth(96.0);
        lBillTotalSum.setMaxWidth(Double.MAX_VALUE);
        lBillTotalSum.setMinHeight(32.0);
        lBillTotalSum.setPrefHeight(32.0);
        lBillTotalSum.setMaxHeight(Double.MIN_VALUE);
        this.lBillTotalValue.getStyleClass().add((Object)"totalValue");
        this.lBillTotalValue.setPadding(new Insets(0.0, 35.0, 0.0, 0.0));
        this.lBillTotalValue.setAlignment(Pos.CENTER_RIGHT);
        this.lBillTotalValue.setMinWidth(96.0);
        this.lBillTotalValue.setPrefWidth(96.0);
        this.lBillTotalValue.setMaxWidth(Double.MAX_VALUE);
        this.lBillTotalValue.setMinHeight(16.0);
        this.lBillTotalValue.setPrefHeight(16.0);
        this.lBillTotalValue.setMaxHeight(Double.MIN_VALUE);
        this.lBillDiscountValue.getStyleClass().add((Object)"totalValue");
        this.lBillDiscountValue.setPadding(new Insets(0.0, 35.0, 0.0, 0.0));
        this.lBillDiscountValue.setAlignment(Pos.CENTER_RIGHT);
        this.lBillDiscountValue.setMinWidth(96.0);
        this.lBillDiscountValue.setPrefWidth(96.0);
        this.lBillDiscountValue.setMaxWidth(Double.MAX_VALUE);
        this.lBillDiscountValue.setMinHeight(16.0);
        this.lBillDiscountValue.setPrefHeight(16.0);
        this.lBillDiscountValue.setMaxHeight(Double.MIN_VALUE);
        this.lBillDiscountValue.setStyle("-fx-background-color: transparent;");
        this.lBillDiscountValue.setEditable(true);
        this.lBillTotalSumValue.getStyleClass().add((Object)"totalValueSum");
        this.lBillTotalSumValue.setPadding(new Insets(0.0, 35.0, 0.0, 0.0));
        this.lBillTotalSumValue.setAlignment(Pos.CENTER_RIGHT);
        this.lBillTotalSumValue.setMinWidth(96.0);
        this.lBillTotalSumValue.setPrefWidth(96.0);
        this.lBillTotalSumValue.setMaxWidth(Double.MAX_VALUE);
        this.lBillTotalSumValue.setMinHeight(32.0);
        this.lBillTotalSumValue.setPrefHeight(32.0);
        this.lBillTotalSumValue.setMaxHeight(Double.MIN_VALUE);
        this.add((Node)lBillTotal, 0, 0);
        this.add((Node)lBillDiscount, 0, 1);
        this.add((Node)lBillTotalSum, 0, 2);
        this.add((Node)this.lBillTotalValue, 1, 0);
        this.add((Node)this.lBillDiscountValue, 1, 1);
        this.add((Node)this.lBillTotalSumValue, 1, 2);
    }

    public void refresh(Bill bill, ScreensController controller) {
        this.discount = 0.0;
        double value = bill.getSumWithDiscout();
        double pDiscount = 0.0;
        try {
            double pQuantity;
            double pQuantity2;
            double pPrice;
            int i;
            if (bill.getPerson() != null && bill.getPerson().getDiscount() != 0.0) {
                for (i = 0; i < bill.getRoundList().get(0).getItemList().size(); ++i) {
                    Product p1 = bill.getRoundList().get(0).getItemList().get(i).getProductDepartment().getProduct();
                    if (p1.isDiscountAllowed()) {
                        double cenaNova = 0.0;
                        if (Boolean.parseBoolean(controller.getSettings().getActualByName("loyalty.point.action"))) {
                            try {
                                cenaNova = Product.getCurrentPrice(p1.getProductID(), controller.getObject().getDepartmentID(controller.getObject().getObjectID(), controller.getSettings().getConnection()), bill.getPerson().getLoyality().isVipLoyaltyPrice(), controller.getSettings().getConnection()) - Product.getCurrentPrice(p1.getProductID(), controller.getObject().getDepartmentID(controller.getObject().getObjectID(), controller.getSettings().getConnection()), bill.getPerson().getLoyality().isVipLoyaltyPrice(), controller.getSettings().getConnection()) * controller.getCurrentBill().getPerson().getDiscount() / 100.0;
                            }
                            catch (NullPointerException e) {
                                cenaNova = Product.getCurrentPrice(p1.getProductID(), controller.getObject().getDepartmentID(controller.getObject().getObjectID(), controller.getSettings().getConnection()), false, controller.getSettings().getConnection()) - Product.getCurrentPrice(p1.getProductID(), controller.getObject().getDepartmentID(controller.getObject().getObjectID(), controller.getSettings().getConnection()), false, controller.getSettings().getConnection()) * controller.getCurrentBill().getPerson().getDiscount() / 100.0;
                            }
                            controller.getCurrentBill().getPerson().setDiscount((p1.getPrice() - cenaNova) * 100.0 / p1.getPrice());
                        }
                        pDiscount = p1.getDiscount() == 0.0 ? bill.getPerson().getDiscount() / 100.0 : p1.getDiscount() / 100.0;
                    } else {
                        pDiscount = 0.0;
                        controller.alert("Nedozvoljen popust ", "Artiklu: " + bill.getRoundList().get(0).getItemList().get(i).getProductDepartment().getProduct().getName() + "\n nije dozvoljen popust ", controller.getRoot().getScene().getWindow());
                    }
                    pPrice = bill.getRoundList().get(0).getItemList().get(i).getProductDepartment().getProduct().getPrice();
                    pQuantity2 = bill.getRoundList().get(0).getItemList().get(i).getQuantity();
                    this.discount += pPrice * pDiscount * pQuantity2;
                }
                value = bill.getSumWithDiscout();
            }
            if (bill.getPerson() != null && bill.getPerson().getDiscount() == 0.0) {
                for (i = 0; i < bill.getRoundList().get(0).getItemList().size(); ++i) {
                    BuyerOfferPrice buyerOfferPrice = BuyerOfferPrice.getOfferPrice(bill.getPerson().getBuyerOfferPriceID(), controller.getSettings().getConnection());
                    if (buyerOfferPrice.getBuyerOfferPriceID() != null) {
                        BuyerOfferPriceDetailes buyerOfferPriceDetailes = BuyerOfferPriceDetailes.getRoundActive(bill.getRoundList().get(0).getItemList().get(i).getProductDepartment().getProduct().getProductID(), buyerOfferPrice.getBuyerOfferPriceID(), controller.getSettings().getConnection());
                        if (buyerOfferPriceDetailes.getBuyerOfferPriceDetailsID() != 0L) {
                            bill.getRoundList().get(0).getItemList().get(i).getProductDepartment().getProduct().setDiscount((bill.getRoundList().get(0).getItemList().get(i).getProductDepartment().getProduct().getPrice() - buyerOfferPriceDetailes.getPrice()) * 100.0 / bill.getRoundList().get(0).getItemList().get(i).getProductDepartment().getProduct().getPrice());
                            pDiscount = bill.getRoundList().get(0).getItemList().get(i).getProductDepartment().getProduct().getDiscount() / 100.0;
                        }
                    } else if (bill.getPerson().getLoyality() != null) {
                        if (bill.getRoundList().get(0).getItemList().get(i).getProductDepartment().getProduct().isDiscountAllowed()) {
                            Product p1 = bill.getRoundList().get(0).getItemList().get(i).getProductDepartment().getProduct();
                            double p1Price = Product.getCurrentPrice(bill.getRoundList().get(0).getItemList().get(i).getProductDepartment().getProductID(), controller.getObject().getDepartmentID(controller.getObject().getObjectID(), controller.getSettings().getConnection()), bill.getPerson().getLoyality().isVipLoyaltyPrice(), controller.getSettings().getConnection());
                            p1.setPrice(p1Price);
                            if (Boolean.parseBoolean(controller.getSettings().getActualByName("loyalty.point.action"))) {
                                controller.getCurrentBill().getPerson().setDiscount(controller.getCurrentBill().getPerson().getLoyality().getDiscount() + 100.0 * controller.getCurrentBill().getPerson().getLoyality().getPoints() * controller.getCurrentBill().getPerson().getLoyality().getSellingPointsValue() / bill.getSumWithDiscout());
                            }
                            pDiscount = p1.getDiscount() > 0.0 ? p1.getDiscount() / 100.0 : bill.getPerson().getDiscount() / 100.0;
                        } else {
                            pDiscount = 0.0;
                            controller.alert("Nedozvoljen popust ", "Artiklu: " + bill.getRoundList().get(0).getItemList().get(i).getProductDepartment().getProduct().getName() + "\n nije dozvoljen popust ", controller.getRoot().getScene().getWindow());
                        }
                    } else {
                        pDiscount = 0.0;
                    }
                    pPrice = bill.getRoundList().get(0).getItemList().get(i).getProductDepartment().getProduct().getPrice();
                    pQuantity2 = bill.getRoundList().get(0).getItemList().get(i).getQuantity();
                    this.discount += pPrice * pDiscount * pQuantity2;
                }
                value = bill.getSumWithDiscout();
            }
            if (bill.getPerson() == null && bill.getDiscount() == 0.0) {
                for (i = 0; i < bill.getRoundList().get(0).getItemList().size(); ++i) {
                    double pPrice2 = bill.getRoundList().get(0).getItemList().get(i).getProductDepartment().getProduct().getPrice();
                    pDiscount = bill.getRoundList().get(0).getItemList().get(i).getProductDepartment().getProduct().getDiscount() / 100.0;
                    pQuantity = bill.getRoundList().get(0).getItemList().get(i).getQuantity();
                    this.discount += pPrice2 * pDiscount * pQuantity;
                }
            }
            if (bill.getPerson() == null && bill.getDiscount() != 0.0) {
                for (i = 0; i < bill.getRoundList().get(0).getItemList().size(); ++i) {
                    bill.getRoundList().get(0).getItemList().get(i).getProductDepartment().getProduct().setDiscount(bill.getDiscount());
                    double pPrice3 = bill.getRoundList().get(0).getItemList().get(i).getProductDepartment().getProduct().getPrice();
                    pDiscount = bill.getRoundList().get(0).getItemList().get(i).getProductDepartment().getProduct().getDiscount() / 100.0;
                    pQuantity = bill.getRoundList().get(0).getItemList().get(i).getQuantity();
                    this.discount += pPrice3 * pDiscount * pQuantity;
                }
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        this.lBillTotalValue.setText(this.nf.format(value));
        if (this.discount == 0.0) {
            this.lBillDiscountValue.setText(this.nf.format(this.discount) + "%");
        } else {
            this.lBillDiscountValue.setText(this.nf.format(this.discount / value * 100.0) + "%");
        }
        this.lBillTotalSumValue.setText(this.nf.format(bill.getFinalSumWithDiscout()));
    }

    public void refresh(Bill bill, RoundItem ri) {
        double value = bill.getSumWithDiscout();
        double pDiscount = ri.getProductDepartment().getProduct().getDiscount() / 100.0;
        this.lBillTotalValue.setText(this.nf.format(value));
        if (pDiscount == 0.0) {
            this.lBillDiscountValue.setText(this.nf.format(pDiscount) + "%");
        } else {
            this.lBillDiscountValue.setText(this.nf.format(pDiscount * 100.0) + "%");
        }
        this.lBillTotalSumValue.setText(this.nf.format(value - this.discount));
    }

    public TextField getlBillDiscountValue() {
        return this.lBillDiscountValue;
    }

    public void setlBillDiscountValue(TextField lBillDiscountValue) {
        this.lBillDiscountValue = lBillDiscountValue;
    }
}

