/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TreeCell;
import javafx.scene.layout.HBox;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.PosMenu;

public class UserPosMenuCheckBoxCell
extends TreeCell<PosMenu> {
    HBox cellBox = new HBox();
    CheckBox checkBox = new CheckBox();
    Label label = new Label("");
    ObservableList<PosMenu> list = FXCollections.emptyObservableList();
    PosMenu pm;

    public UserPosMenuCheckBoxCell(long UserID, ScreensController controller) {
        this.label.prefHeightProperty().bind((ObservableValue)this.checkBox.heightProperty());
        this.checkBox.setSelected(false);
        this.cellBox.getChildren().addAll((Object[])new Node[]{this.checkBox, this.label});
        this.list = PosMenu.getFullListID(UserID, controller.getSettings().getConnection());
        this.checkBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                UserPosMenuCheckBoxCell.this.pm.setSelected(newValue);
            }
        });
    }

    public void updateItem(PosMenu item, boolean empty) {
        super.updateItem((Object)item, empty);
        this.pm = item;
        if (this.isEmpty()) {
            this.setGraphic(null);
            this.setText(null);
        } else {
            boolean select = false;
            if (this.getTreeItem().isLeaf() && !this.list.isEmpty()) {
                for (PosMenu pMenu : this.list) {
                    if (pMenu.getPosMenuID() != this.pm.getPosMenuID()) continue;
                    select = true;
                }
                this.label.setText(this.pm.getTitle());
                this.checkBox.setSelected(select);
                this.setGraphic((Node)this.cellBox);
            } else {
                this.label.setText(this.pm.getTitle());
                this.checkBox.setSelected(select);
                this.setGraphic((Node)this.cellBox);
            }
        }
    }
}

