/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui;

import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Cell;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.Tooltip;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javafx.util.converter.DefaultStringConverter;

public class TooltippedTableCell<S, T>
extends TableCell<S, T> {
    private ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty((Object)this, "converter");

    public static <S> Callback<TableColumn<S, String>, TableCell<S, String>> forTableColumn() {
        return TooltippedTableCell.forTableColumn(new DefaultStringConverter());
    }

    public static <S, T> Callback<TableColumn<S, T>, TableCell<S, T>> forTableColumn(StringConverter<T> converter) {
        return list -> new TooltippedTableCell(converter);
    }

    private static <T> String getItemText(Cell<T> cell, StringConverter<T> converter) {
        return converter == null ? (cell.getItem() == null ? "" : cell.getItem().toString()) : converter.toString(cell.getItem());
    }

    private void updateItem(Cell<T> cell, StringConverter<T> converter) {
        if (cell.isEmpty()) {
            cell.setText(null);
            cell.setTooltip(null);
        } else {
            cell.setText(TooltippedTableCell.getItemText(cell, converter));
            Tooltip tooltip = new Tooltip(TooltippedTableCell.getItemText(cell, converter));
            tooltip.setWrapText(true);
            tooltip.prefWidthProperty().bind((ObservableValue)cell.widthProperty());
            cell.setTooltip(tooltip);
        }
    }

    public TooltippedTableCell() {
        this(null);
    }

    public TooltippedTableCell(StringConverter<T> converter) {
        this.getStyleClass().add((Object)"tooltipped-table-cell");
        this.setConverter(converter);
    }

    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setConverter(StringConverter<T> value) {
        this.converterProperty().set(value);
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converterProperty().get();
    }

    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        this.updateItem((Cell<T>)this, this.getConverter());
    }
}

