/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui;

import java.util.regex.Pattern;
import javafx.beans.Observable;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TextField;

public class TimeTextField
extends TextField {
    private final Pattern timePattern = Pattern.compile("\\d\\d:\\d\\d:\\d\\d");
    private final ReadOnlyIntegerWrapper hours;
    private final ReadOnlyIntegerWrapper minutes;
    private final ReadOnlyIntegerWrapper seconds;

    public TimeTextField() {
        this("00:00:00");
    }

    public TimeTextField(String time) {
        super(time);
        if (!this.validate(time)) {
            throw new IllegalArgumentException("Invalid time: " + time);
        }
        this.hours = new ReadOnlyIntegerWrapper((Object)this, "hours");
        this.minutes = new ReadOnlyIntegerWrapper((Object)this, "minutes");
        this.seconds = new ReadOnlyIntegerWrapper((Object)this, "seconds");
        this.hours.bind((ObservableValue)new TimeUnitBinding(Unit.HOURS));
        this.minutes.bind((ObservableValue)new TimeUnitBinding(Unit.MINUTES));
        this.seconds.bind((ObservableValue)new TimeUnitBinding(Unit.SECONDS));
    }

    public ReadOnlyIntegerProperty hoursProperty() {
        return this.hours.getReadOnlyProperty();
    }

    public int getHours() {
        return this.hours.get();
    }

    public ReadOnlyIntegerProperty minutesProperty() {
        return this.minutes.getReadOnlyProperty();
    }

    public int getMinutes() {
        return this.minutes.get();
    }

    public ReadOnlyIntegerProperty secondsProperty() {
        return this.seconds.getReadOnlyProperty();
    }

    public int getSeconds() {
        return this.seconds.get();
    }

    public void appendText(String text) {
    }

    public boolean deleteNextChar() {
        boolean success = false;
        IndexRange selection = this.getSelection();
        if (selection.getLength() > 0) {
            int selectionEnd = selection.getEnd();
            this.deleteText(selection);
            this.positionCaret(selectionEnd);
            success = true;
        } else {
            int caret = this.getCaretPosition();
            if (caret % 3 != 2) {
                String currentText = this.getText();
                this.setText(currentText.substring(0, caret) + "0" + currentText.substring(caret + 1));
                success = true;
            }
            this.positionCaret(Math.min(caret + 1, this.getText().length()));
        }
        return success;
    }

    public boolean deletePreviousChar() {
        boolean success = false;
        IndexRange selection = this.getSelection();
        if (selection.getLength() > 0) {
            int selectionStart = selection.getStart();
            this.deleteText(selection);
            this.positionCaret(selectionStart);
            success = true;
        } else {
            int caret = this.getCaretPosition();
            if (caret % 3 != 0) {
                String currentText = this.getText();
                this.setText(currentText.substring(0, caret - 1) + "0" + currentText.substring(caret));
                success = true;
            }
            this.positionCaret(Math.max(caret - 1, 0));
        }
        return success;
    }

    public void deleteText(IndexRange range) {
        this.deleteText(range.getStart(), range.getEnd());
    }

    public void deleteText(int begin, int end) {
        StringBuilder builder = new StringBuilder(this.getText());
        for (int c = begin; c < end; ++c) {
            if (c % 3 == 2) continue;
            builder.replace(c, c + 1, "0");
        }
        this.setText(builder.toString());
    }

    public void insertText(int index, String text) {
        StringBuilder builder = new StringBuilder(this.getText());
        builder.replace(index, index + text.length(), text);
        String testText = builder.toString();
        if (this.validate(testText)) {
            this.setText(testText);
        }
        this.positionCaret(index + text.length());
    }

    public void replaceSelection(String replacement) {
        IndexRange selection = this.getSelection();
        if (selection.getLength() == 0) {
            this.insertText(selection.getStart(), replacement);
        } else {
            this.replaceText(selection.getStart(), selection.getEnd(), replacement);
        }
    }

    public void replaceText(IndexRange range, String text) {
        this.replaceText(range.getStart(), range.getEnd(), text);
    }

    public void replaceText(int begin, int end, String text) {
        if (begin == end) {
            this.insertText(begin, text);
        } else if (text.length() == end - begin) {
            StringBuilder builder = new StringBuilder(this.getText());
            builder.replace(begin, end, text);
            String testText = builder.toString();
            if (this.validate(testText)) {
                this.setText(testText);
            }
            this.positionCaret(end);
        }
    }

    private boolean validate(String time) {
        if (!this.timePattern.matcher(time).matches()) {
            return false;
        }
        String[] tokens = time.split(":");
        assert (tokens.length == 3);
        try {
            int hours = Integer.parseInt(tokens[0]);
            int mins = Integer.parseInt(tokens[1]);
            int secs = Integer.parseInt(tokens[2]);
            if (hours < 0 || hours > 23) {
                return false;
            }
            if (mins < 0 || mins > 59) {
                return false;
            }
            return secs >= 0 && secs <= 59;
        }
        catch (NumberFormatException nfe) {
            assert (false);
            return false;
        }
    }

    private final class TimeUnitBinding
    extends IntegerBinding {
        final Unit unit;

        TimeUnitBinding(Unit unit) {
            this.bind(new Observable[]{TimeTextField.this.textProperty()});
            this.unit = unit;
        }

        protected int computeValue() {
            String token = TimeTextField.this.getText().split(":")[this.unit.ordinal()];
            return Integer.parseInt(token);
        }
    }

    static enum Unit {
        HOURS,
        MINUTES,
        SECONDS;

    }
}

