/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui;

import java.text.DecimalFormatSymbols;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TextField;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class EditingTableCellText
extends TableCell<Object, String> {
    private TextField textField;
    private String decimalPlaces;
    private boolean useGrouping;

    public EditingTableCellText(String decimalPlaces, boolean useGrouping) {
        this.decimalPlaces = decimalPlaces;
        this.useGrouping = useGrouping;
    }

    public void startEdit() {
        if (!this.isEmpty()) {
            super.startEdit();
            this.createTextField();
            this.setText(null);
            this.setGraphic((Node)this.textField);
            this.textField.selectAll();
        }
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText("");
        this.setGraphic(null);
    }

    public void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.textField != null) {
                this.textField.setText(this.decimalPlaces);
            }
            this.setText(null);
            this.setGraphic((Node)this.textField);
        } else {
            this.setText(this.decimalPlaces);
            this.setGraphic(null);
        }
    }

    private void createTextField() {
        this.textField = new TextField(this.getString());
        this.textField.getStyleClass().add((Object)"textFieldEdit");
        this.textField.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.textField.textProperty().addListener((obsValue, oldValue, newValue) -> {
            if (newValue.substring(newValue.length() - 1).equals(".")) {
                this.textField.setText(oldValue + DecimalFormatSymbols.getInstance().getDecimalSeparator());
            }
        });
        this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                if (!arg2.booleanValue()) {
                    EditingTableCellText.this.commitEdit(EditingTableCellText.this.decimalPlaces);
                }
            }
        });
        this.textField.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER || t.getCode() == KeyCode.TAB) {
                    EditingTableCellText.this.commitEdit(EditingTableCellText.this.decimalPlaces);
                } else if (t.getCode() == KeyCode.ESCAPE) {
                    EditingTableCellText.this.cancelEdit();
                }
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : this.decimalPlaces;
    }
}

