/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui;

import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.cell.ComboBoxTableCell;
import rs.petcom.master.gui.AutoCompleteComboBoxListener;

public class ComboBoxCellTable
extends ComboBoxTableCell<Object, String> {
    private ComboBox<Object> comboBox;
    ObservableList<String> itemsList;

    public ComboBoxCellTable(ObservableList<String> itemsList) {
        this.itemsList = itemsList;
    }

    public void commitEdit(String newValue) {
        super.commitEdit((Object)newValue);
    }

    public void startEdit() {
        super.startEdit();
        if (this.comboBox == null) {
            this.createComboBox();
        }
        this.setGraphic((Node)this.comboBox);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(String.valueOf(this.getItem()));
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
    }

    public void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.comboBox != null) {
                this.comboBox.setValue((Object)this.getString());
            }
            this.setGraphic((Node)this.comboBox);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        } else {
            this.setText(this.getString());
            this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        }
    }

    private void createComboBox() {
        this.comboBox = new ComboBox();
        this.comboBox.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        new AutoCompleteComboBoxListener(this.comboBox);
    }

    private String getString() {
        return this.getItem() == null ? "" : ((String)this.getItem()).toString();
    }
}

