/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui;

import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class ComboBoxCell<ClassesProperty>
extends TableCell<ClassesProperty, Object> {
    private ComboBox<Object> comboBox;
    ObservableList<Object> itemsList;

    public ComboBoxCell(ObservableList<Object> itemsList) {
        this.itemsList = itemsList;
    }

    public void startEdit() {
        super.startEdit();
        if (this.comboBox == null) {
            this.createComboBox(this.itemsList);
        }
        this.setGraphic((Node)this.comboBox);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setText(String.valueOf(this.getItem()));
        this.setContentDisplay(ContentDisplay.TEXT_ONLY);
    }

    public void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
        } else if (this.isEditing()) {
            if (this.comboBox != null) {
                this.comboBox.setValue((Object)this.getString());
            }
            this.setGraphic((Node)this.comboBox);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        } else {
            this.setText(this.getString());
            this.setContentDisplay(ContentDisplay.TEXT_ONLY);
        }
    }

    private void createComboBox(ObservableList<Object> itemsList) {
        this.comboBox = new ComboBox(itemsList);
        this.comboBox.setMinWidth(this.getWidth() - this.getGraphicTextGap() * 2.0);
        this.comboBox.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent t) {
                if (t.getCode() == KeyCode.ENTER) {
                    ComboBoxCell.this.commitEdit(ComboBoxCell.this.comboBox.getSelectionModel().getSelectedItem());
                } else if (t.getCode() == KeyCode.ESCAPE) {
                    ComboBoxCell.this.cancelEdit();
                }
            }
        });
    }

    private String getString() {
        return this.getItem() == null ? "" : this.getItem().toString();
    }
}

