/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.TableCell;

public class BooleanCell
extends TableCell<Object, Boolean> {
    private CheckBox checkBox = new CheckBox();

    public BooleanCell() {
        this.checkBox.setDisable(true);
        this.checkBox.selectedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                if (BooleanCell.this.isEditing()) {
                    BooleanCell.this.commitEdit(newValue == null ? false : newValue);
                }
            }
        });
        this.setGraphic((Node)this.checkBox);
        this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.setEditable(true);
    }

    public void startEdit() {
        super.startEdit();
        if (this.isEmpty()) {
            return;
        }
        this.checkBox.setDisable(false);
        this.checkBox.requestFocus();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.checkBox.setDisable(true);
    }

    public void commitEdit(Boolean value) {
        super.commitEdit((Object)value);
        this.checkBox.setDisable(true);
    }

    public void updateItem(Boolean item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (!this.isEmpty()) {
            this.checkBox.setSelected(item.booleanValue());
        }
    }
}

