/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui;

import java.text.NumberFormat;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import rs.petcom.master.dal.Bill;

public class BillSummarySum
extends GridPane {
    private Label lBillTotalValue = new Label("0,00");
    private Label lBillDiscountValue = new Label("0,00");
    private Label lBillTotalSumValue = new Label("0,00");

    public BillSummarySum() {
        this.setMinHeight(64.0);
        this.setPrefHeight(64.0);
        this.setMaxHeight(Double.MAX_VALUE);
        this.getStyleClass().add((Object)"billSummarySum");
        this.getStyleClass().add((Object)"borderTopBottom");
        ColumnConstraints column1 = new ColumnConstraints(96.0, 96.0, Double.MAX_VALUE);
        column1.setFillWidth(true);
        column1.setHgrow(Priority.ALWAYS);
        ColumnConstraints column2 = new ColumnConstraints(96.0, 96.0, Double.MAX_VALUE);
        column2.setFillWidth(true);
        column2.setHgrow(Priority.ALWAYS);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column1, column2});
        RowConstraints row1 = new RowConstraints(16.0, 16.0, Double.MAX_VALUE);
        row1.setVgrow(Priority.ALWAYS);
        row1.setValignment(VPos.CENTER);
        this.getRowConstraints().add((Object)row1);
        RowConstraints row2 = new RowConstraints(16.0, 16.0, Double.MAX_VALUE);
        row2.setVgrow(Priority.ALWAYS);
        row2.setValignment(VPos.CENTER);
        this.getRowConstraints().add((Object)row2);
        RowConstraints row3 = new RowConstraints(32.0, 32.0, Double.MAX_VALUE);
        row3.setVgrow(Priority.ALWAYS);
        row3.setValignment(VPos.CENTER);
        this.getRowConstraints().add((Object)row3);
        Label lBillTotal = new Label("Total ra\u010dun");
        lBillTotal.getStyleClass().add((Object)"totalLabel");
        lBillTotal.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        lBillTotal.setAlignment(Pos.CENTER_LEFT);
        lBillTotal.setMinWidth(96.0);
        lBillTotal.setPrefWidth(96.0);
        lBillTotal.setMaxWidth(Double.MAX_VALUE);
        lBillTotal.setMinHeight(16.0);
        lBillTotal.setPrefHeight(16.0);
        lBillTotal.setMaxHeight(Double.MIN_VALUE);
        Label lBillDiscount = new Label("Popust");
        lBillDiscount.getStyleClass().add((Object)"totalLabel");
        lBillDiscount.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        lBillDiscount.setAlignment(Pos.CENTER_LEFT);
        lBillDiscount.setMinWidth(96.0);
        lBillDiscount.setPrefWidth(96.0);
        lBillDiscount.setMaxWidth(Double.MAX_VALUE);
        lBillDiscount.setMinHeight(16.0);
        lBillDiscount.setPrefHeight(16.0);
        lBillDiscount.setMaxHeight(Double.MIN_VALUE);
        Label lBillTotalSum = new Label("Total za naplatu");
        lBillTotalSum.getStyleClass().add((Object)"totalLabelSum");
        lBillTotalSum.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        lBillTotalSum.setAlignment(Pos.CENTER_LEFT);
        lBillTotalSum.setMinWidth(96.0);
        lBillTotalSum.setPrefWidth(96.0);
        lBillTotalSum.setMaxWidth(Double.MAX_VALUE);
        lBillTotalSum.setMinHeight(32.0);
        lBillTotalSum.setPrefHeight(32.0);
        lBillTotalSum.setMaxHeight(Double.MIN_VALUE);
        this.lBillTotalValue.getStyleClass().add((Object)"totalValue");
        this.lBillTotalValue.setPadding(new Insets(0.0, 5.0, 0.0, 0.0));
        this.lBillTotalValue.setAlignment(Pos.CENTER_RIGHT);
        this.lBillTotalValue.setMinWidth(96.0);
        this.lBillTotalValue.setPrefWidth(96.0);
        this.lBillTotalValue.setMaxWidth(Double.MAX_VALUE);
        this.lBillTotalValue.setMinHeight(16.0);
        this.lBillTotalValue.setPrefHeight(16.0);
        this.lBillTotalValue.setMaxHeight(Double.MIN_VALUE);
        this.lBillDiscountValue.getStyleClass().add((Object)"totalValue");
        this.lBillDiscountValue.setPadding(new Insets(0.0, 5.0, 0.0, 0.0));
        this.lBillDiscountValue.setAlignment(Pos.CENTER_RIGHT);
        this.lBillDiscountValue.setMinWidth(96.0);
        this.lBillDiscountValue.setPrefWidth(96.0);
        this.lBillDiscountValue.setMaxWidth(Double.MAX_VALUE);
        this.lBillDiscountValue.setMinHeight(16.0);
        this.lBillDiscountValue.setPrefHeight(16.0);
        this.lBillDiscountValue.setMaxHeight(Double.MIN_VALUE);
        this.lBillTotalSumValue.getStyleClass().add((Object)"totalValueSum");
        this.lBillTotalSumValue.setPadding(new Insets(0.0, 5.0, 0.0, 0.0));
        this.lBillTotalSumValue.setAlignment(Pos.CENTER_RIGHT);
        this.lBillTotalSumValue.setMinWidth(96.0);
        this.lBillTotalSumValue.setPrefWidth(96.0);
        this.lBillTotalSumValue.setMaxWidth(Double.MAX_VALUE);
        this.lBillTotalSumValue.setMinHeight(32.0);
        this.lBillTotalSumValue.setPrefHeight(32.0);
        this.lBillTotalSumValue.setMaxHeight(Double.MIN_VALUE);
        this.add((Node)lBillTotal, 0, 0);
        this.add((Node)lBillDiscount, 0, 1);
        this.add((Node)lBillTotalSum, 0, 2);
        this.add((Node)this.lBillTotalValue, 1, 0);
        this.add((Node)this.lBillDiscountValue, 1, 1);
        this.add((Node)this.lBillTotalSumValue, 1, 2);
    }

    public void refresh(Bill bill) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setMaximumFractionDigits(2);
        nf.setMinimumFractionDigits(2);
        nf.setGroupingUsed(true);
        double value = bill.getSumWithDiscout();
        double discount = 0.0;
        try {
            discount = value * bill.getPerson().getDiscount() / 100.0;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.lBillTotalValue.setText(nf.format(value));
        this.lBillDiscountValue.setText(nf.format(discount));
        this.lBillTotalSumValue.setText(nf.format(value - discount));
    }
}

