/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.gui;

import java.text.NumberFormat;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import rs.petcom.master.dal.RoundItem;
import rs.petcom.master.gui.BillSummaryItem;

public class BillSummaryItemAditional
extends GridPane {
    private RoundItem roundItem;
    private boolean selected;
    Label lArtikal = new Label();
    Label lKolicina = new Label();
    Label lCena = new Label();
    NumberFormat nf = NumberFormat.getNumberInstance();
    private int itmeHeight = BillSummaryItem.summaryItemHeight;

    public RoundItem getRoundItem() {
        return this.roundItem;
    }

    public void setRoundItem(RoundItem roundItem) {
        this.roundItem = roundItem;
        this.lArtikal.setText(this.roundItem.getProductDepartment().getProduct().getName());
        this.lKolicina.setText(this.nf.format(this.roundItem.getQuantity()));
        this.lCena.setText(this.nf.format(this.roundItem.getSumWithDiscount()));
    }

    public int getItemHeight() {
        return this.itmeHeight;
    }

    public void setItemHeight(int height) {
        this.itmeHeight = height;
    }

    public BillSummaryItemAditional(RoundItem roundItem) {
        this.roundItem = roundItem;
        this.nf.setMaximumFractionDigits(2);
        this.nf.setMinimumFractionDigits(2);
        this.nf.setGroupingUsed(true);
        this.setMinHeight(this.itmeHeight);
        this.setPrefHeight(this.itmeHeight);
        this.setMaxHeight(this.itmeHeight);
        ColumnConstraints column1 = new ColumnConstraints(150.0, 150.0, Double.MAX_VALUE);
        column1.setFillWidth(true);
        column1.setHgrow(Priority.ALWAYS);
        ColumnConstraints column2 = new ColumnConstraints(60.0, 60.0, 30.0);
        column2.setHgrow(Priority.NEVER);
        ColumnConstraints column3 = new ColumnConstraints(100.0, 100.0, 100.0);
        column3.setHgrow(Priority.NEVER);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column1, column2, column3});
        RowConstraints row1 = new RowConstraints((double)(this.itmeHeight - 1), (double)(this.itmeHeight - 1), (double)(this.itmeHeight - 1));
        row1.setVgrow(Priority.ALWAYS);
        row1.setValignment(VPos.CENTER);
        this.getRowConstraints().add((Object)row1);
        this.lArtikal.getStyleClass().add((Object)"billSummaryItemLabel");
        this.lArtikal.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        this.lArtikal.setAlignment(Pos.CENTER_LEFT);
        this.lArtikal.setMinWidth(100.0);
        this.lArtikal.setPrefWidth(100.0);
        this.lArtikal.setMaxWidth(Double.MAX_VALUE);
        this.lArtikal.setMinHeight((double)this.itmeHeight);
        this.lArtikal.setPrefHeight((double)this.itmeHeight);
        this.lArtikal.setMaxHeight((double)this.itmeHeight);
        this.lKolicina.getStyleClass().add((Object)"billSummaryItemLabel");
        this.lKolicina.setAlignment(Pos.CENTER_RIGHT);
        this.lKolicina.setMinWidth(30.0);
        this.lKolicina.setPrefWidth(60.0);
        this.lKolicina.setMaxWidth(60.0);
        this.lKolicina.setMinHeight((double)this.itmeHeight);
        this.lKolicina.setPrefHeight((double)this.itmeHeight);
        this.lKolicina.setMaxHeight((double)this.itmeHeight);
        this.lCena.getStyleClass().add((Object)"billSummaryItemLabel");
        this.lCena.setAlignment(Pos.CENTER_RIGHT);
        this.lCena.setMinWidth(100.0);
        this.lCena.setPrefWidth(100.0);
        this.lCena.setMaxWidth(100.0);
        this.lCena.setMinHeight((double)this.itmeHeight);
        this.lCena.setPrefHeight((double)this.itmeHeight);
        this.lCena.setMaxHeight((double)this.itmeHeight);
        this.add((Node)this.lArtikal, 0, 0);
        this.add((Node)this.lKolicina, 1, 0);
        this.add((Node)this.lCena, 2, 0);
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, (EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                if (!BillSummaryItemAditional.this.selected) {
                    ((BillSummaryItem)BillSummaryItemAditional.this.getParent()).unselectAll();
                    BillSummaryItemAditional.this.getStyleClass().remove((Object)"billSummaryItem");
                    BillSummaryItemAditional.this.getStyleClass().add((Object)"billSummaryItemSelected");
                    BillSummaryItemAditional.this.selected = true;
                } else {
                    BillSummaryItemAditional.this.getStyleClass().remove((Object)"billSummaryItemSelected");
                    BillSummaryItemAditional.this.getStyleClass().add((Object)"billSummaryItem");
                    BillSummaryItemAditional.this.selected = false;
                }
            }
        });
    }

    public void refresh() {
        this.lArtikal.setText(" - " + this.roundItem.getProductDepartment().getProduct().getName());
        this.lKolicina.setText(this.nf.format(this.roundItem.getQuantity()));
        this.lCena.setText(this.nf.format(this.roundItem.getQuantity() * this.roundItem.getProductDepartment().getProduct().getPrice()));
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        if (selected) {
            this.getStyleClass().remove((Object)"billSummaryItem");
            this.getStyleClass().add((Object)"billSummaryItemSelected");
        } else {
            this.getStyleClass().remove((Object)"billSummaryItemSelected");
            this.getStyleClass().add((Object)"billSummaryItem");
        }
    }

    public boolean isSelected() {
        return this.selected;
    }
}

