/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.fical;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class XMLGenericModel {
    protected DocumentBuilderFactory documentFactory;
    protected DocumentBuilder documentBuilder;
    protected Document document;

    protected XMLGenericModel() {
        try {
            this.documentFactory = DocumentBuilderFactory.newInstance();
            this.documentBuilder = this.documentFactory.newDocumentBuilder();
            this.document = this.documentBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    public abstract void makeContent();

    public void makeXML(String path) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(this.document);
            File file = new File(path);
            StreamResult result = new StreamResult(file.toURI().getPath());
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
    }

    protected Element makeCharLine(String elementName, char lineChar, int numOfChar) {
        Element line = this.document.createElement(elementName);
        line.appendChild(this.document.createTextNode(this.makeLine(lineChar, numOfChar)));
        return line;
    }

    protected Element makeElelment(String elementName, String content) {
        Element element = this.document.createElement(elementName);
        element.appendChild(this.document.createTextNode(content));
        return element;
    }

    private String makeLine(char lineChar, int numOfChar) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < numOfChar; ++i) {
            sb.append(lineChar);
        }
        return sb.toString();
    }
}

