/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.fical;

import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.w3c.dom.Element;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Object;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.person.Address;
import rs.petcom.master.dal.person.Person;
import rs.petcom.master.fical.XMLGenericModel;

public class NarrowGotBill
extends XMLGenericModel {
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS");
    private SimpleDateFormat sdfPrint = new SimpleDateFormat("dd.MM.yyyy.");
    private ScreensController controller;
    private Connection connection;
    private String path;
    private Document doc;
    private double vat_E;
    private double vat_Dj;

    public NarrowGotBill(Document doc, ScreensController controller) {
        this.path = controller.getSettings().getFiscalFolder() + this.sdf.format(new Date()) + ".xml";
        this.doc = doc;
        this.controller = controller;
        this.connection = controller.getSettings().getConnection();
        this.vat_E = 0.0;
        this.vat_Dj = 0.0;
    }

    @Override
    public void makeContent() {
        Element root = this.document.createElement("NefiskalnaStampa");
        this.document.appendChild(root);
        this.makeNarrowHeader(root);
        this.makeNarrowBuyer(root);
        this.makeNarrowNumber(root);
        this.makeNarrowBillItems(root);
        this.makeNarrowSummary(root);
        this.makeNarrowSignature(root);
        this.makeXML(this.path);
    }

    private void makeNarrowHeader(Element root) {
        Object obj = Object.get(this.connection);
        Address address = Address.getByID(obj.getAddressID(), this.connection);
        this.contentMultiRow(obj.getName(), root);
        this.contentMultiRow(address.getAddress(), root);
        this.contentMultiRow(address.getZip() + " " + address.getCity(), root);
        this.contentMultiRow("PorIdBroj:" + obj.getPIB(), root);
        this.contentMultiRow("MB:" + obj.getMB(), root);
        root.appendChild(this.makeCharLine("Linija", '*', 32));
    }

    private void makeNarrowBuyer(Element root) {
        Person person = Person.getById(this.doc.getPersonID(), this.controller);
        root.appendChild(this.makeElelment("Linija", "Kupac:"));
        root.appendChild(this.makeCharLine("Linija", '*', 32));
        root.appendChild(this.makeElelment("Linija", person.getName()));
        root.appendChild(this.makeElelment("Linija", person.getAddress()));
        root.appendChild(this.makeElelment("Linija", person.getZIP() + " " + person.getCity()));
        root.appendChild(this.makeElelment("Linija", "PorIdBroj:" + person.getPIB()));
        root.appendChild(this.makeElelment("Linija", "MB:" + person.getMB()));
        root.appendChild(this.makeCharLine("Linija", '*', 32));
    }

    private void makeNarrowNumber(Element root) {
        root.appendChild(this.makeElelment("Linija", this.contentInTheMiddle("Broj ra\u010duna:" + this.doc.getNumber())));
        root.appendChild(this.makeElelment("Linija", this.contentInTheMiddle("BI:" + this.doc.getBi())));
        root.appendChild(this.makeCharLine("Linija", '*', 32));
    }

    private void makeNarrowBillItems(Element root) {
        String price = "";
        String value = "";
        String quantity = "";
        ArrayList<DocumentDetails> details = DocumentDetails.getList(this.doc.getDocumentID(), this.connection);
        for (DocumentDetails detail : details) {
            quantity = String.valueOf(detail.getQuantity());
            price = String.valueOf(detail.getPriceWithDiscount());
            value = String.valueOf(detail.getValue());
            this.sumVat(detail.getVatID(), detail.getValue());
            this.contentMultiRow(detail.getProductName(), root);
            root.appendChild(this.makeElelment("Linija", this.contentFinancial(quantity, price, value)));
            root.appendChild(this.makeElelment("Linija", ""));
        }
        root.appendChild(this.makeCharLine("Linija", '*', 32));
    }

    private void makeNarrowSummary(Element root) {
        root.appendChild(this.makeElelment("Linija", this.contentAtTheEnd("Ukupno:" + this.doc.getSumWithDiscount())));
        root.appendChild(this.makeCharLine("Linija", '*', 32));
        if (this.isObjecyInVatSystem()) {
            root.appendChild(this.makeElelment("Linija", "Pdv osnovica: " + Settings.round(this.doc.getSumWithDiscount() - this.vat_Dj - this.vat_E, 2)));
            if (this.vat_Dj > 0.0) {
                root.appendChild(this.makeElelment("Linija", "Pdv po 20%: " + Settings.round(this.vat_Dj, 2)));
            }
            if (this.vat_E > 0.0) {
                root.appendChild(this.makeElelment("Linija", "Pdv po 10%: " + Settings.round(this.vat_E, 2)));
            }
        } else {
            root.appendChild(this.makeElelment("Linija", "Objekat van PDV-a."));
            root.appendChild(this.makeElelment("Linija", "Ukupan iznos PDV-a: 0.00"));
        }
        root.appendChild(this.makeCharLine("Linija", '*', 32));
        this.contentMultiRow("slovima:" + ScreensController.BrojUSlova(this.doc.getSumWithDiscount()), root);
        root.appendChild(this.makeCharLine("Linija", '*', 32));
    }

    private void makeNarrowSignature(Element root) {
        root.appendChild(this.makeElelment("Linija", ""));
        root.appendChild(this.makeElelment("Linija", "Robu izdao:"));
        root.appendChild(this.makeElelment("Linija", ""));
        root.appendChild(this.makeCharLine("Linija", '.', 32));
        root.appendChild(this.makeElelment("Linija", ""));
        root.appendChild(this.makeElelment("Linija", "Robu primio:"));
        root.appendChild(this.makeElelment("Linija", ""));
        root.appendChild(this.makeCharLine("Linija", '.', 32));
        root.appendChild(this.makeElelment("Linija", ""));
        root.appendChild(this.makeElelment("Linija", "Broj LK:"));
        root.appendChild(this.makeElelment("Linija", ""));
        root.appendChild(this.makeCharLine("Linija", '.', 32));
        root.appendChild(this.makeElelment("Linija", ""));
        root.appendChild(this.makeCharLine("Linija", '*', 32));
        this.contentMultiRow("Mesto i datum prometa dobara i usluga:", root);
        root.appendChild(this.makeElelment("Linija", "Beograd, " + this.sdfPrint.format(this.doc.getDate())));
        root.appendChild(this.makeCharLine("Linija", '*', 32));
    }

    private String contentInTheMiddle(String content) {
        int numOfChars = (32 - content.length()) / 2 + content.length() - 1;
        return String.format("-%" + numOfChars + "s", content);
    }

    private String contentAtTheEnd(String content) {
        return String.format("-%31s", content);
    }

    private String contentFinancial(String quantity, String price, String value) {
        String qp = "  " + quantity + " x " + price;
        int numOfChars = 32 - value.length() - 1;
        return String.format("%-" + numOfChars + "s", qp) + value;
    }

    private void contentMultiRow(String content, Element root) {
        while (content.length() != 0) {
            String row;
            if (content.length() > 32) {
                row = content.substring(0, 31) + "-";
                content = content.substring(31);
                root.appendChild(this.makeElelment("Linija", row));
                continue;
            }
            row = content;
            root.appendChild(this.makeElelment("Linija", row));
            content = "";
        }
    }

    private void sumVat(int vatId, double value) {
        Vat vat = Vat.getById(vatId, this.connection);
        switch (vat.getCode()) {
            case "GRUPA_DJ": {
                this.vat_Dj += Settings.round(value * vat.getValue3(), 2);
                break;
            }
            case "GRUPA_E": {
                this.vat_E += Settings.round(value * vat.getValue3(), 2);
                break;
            }
        }
    }

    private boolean isObjecyInVatSystem() {
        return this.controller.getObject().getObjectVatTypeID() == 1;
    }
}

