/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.product;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.product.Product;

public class QuickGroup {
    private long quickGroupId;
    private String name;
    private long productId;
    private long parentId;
    private Product product;
    private int brojArtikalaGrupe;

    public long getQuickGroupId() {
        return this.quickGroupId;
    }

    public void setQuickGroupId(long quickGroupId) {
        this.quickGroupId = quickGroupId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getProductId() {
        return this.productId;
    }

    public void setProductId(long productId) {
        this.productId = productId;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public int getBrojArtikalaGrupe() {
        return this.brojArtikalaGrupe;
    }

    public void setBrojArtikalaGrupe(int brojArtikalaGrupe) {
        this.brojArtikalaGrupe = brojArtikalaGrupe;
    }

    public static ObservableList<QuickGroup> getProductList(ScreensController controller, long parentID) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM quickgroup qg WHERE qg.ParentID = ? ORDER BY qg.QuickGroupID ASC";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, parentID);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                QuickGroup quickGroup = new QuickGroup();
                quickGroup.setQuickGroupId(rSet.getLong("QuickGroupID"));
                quickGroup.setName(rSet.getString("Name"));
                quickGroup.setProductId(rSet.getLong("ProductID"));
                quickGroup.setProduct(Product.getByID(rSet.getLong("ProductID"), controller));
                quickGroup.setParentId(rSet.getLong("ParentID"));
                list.add((Object)quickGroup);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<QuickGroup> getTableList(ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT qg.QuickGroupID, qg.Name, COALESCE((SELECT COUNT(*) FROM quickgroup qg1 WHERE qg1.ParentID = qg.QuickGroupID GROUP BY qg1.ParentID),0) AS ProductsNumber FROM quickgroup qg WHERE qg.ProductID IS NULL AND qg.ParentID IS NULL ORDER BY qg.QuickGroupID ASC";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                QuickGroup quickGroup = new QuickGroup();
                quickGroup.setQuickGroupId(rSet.getLong("QuickGroupID"));
                quickGroup.setName(rSet.getString("Name"));
                quickGroup.setBrojArtikalaGrupe(rSet.getInt("ProductsNumber"));
                list.add((Object)quickGroup);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<QuickGroup> getList(ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM quickgroup qg WHERE qg.QuickGroupID IN (SELECT qg.ParentID FROM quickgroup qg)";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                QuickGroup quickGroup = new QuickGroup();
                quickGroup.setQuickGroupId(rSet.getLong("QuickGroupID"));
                quickGroup.setName(rSet.getString("Name"));
                try {
                    quickGroup.setParentId(rSet.getLong("ParentID"));
                }
                catch (NullPointerException e) {
                    quickGroup.setParentId(-1L);
                }
                try {
                    quickGroup.setProductId(rSet.getLong("ProductID"));
                }
                catch (NullPointerException e) {
                    quickGroup.setProductId(-1L);
                }
                list.add((Object)quickGroup);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void insert(ScreensController controller) {
        String query = "INSERT INTO `" + controller.getSettings().getDatabase() + "`.`quickgroup` (`Name`) VALUES (?)";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.name);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void insertProduct(ScreensController controller) throws SQLException {
        String query = "INSERT INTO `" + controller.getSettings().getDatabase() + "`.`quickgroup` (`Name`, `ProductID`, `ParentID`) VALUES (?, ?, ?)";
        PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
        pStatement.setString(1, this.name);
        pStatement.setLong(2, this.productId);
        pStatement.setLong(3, this.parentId);
        pStatement.executeUpdate();
    }

    public void delete(ScreensController controller) {
        String query = "DELETE FROM `" + controller.getSettings().getDatabase() + "`.`quickgroup` WHERE  `QuickGroupID` = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, this.quickGroupId);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteProducts(ScreensController controller) {
        String query = "DELETE FROM `" + controller.getSettings().getDatabase() + "`.`quickgroup` WHERE  `ParentID` = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, this.quickGroupId);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

