/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.product;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;

public class ProductType {
    private int ProductTypeID;
    private String Name;
    private int Stock;
    private int PriceLeveling;
    private boolean Active;

    public int getProductTypeID() {
        return this.ProductTypeID;
    }

    public void setProductTypeID(int productTypeID) {
        this.ProductTypeID = productTypeID;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public int getStock() {
        return this.Stock;
    }

    public void setStock(int stock) {
        this.Stock = stock;
    }

    public int getPriceLeveling() {
        return this.PriceLeveling;
    }

    public void setPriceLeveling(int priceLeveling) {
        this.PriceLeveling = priceLeveling;
    }

    public boolean isActive() {
        return this.Active;
    }

    public void setActive(boolean active) {
        this.Active = active;
    }

    public String toString() {
        return this.Name;
    }

    public ObservableList<ProductType> getObeservableList(boolean activeOnly, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT DISTINCT * FROM productType";
        if (activeOnly) {
            query = query + " WHERE Active = TRUE  ORDER BY ProductTypeID";
        }
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ProductType pt = new ProductType();
                pt.ProductTypeID = rs.getInt("ProductTypeID");
                pt.Name = rs.getString("Name");
                pt.Stock = rs.getInt("Stock");
                pt.PriceLeveling = rs.getInt("PriceLeveling");
                pt.Active = rs.getBoolean("Active");
                list.add((Object)pt);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<ProductType> getList(Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM productType";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ProductType pt = new ProductType();
                pt.ProductTypeID = rs.getInt("ProductTypeID");
                pt.Name = rs.getString("Name");
                pt.Stock = rs.getInt("Stock");
                pt.PriceLeveling = rs.getInt("PriceLeveling");
                pt.Active = rs.getBoolean("Active");
                list.add((Object)pt);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ProductType getById(ScreensController controller, int productTypeId) {
        String query = "SELECT * FROM productType pt WHERE pt.ProductTypeID = ?";
        ProductType pt = new ProductType();
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setInt(1, productTypeId);
            ResultSet rs = ps.executeQuery();
            rs.next();
            pt.ProductTypeID = rs.getInt("ProductTypeID");
            pt.Name = rs.getString("Name");
            pt.Stock = rs.getInt("Stock");
            pt.PriceLeveling = rs.getInt("PriceLeveling");
            pt.Active = rs.getBoolean("Active");
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            return null;
        }
        return pt;
    }
}

