/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.product;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.controller.trgovina.Barcode;
import rs.petcom.master.dal.product.Product;

public class ProductGroupDetaile {
    private int ProductGroupDetailsID;
    private int ProductGroupID;
    private long ProductID;

    public int getProductGroupDetailsID() {
        return this.ProductGroupDetailsID;
    }

    public void setProductGroupDetailsID(int productGroupDetailsID) {
        this.ProductGroupDetailsID = productGroupDetailsID;
    }

    public int getProductGroupID() {
        return this.ProductGroupID;
    }

    public void setProductGroupID(int productGroupID) {
        this.ProductGroupID = productGroupID;
    }

    public long getProductID() {
        return this.ProductID;
    }

    public void setProductID(long productID) {
        this.ProductID = productID;
    }

    public static ObservableList<Product> getProductList(int productGroup, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select p.*   from productgroupdetails pg  left join product p on p.ProductID = pg.ProductID where pg.ProductGroupID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, productGroup);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Product product = new Product();
                product.setProductID(rs.getLong("ProductID"));
                product.setProductTypeID(rs.getInt("ProductTypeID"));
                product.setProductCategoryID(rs.getInt("ProductCategoryID"));
                product.setCode(rs.getString("Code"));
                product.setName(rs.getString("Name"));
                product.setShortName(rs.getString("ShortName"));
                product.setVatID(rs.getInt("VatID"));
                product.setUnitID(rs.getInt("UnitID"));
                product.setActive(rs.getBoolean("Active"));
                product.setSysDTCreated(new Date(rs.getDate("sysDTCreated").getTime()));
                try {
                    product.setSysDTEdit(new Date(rs.getDate("sysDTEdit").getTime()));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                try {
                    product.setBarcodeLast(Barcode.getBarCode(product.getProductID(), connection));
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                product.setSysUserAddID(rs.getLong("sysUserAddID"));
                product.setSysUserEditID(rs.getLong("sysUserEditID"));
                product.setNutritionalValue(rs.getDouble("NutritionalValue"));
                product.setEnergyValue(rs.getDouble("EnergyValue"));
                list.add((Object)product);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void insert(int productGroup, long productID, Connection connection) throws SQLException {
        String query = "INSERT INTO `productgroupdetails` (`ProductGroupID`, `ProductID`) VALUES (?, ?);";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setInt(1, productGroup);
        ps.setLong(2, productID);
        ps.executeUpdate();
        ps.close();
    }

    public static void delete(int productGroupDetailsID, Connection connection) {
        String query = "DELETE FROM `productgroupdetails` WHERE  `ProductGroupDetailsID`=?;";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, productGroupDetailsID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

