/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.product;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.controller.trgovina.Barcode;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Group;
import rs.petcom.master.dal.PointOfSale;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.product.AditionalFieldDetailsProduct;
import rs.petcom.master.dal.product.Product;

public class ProductDepartment {
    private long ProductDepartmentID;
    private long ProductID;
    private Product product;
    private int Sort;
    private boolean Active;
    private boolean Favorite;
    private long Min;
    private long Max;
    private int WarehouseID;
    private int PrinterID;
    private int DepartmentID;
    private int Position;
    private String Color;
    private int PointOfSaleID;
    private int KitchenDisplayID;
    private Time PreparationTime;
    private Department department;
    private double averageValue;
    private boolean enabled;
    private static final Logger LOGGER = Logger.getLogger("global");

    public long getProductDepartmentID() {
        return this.ProductDepartmentID;
    }

    public void setProductDepartmentID(long productDepartmentID) {
        this.ProductDepartmentID = productDepartmentID;
    }

    public long getProductID() {
        return this.ProductID;
    }

    public void setProductID(long productID) {
        this.ProductID = productID;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public int getSort() {
        return this.Sort;
    }

    public void setSort(int sort) {
        this.Sort = sort;
    }

    public boolean isActive() {
        return this.Active;
    }

    public void setActive(boolean active) {
        this.Active = active;
    }

    public boolean isFavorite() {
        return this.Favorite;
    }

    public void setFavorite(boolean favorite) {
        this.Favorite = favorite;
    }

    public long getMin() {
        return this.Min;
    }

    public void setMin(long min) {
        this.Min = min;
    }

    public long getMax() {
        return this.Max;
    }

    public void setMax(long max) {
        this.Max = max;
    }

    public int getWarehouseID() {
        return this.WarehouseID;
    }

    public void setWarehouseID(int warehouseID) {
        this.WarehouseID = warehouseID;
    }

    public int getPrinterID() {
        return this.PrinterID;
    }

    public void setPrinterID(int printerID) {
        this.PrinterID = printerID;
    }

    public int getDepartmentID() {
        return this.DepartmentID;
    }

    public void setDepartmentID(int departmentID) {
        this.DepartmentID = departmentID;
    }

    public int getPosition() {
        return this.Position;
    }

    public void setPosition(int position) {
        this.Position = position;
    }

    public String getColor() {
        return this.Color;
    }

    public void setColor(String color) {
        this.Color = color;
    }

    public int getPointOfSaleID() {
        return this.PointOfSaleID;
    }

    public void setPointOfSaleID(int pointOfSaleID) {
        this.PointOfSaleID = pointOfSaleID;
    }

    public int getKitchenDisplayID() {
        return this.KitchenDisplayID;
    }

    public void setKitchenDisplayID(int kitchenDisplayID) {
        this.KitchenDisplayID = kitchenDisplayID;
    }

    public Time getPreparationTime() {
        return this.PreparationTime;
    }

    public void setPreparationTime(Time preparationTime) {
        this.PreparationTime = preparationTime;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Department getDepartment() {
        return this.department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public double getAverageValue() {
        return this.averageValue;
    }

    public void setAverageValue(double averageValue) {
        this.averageValue = averageValue;
    }

    public long insert(Connection connection) throws SQLException {
        String query = "insert into productdepartment ( \tProductID, \tSort, \tActive, \tFavorite,\tMin,\tMax,\tWarehouseID,\tPrinterID,\tDepartmentID,    KitchenDisplayID) values (?,?,?,?,?,?,?,?,?,?)";
        PreparedStatement ps = connection.prepareStatement(query, 1);
        ps.setLong(1, this.ProductID);
        ps.setInt(2, this.Sort);
        ps.setBoolean(3, this.Active);
        ps.setBoolean(4, this.Favorite);
        ps.setLong(5, this.Min);
        ps.setLong(6, this.Max);
        if (this.WarehouseID != 0) {
            ps.setInt(7, this.WarehouseID);
        } else {
            ps.setNull(7, 4);
        }
        if (this.PrinterID != 0) {
            ps.setInt(8, this.PrinterID);
        } else {
            ps.setNull(8, 4);
        }
        ps.setInt(9, this.DepartmentID);
        if (this.KitchenDisplayID > 0) {
            ps.setInt(10, this.KitchenDisplayID);
        } else {
            ps.setNull(10, 4);
        }
        LOGGER.info(ps.toString());
        ps.executeUpdate();
        ResultSet rs = ps.getGeneratedKeys();
        rs.next();
        this.ProductDepartmentID = rs.getLong(1);
        ps.close();
        rs.close();
        return this.ProductDepartmentID;
    }

    public void delete(Connection connection) throws SQLException {
        String query = "delete from productdepartment where ProductDepartmentID = ? ";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setLong(1, this.ProductDepartmentID);
        ps.executeUpdate();
        ps.close();
    }

    public void deleteByDepartmentID(Connection connection) throws SQLException {
        String query = "delete from productdepartment where ProductID = ? and DepartmentID = ? ";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setLong(1, this.ProductID);
        ps.setInt(2, this.DepartmentID);
        ps.executeUpdate();
        ps.close();
    }

    public static ObservableList<ProductDepartment> getListX(String filter, boolean filterByAll, PointOfSale pos, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        Connection connection = controller.getSettings().getConnection();
        try {
            String filterAll = "'%" + filter + "%'";
            PreparedStatement ps = connection.prepareStatement("SELECT pd.*, b.BarCode, b.IsWeight FROM productdepartment pd LEFT JOIN pointofsaledepartment posd ON posd.DepartmentID = pd.DepartmentID LEFT JOIN barcode b on b.ProductID = pd.ProductID LEFT JOIN product p on p.ProductID = pd.ProductID WHERE posd.PointOfSaleID = ? AND p.Active IS TRUE " + (filterByAll ? " AND (p.Code LIKE " + filterAll + " OR p.Name LIKE " + filterAll + " OR b.BarCode LIKE " + filterAll + " or p.PLUcode LIKE " + filterAll + ") ORDER BY LENGTH(p.Code), p.Code LIMIT " + controller.getSettings().getBrojArtikalaZaUcitavanje() : " AND (b.BarCode = " + filter + " OR p.Code = " + filter + " OR p.PLUcode = " + filter + " ) ORDER BY LENGTH(p.Code), p.Code LIMIT 1"));
            ps.setLong(1, pos.getPointOfSaleID());
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ProductDepartment pd = new ProductDepartment();
                pd.ProductDepartmentID = rs.getLong("ProductDepartmentID");
                pd.ProductID = rs.getLong("ProductID");
                pd.Active = rs.getBoolean("Active");
                pd.DepartmentID = rs.getInt("DepartmentID");
                pd.averageValue = rs.getDouble("AverageValue");
                int indexExistedProduct = ProductDepartment.alreadyExist(pd.getProductID(), (ObservableList<ProductDepartment>)list);
                if (indexExistedProduct != -1) {
                    ((ProductDepartment)list.get(indexExistedProduct)).getProduct().setBarcode(((ProductDepartment)list.get(indexExistedProduct)).getProduct().getBarcode() + "-" + rs.getString("BarCode"));
                    continue;
                }
                pd.Sort = rs.getInt("Sort");
                pd.Favorite = rs.getBoolean("Favorite");
                pd.Min = rs.getLong("Min");
                pd.Max = rs.getLong("Max");
                pd.WarehouseID = rs.getInt("WarehouseID");
                pd.PrinterID = rs.getInt("PrinterID");
                pd.KitchenDisplayID = rs.getInt("KitchenDisplayID");
                pd.product = Product.getByIDWithPrice(pd.ProductID, connection);
                pd.product.setWeight(rs.getBoolean("isWeight"));
                if (controller.getSettings().isKolStanje()) {
                    System.out.println("I OVDE NE BI TREBALO DA UDJE AKO FALSE");
                    double stock = Product.getStockByProduct(pd.getProduct(), WorkDay.datumPocetnogStanja(Department.getByPOS(controller.getPointOfSale(), controller.getSettings().getConnection()).getDepartmentID(), new Date(), controller.getSettings().getConnection()), controller);
                    pd.getProduct().setStock(stock);
                }
                pd.product.setBarcodeLast(Barcode.getBarCode(pd.ProductID, connection));
                pd.product.setBarcode(rs.getString("BarCode"));
                if (AditionalFieldDetailsProduct.isEmtryList(controller, pd.product)) {
                    pd.product.setListAditionalFieldDetailsProduct(AditionalFieldDetailsProduct.getListByProductID(pd.product.getProductID(), controller.getSettings().getConnection()));
                }
                list.add((Object)pd);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<ProductDepartment> getNewList(String filter, boolean filterByAll, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        Connection connection = controller.getSettings().getConnection();
        try {
            String filterAll = "'" + filter + "%'";
            PreparedStatement ps = connection.prepareStatement("SELECT  p.*, bc.* FROM product p LEFT JOIN barcode bc on bc.ProductID = p.ProductID  WHERE p.Active IS TRUE" + (filterByAll ? " AND (p.Code LIKE " + filterAll + " OR p.Name LIKE '%" + filter + "%' OR bc.BarCode LIKE " + filterAll + " OR p.PLUcode LIKE " + filterAll + ") ORDER BY LENGTH(p.Code), p.Code LIMIT " + controller.getSettings().getBrojArtikalaZaUcitavanje() : " AND (bc.BarCode = '" + filter + "' OR p.Code = '" + filter + "' OR p.PLUcode = '" + filter + "' ) ORDER BY LENGTH(p.Code), p.Code LIMIT 1"));
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ProductDepartment pd = new ProductDepartment();
                int indexExistedProduct = ProductDepartment.alreadyExist(pd.getProductID(), (ObservableList<ProductDepartment>)list);
                if (indexExistedProduct != -1) {
                    ((ProductDepartment)list.get(indexExistedProduct)).getProduct().setBarcode(((ProductDepartment)list.get(indexExistedProduct)).getProduct().getBarcode() + "-" + rs.getString("BarCode"));
                    continue;
                }
                pd.product = Product.getByID(rs.getLong("ProductID"), controller);
                pd.setProductID(rs.getLong("ProductID"));
                pd.product.setWeight(rs.getBoolean("isWeight"));
                if (controller.getSettings().isKolStanje()) {
                    System.out.println("OVDE NE BI TREBALO DA UDJE AKO U SETAPU NIJE TRUE");
                    double stock = Product.getStockByProduct(pd.getProduct(), WorkDay.datumPocetnogStanja(Department.getByPOS(controller.getPointOfSale(), controller.getSettings().getConnection()).getDepartmentID(), new Date(), controller.getSettings().getConnection()), controller);
                    pd.getProduct().setStock(stock);
                }
                pd.product.setBarcodeLast(Barcode.getBarCode(pd.getProduct().getProductID(), connection));
                pd.product.setBarcode(rs.getString("BarCode"));
                if (AditionalFieldDetailsProduct.isEmtryList(controller, pd.product)) {
                    pd.product.setListAditionalFieldDetailsProduct(AditionalFieldDetailsProduct.getListByProductID(pd.product.getProductID(), controller.getSettings().getConnection()));
                }
                list.add((Object)pd);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<ProductDepartment> getNewFilteredList(String departmentIDS, String pointOfSaleIDS, String productTypeIDS, String productCategoryIDS, String aditionalFieldIDS, String aditionalFieldDetailsIDS, String vatIDS, boolean active, String popustDozvoljen, String merljiv, String tezinski, ScreensController controller) {
        String query = "SELECT pd.*, p.*, current_price_before_date(p.ProductID, NOW(), pd.DepartmentID) AS Price \r\nFROM productdepartment pd\r\nRIGHT JOIN product p ON p.ProductID = pd.ProductID\r\nLEFT JOIN pointofsaledepartment posd ON posd.DepartmentID = pd.DepartmentID\r\nLEFT JOIN aditionalfielddetailsproduct afdp ON afdp.ProductID = pd.ProductID\r\nWHERE ('-1' = '" + departmentIDS + "' OR FIND_IN_SET(posd.DepartmentID, '" + departmentIDS + "'))\r\nAND ('-1' = '" + pointOfSaleIDS + "' OR FIND_IN_SET(posd.PointOfSaleID, '" + pointOfSaleIDS + "'))\r\nAND ('-1' = '" + productTypeIDS + "' OR FIND_IN_SET(p.ProductTypeID, '" + productTypeIDS + "'))\r\nAND ('-1' = '" + vatIDS + "' OR FIND_IN_SET(p.VatID, '" + vatIDS + "')) AND ('-1' = '" + productCategoryIDS + "' OR FIND_IN_SET(p.ProductCategoryID, '" + productCategoryIDS + "'))\r\n AND ('-1' = '" + aditionalFieldIDS + "' OR FIND_IN_SET(afdp.AditionalFieldID, '" + aditionalFieldIDS + "'))\r\n AND ('-1' = '" + aditionalFieldDetailsIDS + "' OR FIND_IN_SET(afdp.AditionalFieldDetailsID, '" + aditionalFieldDetailsIDS + "')) AND ('-1' = '" + tezinski + "' OR p.ProductID IN (SELECT bc.ProductID FROM barcode bc WHERE bc.IsWeight = " + tezinski + "))\r\nAND ('-1' = '" + merljiv + "' OR p.Measurable = " + merljiv + ")\r\n AND ('-1' = '" + popustDozvoljen + "' OR p.DiscountAllowed = " + popustDozvoljen + ")AND p.Active IS " + active + " GROUP BY p.ProductID ORDER BY LENGTH(p.Code), p.Code";
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ProductDepartment pd = ProductDepartment.get(rs.getLong("ProductDepartmentID"), controller);
                int indexExistedProduct = ProductDepartment.alreadyExist(pd.getProductID(), (ObservableList<ProductDepartment>)list);
                if (indexExistedProduct != -1) {
                    ((ProductDepartment)list.get(indexExistedProduct)).getProduct().setBarcode(((ProductDepartment)list.get(indexExistedProduct)).getProduct().getBarcode() + "-" + rs.getString("BarCode"));
                    continue;
                }
                pd.product = Product.getByID(rs.getLong("ProductID"), controller);
                pd.setProductID(rs.getLong("ProductID"));
                pd.product.setBarcodeObject(Barcode.getBarCodeObject(pd.getProductID(), controller.getSettings().getConnection()));
                pd.product.setBarcode(pd.product.getBarcodeObject() != null ? pd.product.getBarcodeObject().getBarCode() : "");
                pd.product.setBarcodeLast(pd.product.getBarcodeObject() != null ? pd.product.getBarcodeObject().getBarCode() : "");
                pd.product.setWeight(pd.product.getBarcodeObject() != null ? pd.getProduct().getBarcodeObject().getIsWeight() : false);
                if (controller.getSettings().isKolStanje()) {
                    System.out.println("OVDE NE BI TREBALO DA UDJE AKO U SETAPU NIJE TRUE");
                    double stock = Product.getStockByProduct(pd.getProduct(), WorkDay.datumPocetnogStanja(Department.getByPOS(controller.getPointOfSale(), controller.getSettings().getConnection()).getDepartmentID(), new Date(), controller.getSettings().getConnection()), controller);
                    pd.getProduct().setStock(stock);
                }
                pd.product.setBarcodeLast(Barcode.getBarCode(pd.getProduct().getProductID(), controller.getSettings().getConnection()));
                if (AditionalFieldDetailsProduct.isEmtryList(controller, pd.product)) {
                    pd.product.setListAditionalFieldDetailsProduct(AditionalFieldDetailsProduct.getListByProductID(pd.product.getProductID(), controller.getSettings().getConnection()));
                }
                list.add((Object)pd);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList<ProductDepartment> getList(PointOfSale pos, int groupId, ScreensController controller) {
        ArrayList<ProductDepartment> list = new ArrayList<ProductDepartment>();
        String query = "select pd.*,gpp.Position,gpp.Color,gpp.PointOfSaleID   from grouppointofsaleproduct gpp  left join productdepartment pd on pd.ProductDepartmentID = gpp.ProductDepartmentID where gpp.PointOfSaleID = ? and GroupID = ?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setLong(1, pos.getPointOfSaleID());
            ps.setInt(2, groupId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ProductDepartment pd = new ProductDepartment();
                pd.ProductDepartmentID = rs.getLong("ProductDepartmentID");
                pd.ProductID = rs.getLong("ProductID");
                pd.Sort = rs.getInt("Sort");
                pd.Active = rs.getBoolean("Active");
                pd.Favorite = rs.getBoolean("Favorite");
                pd.Min = rs.getLong("Min");
                pd.Max = rs.getLong("Max");
                pd.WarehouseID = rs.getInt("WarehouseID");
                pd.PrinterID = rs.getInt("PrinterID");
                pd.DepartmentID = rs.getInt("DepartmentID");
                pd.Position = rs.getInt("Position");
                pd.Color = rs.getString("Color");
                pd.PointOfSaleID = rs.getInt("PointOfSaleID");
                pd.KitchenDisplayID = rs.getInt("KitchenDisplayID");
                pd.averageValue = rs.getDouble("AverageValue");
                pd.product = Product.getByID(pd.ProductID, controller);
                list.add(pd);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public ArrayList<ProductDepartment> getAdditionalList(PointOfSale pos, Group group, ScreensController controller) {
        ArrayList<ProductDepartment> list = new ArrayList<ProductDepartment>();
        String query = "select pd1.*, gpp.color   from productdepartment pd  inner join productaditional pa on pa.ParentProductID = pd.ProductID  inner join productdepartment pd1 on pd1.ProductID = pa.ChildProductID and pd1.DepartmentID = ?  left join grouppointofsaleproduct gpp on gpp.ProductDepartmentID = pd.ProductDepartmentID \t\t\t\t\t\t\t\t\t\tand gpp.GroupID = ? \t\t\t\t\t\t\t\t\t\tand gpp.PointOfSaleID = ? where pd.DepartmentID = ?   and pd.ProductID = ? order by Sort";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setInt(1, this.DepartmentID);
            ps.setInt(2, group.getGroupID());
            ps.setInt(3, pos.getPointOfSaleID());
            ps.setInt(4, this.DepartmentID);
            ps.setLong(5, this.ProductID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ProductDepartment pd = new ProductDepartment();
                pd.ProductDepartmentID = rs.getLong("ProductDepartmentID");
                pd.ProductID = rs.getLong("ProductID");
                pd.Sort = rs.getInt("Sort");
                pd.Active = rs.getBoolean("Active");
                pd.Favorite = rs.getBoolean("Favorite");
                pd.Min = rs.getLong("Min");
                pd.Max = rs.getLong("Max");
                pd.WarehouseID = rs.getInt("WarehouseID");
                pd.PrinterID = rs.getInt("PrinterID");
                pd.DepartmentID = rs.getInt("DepartmentID");
                pd.KitchenDisplayID = rs.getInt("KitchenDisplayID");
                pd.averageValue = rs.getDouble("AverageValue");
                pd.product = Product.getByID(pd.ProductID, controller);
                list.add(pd);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void updateKitchenMonitor(long productID, long productdepartmentID, Connection connection) {
        String query = "UPDATE productdepartment SET  KitchenDisplayID = ?,  PreparationTime = ? WHERE ProductID = ? AND ProductDepartmentID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            if (this.KitchenDisplayID == -1) {
                ps.setString(1, null);
            } else {
                ps.setInt(1, this.KitchenDisplayID);
            }
            ps.setTime(2, this.PreparationTime);
            ps.setLong(3, productID);
            ps.setLong(4, productdepartmentID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<ProductDepartment> getProductAditional(long productId, int departmentID, PointOfSale pos, ScreensController controller) {
        ArrayList<ProductDepartment> productAddiotnals = new ArrayList<ProductDepartment>();
        String query = "select distinct pd1.*, p.*  from productdepartment pd  inner join productaditional pa on pa.ParentProductID = pd.ProductID  inner join productdepartment pd1 on pd1.ProductID = pa.ChildProductID and pd1.DepartmentID = ?  left join grouppointofsaleproduct gpp on gpp.ProductDepartmentID = pd.ProductDepartmentID \t\t\t\t\t\t\t\t\t\tand gpp.PointOfSaleID = ?  join product p on p.ProductID = pa.ChildProductID where pd.DepartmentID = ?   and pd.ProductID = ? order by Sort";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setInt(1, departmentID);
            ps.setInt(2, pos.getPointOfSaleID());
            ps.setInt(3, departmentID);
            ps.setLong(4, productId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ProductDepartment pd = new ProductDepartment();
                pd.ProductDepartmentID = rs.getLong("ProductDepartmentID");
                pd.ProductID = rs.getLong("ProductID");
                pd.Sort = rs.getInt("Sort");
                pd.Active = rs.getBoolean("Active");
                pd.Favorite = rs.getBoolean("Favorite");
                pd.Min = rs.getLong("Min");
                pd.Max = rs.getLong("Max");
                pd.WarehouseID = rs.getInt("WarehouseID");
                pd.PrinterID = rs.getInt("PrinterID");
                pd.DepartmentID = rs.getInt("DepartmentID");
                pd.KitchenDisplayID = rs.getInt("KitchenDisplayID");
                pd.averageValue = rs.getDouble("AverageValue");
                pd.product = Product.getByID(pd.ProductID, controller);
                productAddiotnals.add(pd);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return productAddiotnals;
    }

    public ArrayList<ProductDepartment> getAdditionalListPositionAndColor(PointOfSale pos, Group group, ScreensController controller) {
        ArrayList<ProductDepartment> list = new ArrayList<ProductDepartment>();
        String query = "select distinct pd1.*, pad.BtnPosition, pad.Color  from productdepartment pd  inner join productaditional pa on pa.ParentProductID = pd.ProductID  inner join productdepartment pd1 on pd1.ProductID = pa.ChildProductID and pd1.DepartmentID = ?  left join grouppointofsaleproduct gpp on gpp.ProductDepartmentID = pd.ProductDepartmentID \t\t\t\t\t\t\t\t\t\tand gpp.GroupID = ? \t\t\t\t\t\t\t\t\t\tand gpp.PointOfSaleID = ? inner join productaditionaldepartmentposition pad on pad.ProductAditionalID = pa.ProductAditionalID \t\t\t\t\t\t\t\t\t\tand pad.ProductDepartmentID = pd1.ProductDepartmentID where pd.DepartmentID = ?   and pd.ProductID = ? order by Sort";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setInt(1, this.DepartmentID);
            ps.setInt(2, group.getGroupID());
            ps.setInt(3, pos.getPointOfSaleID());
            ps.setInt(4, this.DepartmentID);
            ps.setLong(5, this.ProductID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ProductDepartment pd = new ProductDepartment();
                pd.ProductDepartmentID = rs.getLong("ProductDepartmentID");
                pd.ProductID = rs.getLong("ProductID");
                pd.Active = rs.getBoolean("Active");
                pd.Favorite = rs.getBoolean("Favorite");
                pd.Min = rs.getLong("Min");
                pd.Max = rs.getLong("Max");
                pd.WarehouseID = rs.getInt("WarehouseID");
                pd.PrinterID = rs.getInt("PrinterID");
                pd.DepartmentID = rs.getInt("DepartmentID");
                Integer integer = (Integer)rs.getObject("BtnPosition");
                pd.Position = integer != null ? rs.getInt("BtnPosition") : -1;
                pd.Color = rs.getString("Color");
                pd.KitchenDisplayID = rs.getInt("KitchenDisplayID");
                pd.averageValue = rs.getDouble("AverageValue");
                pd.product = Product.getByID(pd.ProductID, controller);
                list.add(pd);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void updateSort(Connection connection) {
        String query = "UPDATE productdepartment pd SET pd.Sort = ? WHERE pd.ProductID = ? and pd.DepartmentID = ?;";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, this.getSort());
            ps.setLong(2, this.getProductID());
            ps.setInt(3, this.getDepartmentID());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateAction(Connection connection) {
        String query = "UPDATE productdepartment pd SET pd.Active = ? WHERE pd.ProductID = ? and pd.DepartmentID = ?;";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setBoolean(1, this.isActive());
            ps.setLong(2, this.getProductID());
            ps.setInt(3, this.getDepartmentID());
            System.out.println(ps);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updateAverageValue(ScreensController controller) {
        String query = "UPDATE productdepartment pd SET pd.AverageValue = ? WHERE pd.ProductID = ? and pd.DepartmentID = ?;";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setDouble(1, this.getAverageValue());
            ps.setLong(2, this.getProductID());
            ps.setInt(3, this.getDepartmentID());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void updatePositionColor(long parentID, Connection connection) {
        String query = "UPDATE productaditionaldepartmentposition pad join productdepartment pd on pd.ProductDepartmentID = pad.ProductDepartmentID and pd.DepartmentID = ? join productaditional pa on pad.ProductAditionalID = pa.ProductAditionalID SET pad.BtnPosition=?, pad.Color=? WHERE pa.ParentProductID=? and pa.ChildProductID=?;";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, this.getDepartmentID());
            ps.setLong(2, this.getPosition());
            ps.setString(3, this.getColor());
            ps.setLong(4, parentID);
            ps.setLong(5, this.getProductID());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<ProductDepartment> getAdditionalListPositionAndColor(long productId, int departmentID, PointOfSale pos, ScreensController controller) {
        ArrayList<ProductDepartment> productAddiotnals = new ArrayList<ProductDepartment>();
        String query = "select distinct pd1.*, pa.ProductAditionalID, pad.BtnPosition, pad.Color  from productdepartment pd  inner join productaditional pa on pa.ParentProductID = pd.ProductID  inner join productdepartment pd1 on pd1.ProductID = pa.ChildProductID and pd1.DepartmentID = ?  left join grouppointofsaleproduct gpp on gpp.ProductDepartmentID = pd.ProductDepartmentID \t\t\t\t\t\t\t\t\t\tand gpp.PointOfSaleID = ? inner join productaditionaldepartmentposition pad on pad.ProductAditionalID = pa.ProductAditionalID \t\t\t\t\t\t\t\t\t\tand pad.ProductDepartmentID = pd1.ProductDepartmentID where pd.DepartmentID = ? and pd.ProductID = ? order by pad.BtnPosition";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setInt(1, departmentID);
            ps.setInt(2, pos.getPointOfSaleID());
            ps.setInt(3, departmentID);
            ps.setLong(4, productId);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ProductDepartment pd = new ProductDepartment();
                pd.ProductDepartmentID = rs.getLong("ProductDepartmentID");
                pd.ProductID = rs.getLong("ProductID");
                pd.Active = rs.getBoolean("Active");
                pd.Favorite = rs.getBoolean("Favorite");
                pd.Min = rs.getLong("Min");
                pd.Max = rs.getLong("Max");
                pd.WarehouseID = rs.getInt("WarehouseID");
                pd.PrinterID = rs.getInt("PrinterID");
                pd.DepartmentID = rs.getInt("DepartmentID");
                Integer integer = (Integer)rs.getObject("BtnPosition");
                pd.Position = integer != null ? rs.getInt("BtnPosition") : -1;
                String colorCode = rs.getString("Color");
                try {
                    if (!colorCode.equals("null")) {
                        pd.Color = colorCode;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                pd.KitchenDisplayID = rs.getInt("KitchenDisplayID");
                pd.averageValue = rs.getDouble("AverageValue");
                pd.product = Product.getByID(pd.ProductID, controller);
                pd.product.setProductAditionalID(rs.getLong("ProductAditionalID"));
                pd.product.setProductDepartmentID(rs.getLong("ProductDepartmentID"));
                productAddiotnals.add(pd);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return productAddiotnals;
    }

    public static ProductDepartment getAditionalChildPosition(long productID, int departmenID, ScreensController controller) {
        String query = "select distinct pd1.*, p.*  from productdepartment pd  inner join productaditional pa on pa.ChildProductID = pd.ProductID  inner join productdepartment pd1 on pd1.ProductID = pa.ChildProductID and pd1.DepartmentID = ?  left join grouppointofsaleproduct gpp on gpp.ProductDepartmentID = pd.ProductDepartmentID   join product p on p.ProductID = pa.ChildProductID where pd.DepartmentID = ?   and pd.ProductID = ? order by Sort";
        ProductDepartment pd = null;
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setInt(1, departmenID);
            ps.setInt(2, departmenID);
            ps.setLong(3, productID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                pd = new ProductDepartment();
                pd.ProductDepartmentID = rs.getLong("ProductDepartmentID");
                pd.ProductID = rs.getLong("ProductID");
                pd.Sort = rs.getInt("Sort");
                pd.Active = rs.getBoolean("Active");
                pd.Favorite = rs.getBoolean("Favorite");
                pd.Min = rs.getLong("Min");
                pd.Max = rs.getLong("Max");
                pd.WarehouseID = rs.getInt("WarehouseID");
                pd.PrinterID = rs.getInt("PrinterID");
                pd.DepartmentID = rs.getInt("DepartmentID");
                pd.KitchenDisplayID = rs.getInt("KitchenDisplayID");
                pd.averageValue = rs.getDouble("AverageValue");
                pd.product = Product.getByID(pd.ProductID, controller);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return pd;
    }

    public static ObservableList<ProductDepartment> getList(Department department, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select pd.*, b.BarCode from productdepartment pd JOIN barcode b on b.ProductID = pd.ProductID where DepartmentID = ? limit 100";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, department.getDepartmentID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ProductDepartment pd = new ProductDepartment();
                pd.ProductDepartmentID = rs.getLong("ProductDepartmentID");
                pd.ProductID = rs.getLong("ProductID");
                pd.Sort = rs.getInt("Sort");
                pd.Active = rs.getBoolean("Active");
                pd.Favorite = rs.getBoolean("Favorite");
                pd.Min = rs.getLong("Min");
                pd.Max = rs.getLong("Max");
                pd.WarehouseID = rs.getInt("WarehouseID");
                pd.PrinterID = rs.getInt("PrinterID");
                pd.DepartmentID = rs.getInt("DepartmentID");
                pd.KitchenDisplayID = rs.getInt("KitchenDisplayID");
                pd.averageValue = rs.getDouble("AverageValue");
                pd.product = Product.getByIDWithPrice(pd.getProductID(), connection);
                pd.product.setBarcode(rs.getString("BarCode"));
                int index = ProductDepartment.alreadyExist(pd.getProductID(), (ObservableList<ProductDepartment>)list);
                if (index != -1) {
                    ((ProductDepartment)list.get(index)).getProduct().setBarcode(((ProductDepartment)list.get(index)).getProduct().getBarcode() + "-" + rs.getString("BarCode"));
                    continue;
                }
                list.add((Object)pd);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<ProductDepartment> getListByProductId(Product product, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select pd.* from productdepartment pd where ProductID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, product.getProductID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                ProductDepartment pd = new ProductDepartment();
                pd.ProductDepartmentID = rs.getLong("ProductDepartmentID");
                pd.ProductID = rs.getLong("ProductID");
                pd.Sort = rs.getInt("Sort");
                pd.Active = rs.getBoolean("Active");
                pd.Favorite = rs.getBoolean("Favorite");
                pd.Min = rs.getLong("Min");
                pd.Max = rs.getLong("Max");
                pd.WarehouseID = rs.getInt("WarehouseID");
                pd.PrinterID = rs.getInt("PrinterID");
                pd.DepartmentID = rs.getInt("DepartmentID");
                pd.KitchenDisplayID = rs.getInt("KitchenDisplayID");
                pd.averageValue = rs.getDouble("AverageValue");
                pd.setDepartment(Department.getById(pd.getDepartmentID(), connection));
                list.add((Object)pd);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ProductDepartment getFromDB(long productId, long departmentId, ScreensController controller) throws SQLException {
        String query = "select * from productdepartment where ProductID = ?  and DepartmentID = ?";
        PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
        ps.setLong(1, productId);
        ps.setLong(2, departmentId);
        ResultSet rs = ps.executeQuery();
        rs.next();
        ProductDepartment pd = new ProductDepartment();
        pd.ProductDepartmentID = rs.getLong("ProductDepartmentID");
        pd.ProductID = rs.getLong("ProductID");
        pd.Sort = rs.getInt("Sort");
        pd.Active = rs.getBoolean("Active");
        pd.Favorite = rs.getBoolean("Favorite");
        pd.Min = rs.getLong("Min");
        pd.Max = rs.getLong("Max");
        pd.WarehouseID = rs.getInt("WarehouseID");
        pd.PrinterID = rs.getInt("PrinterID");
        pd.DepartmentID = rs.getInt("DepartmentID");
        pd.KitchenDisplayID = rs.getInt("KitchenDisplayID");
        pd.averageValue = rs.getDouble("AverageValue");
        pd.product = Product.getByID(pd.ProductID, controller);
        ps.close();
        rs.close();
        return pd;
    }

    public static ProductDepartment get(long productDepartmentID, ScreensController controller) {
        String query = "select * from productdepartment where ProductDepartmentID = ?";
        ProductDepartment pd = new ProductDepartment();
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setLong(1, productDepartmentID);
            ResultSet rs = ps.executeQuery();
            rs.next();
            pd.ProductDepartmentID = rs.getLong("ProductDepartmentID");
            pd.ProductID = rs.getLong("ProductID");
            pd.Sort = rs.getInt("Sort");
            pd.Active = rs.getBoolean("Active");
            pd.Favorite = rs.getBoolean("Favorite");
            pd.Min = rs.getLong("Min");
            pd.Max = rs.getLong("Max");
            pd.WarehouseID = rs.getInt("WarehouseID");
            pd.PrinterID = rs.getInt("PrinterID");
            pd.DepartmentID = rs.getInt("DepartmentID");
            pd.KitchenDisplayID = rs.getInt("KitchenDisplayID");
            pd.averageValue = rs.getDouble("AverageValue");
            pd.product = Product.getByID(pd.ProductID, controller);
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return pd;
    }

    public static ProductDepartment getByProductAndDepartment(long productId, int departmentID, ScreensController controller) {
        String query = "select * from productdepartment where ProductID = ? AND DepartmentID = ?";
        ProductDepartment pd = new ProductDepartment();
        PreparedStatement ps = null;
        try {
            ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setLong(1, productId);
            ps.setInt(2, departmentID);
            ResultSet rs = ps.executeQuery();
            rs.next();
            pd.ProductDepartmentID = rs.getLong("ProductDepartmentID");
            pd.ProductID = rs.getLong("ProductID");
            pd.Sort = rs.getInt("Sort");
            pd.Active = rs.getBoolean("Active");
            pd.Favorite = rs.getBoolean("Favorite");
            pd.Min = rs.getLong("Min");
            pd.Max = rs.getLong("Max");
            pd.WarehouseID = rs.getInt("WarehouseID");
            pd.PrinterID = rs.getInt("PrinterID");
            pd.DepartmentID = rs.getInt("DepartmentID");
            pd.KitchenDisplayID = rs.getInt("KitchenDisplayID");
            pd.averageValue = rs.getDouble("AverageValue");
            pd.product = Product.getByID(pd.ProductID, controller);
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            return null;
        }
        return pd;
    }

    public static ProductDepartment getByProductAndDepartment(long productId, int departmentID, Connection connection) {
        String query = "select * from productdepartment where ProductID = ? AND DepartmentID = ?";
        ProductDepartment pd = new ProductDepartment();
        PreparedStatement ps = null;
        try {
            ps = connection.prepareStatement(query);
            ps.setLong(1, productId);
            ps.setInt(2, departmentID);
            ResultSet rs = ps.executeQuery();
            rs.next();
            pd.ProductDepartmentID = rs.getLong("ProductDepartmentID");
            pd.ProductID = rs.getLong("ProductID");
            pd.Sort = rs.getInt("Sort");
            pd.Active = rs.getBoolean("Active");
            pd.Favorite = rs.getBoolean("Favorite");
            pd.Min = rs.getLong("Min");
            pd.Max = rs.getLong("Max");
            pd.WarehouseID = rs.getInt("WarehouseID");
            pd.PrinterID = rs.getInt("PrinterID");
            pd.DepartmentID = rs.getInt("DepartmentID");
            pd.KitchenDisplayID = rs.getInt("KitchenDisplayID");
            pd.averageValue = rs.getDouble("AverageValue");
            pd.product = Product.getByID(pd.ProductID, departmentID, connection);
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        return pd;
    }

    public static int alreadyExist(long productID, ObservableList<ProductDepartment> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (((ProductDepartment)list.get(i)).getProduct().getProductID() != productID) continue;
            return i;
        }
        return -1;
    }
}

