/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.product;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Group;

public class GroupProduct {
    private long groupProductID;
    private int groupID;
    private long productID;
    private boolean active;
    private String color;

    public long getGroupProductID() {
        return this.groupProductID;
    }

    public void setGroupProductID(long groupProductID) {
        this.groupProductID = groupProductID;
    }

    public int getGroupID() {
        return this.groupID;
    }

    public void setGroupID(int groupID) {
        this.groupID = groupID;
    }

    public long getProductID() {
        return this.productID;
    }

    public void setProductID(long productID) {
        this.productID = productID;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public static ObservableList<GroupProduct> getProductListByGroup(Group group, ScreensController controller) {
        String query = "SELECT * FROM groupproduct gp WHERE gp.GroupID = ?";
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setInt(1, group.getGroupID());
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                GroupProduct groupProduct = new GroupProduct();
                groupProduct.setGroupID(rSet.getInt("GroupID"));
                groupProduct.setGroupProductID(rSet.getInt("GroupProductID"));
                groupProduct.setProductID(rSet.getLong("ProductID"));
                groupProduct.setActive(rSet.getBoolean("Active"));
                groupProduct.setColor(rSet.getString("Color"));
                list.add((Object)groupProduct);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<GroupProduct> getGroupProductListByGroup(Group group, ScreensController controller) {
        String query = "SELECT * FROM groupproduct gp WHERE gp.GroupID = ?";
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setInt(1, group.getGroupID());
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                GroupProduct groupProduct = new GroupProduct();
                groupProduct.setGroupID(rSet.getInt("GroupID"));
                groupProduct.setGroupProductID(rSet.getInt("GroupProductID"));
                groupProduct.setProductID(rSet.getLong("ProductID"));
                groupProduct.setActive(rSet.getBoolean("Active"));
                groupProduct.setColor(rSet.getString("Color"));
                list.add((Object)groupProduct);
            }
        }
        catch (SQLException e) {
            return null;
        }
        return list;
    }

    public void insert(ScreensController controller) {
        String query = "INSERT INTO `masterdb`.`groupproduct` (`GroupID`, `ProductID`, `Active`, `Color`) VALUES (?, ?, ?, ?);";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setInt(1, this.groupID);
            pStatement.setLong(2, this.productID);
            pStatement.setBoolean(3, this.active);
            pStatement.setString(4, this.color);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void update(ScreensController controller) {
        String query = "UPDATE `masterdb`.`groupproduct` SET `GroupID` = ?, `ProductID` = ?, `Active` = ?, `Color` = ? WHERE  `GroupProductID` = ?;";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setInt(1, this.groupID);
            pStatement.setLong(2, this.productID);
            pStatement.setBoolean(3, this.active);
            pStatement.setString(4, this.color);
            pStatement.setLong(5, this.groupProductID);
            pStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

