/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.product;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;

public class Description {
    private int DescriptionID;
    private String Name;
    boolean Active;
    private Date sysDTCreated;
    private Date sysDTEdit;
    private long sysUserAddID;
    private long sysUserEditID;
    private String color;
    private Connection connection;

    public int getDescriptionID() {
        return this.DescriptionID;
    }

    public void setDescriptionID(int descriptionID) {
        this.DescriptionID = descriptionID;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public boolean isActive() {
        return this.Active;
    }

    public void setActive(boolean active) {
        this.Active = active;
    }

    public Date getSysDTCreated() {
        return this.sysDTCreated;
    }

    public void setSysDTCreated(Date sysDTCreated) {
        this.sysDTCreated = sysDTCreated;
    }

    public Date getSysDTEdit() {
        return this.sysDTEdit;
    }

    public void setSysDTEdit(Date sysDTEdit) {
        this.sysDTEdit = sysDTEdit;
    }

    public long getSysUserAddID() {
        return this.sysUserAddID;
    }

    public void setSysUserAddID(long sysUserAddID) {
        this.sysUserAddID = sysUserAddID;
    }

    public long getSysUserEditID() {
        return this.sysUserEditID;
    }

    public void setSysUserEditID(long sysUserEditID) {
        this.sysUserEditID = sysUserEditID;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public Description() {
    }

    public Description(String description, ScreensController controller) {
        this.Name = description;
        this.sysUserAddID = controller.getUser().getUserID();
        this.sysUserEditID = controller.getUser().getUserID();
        this.connection = controller.getSettings().getConnection();
    }

    public static ObservableList<Description> getObeservableList(String filter, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select * from description d where d.Name like ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setString(1, "%" + filter + "%");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Description description = new Description();
                description.Active = rs.getBoolean("Active");
                description.DescriptionID = rs.getInt("DescriptionId");
                description.Name = rs.getString("Name");
                description.sysDTCreated = rs.getDate("sysDTCreated");
                description.sysDTEdit = rs.getDate("sysDTEdit");
                description.sysUserAddID = rs.getLong("sysUserAddID");
                description.sysUserEditID = rs.getLong("sysUserEditID");
                list.add((Object)description);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public int insertDescriptionIntoDB() {
        String query = "INSERT INTO  description (NAME, Active, sysDTCreated, sysDTEdit, sysUserAddID, sysUserEditID)\r\nVALUES (?,1,NOW(),NOW(),?,?)";
        try {
            this.connection.setAutoCommit(false);
            PreparedStatement ps = this.connection.prepareStatement(query, 1);
            ps.setString(1, this.Name);
            ps.setLong(2, this.sysUserAddID);
            ps.setLong(3, this.sysUserEditID);
            ps.executeUpdate();
            this.connection.commit();
            this.connection.setAutoCommit(true);
            ResultSet rs = ps.getGeneratedKeys();
            if (rs.next()) {
                int id = rs.getInt(1);
                ps.close();
                return id;
            }
            ps.close();
            return -1;
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
            return -1;
        }
    }
}

