/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.product;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.product.AditionalFieldDetails;
import rs.petcom.master.dal.product.Product;

public class AditionalFieldDetailsProduct {
    private long AditionalFieldDetailsProductID;
    private long ProductID;
    private long AditionalFieldDetailsID;
    private long AditionalFieldID;
    private AditionalFieldDetails aditionalFieldDetails;

    public void setAditionalFieldID(long aditionalFieldID) {
        this.AditionalFieldID = aditionalFieldID;
    }

    public long getAditionalFieldID() {
        return this.AditionalFieldID;
    }

    public void setAditionalFieldDetailsID(long aditionalFieldDetailsID) {
        this.AditionalFieldDetailsID = aditionalFieldDetailsID;
    }

    public long getAditionalFieldDetailsID() {
        return this.AditionalFieldDetailsID;
    }

    public long getAditionalFieldDetailsProductID() {
        return this.AditionalFieldDetailsProductID;
    }

    public void setAditionalFieldDetailsProductID(long aditionalFieldDetailsProductID) {
        this.AditionalFieldDetailsProductID = aditionalFieldDetailsProductID;
    }

    public long getProductID() {
        return this.ProductID;
    }

    public void setProductID(long productID) {
        this.ProductID = productID;
    }

    public AditionalFieldDetails getAditionalFieldDetails() {
        return this.aditionalFieldDetails;
    }

    public void setAditionalFieldDetails(AditionalFieldDetails aditionalFieldDetails) {
        this.aditionalFieldDetails = aditionalFieldDetails;
    }

    public static ObservableList<AditionalFieldDetailsProduct> getListByProductID(long productID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select afdp.* from aditionalfielddetailsproduct afdp where afdp.ProductID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, productID);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                AditionalFieldDetailsProduct afp = new AditionalFieldDetailsProduct();
                afp.setAditionalFieldDetailsProductID(rs.getLong("AditionalFieldDetailsProductID"));
                afp.setProductID(rs.getLong("ProductID"));
                afp.setAditionalFieldDetailsID(rs.getLong("AditionalFieldDetailsID"));
                afp.setAditionalFieldID(rs.getLong("AditionalFieldID"));
                afp.setAditionalFieldDetails(AditionalFieldDetails.getByID(rs.getLong("AditionalFieldDetailsID"), connection));
                list.add((Object)afp);
            }
            rs.close();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static boolean isEmtryList(ScreensController controller, Product product) {
        boolean next = false;
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement("SELECT * FROM aditionalfielddetailsproduct afdp where afdp.ProductID = ? LIMIT 1");
            pStatement.setLong(1, product.getProductID());
            ResultSet rSet = pStatement.executeQuery();
            if (rSet.next()) {
                next = true;
            }
            rSet.next();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return next;
    }

    public void update(Connection connection) {
        String query = "UPDATE aditionalfielddetailsproduct afp SET afp.AditionalFieldDetailsID = ? WHERE afp.AditionalFieldDetailsProductID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, this.AditionalFieldDetailsID);
            ps.setLong(2, this.AditionalFieldDetailsProductID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(Connection connection) {
        String query = "delete from aditionalfielddetailsproduct where AditionalFieldDetailsProductID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, this.AditionalFieldDetailsProductID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteByProductId(Connection connection) {
        String query = "delete from aditionalfielddetailsproduct where ProductID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, this.ProductID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteByComboBox(Connection connection) {
        String query = "delete from aditionalfielddetailsproduct where AditionalFieldDetailsID = ? AND ProductID = ?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, this.AditionalFieldDetailsID);
            ps.setLong(2, this.ProductID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void insert(Connection connection) {
        String query = "insert into aditionalfielddetailsproduct (ProductID, AditionalFieldID, AditionalFieldDetailsID) values (?, ?, ?)";
        try {
            PreparedStatement ps = connection.prepareStatement(query, 1);
            ps.setLong(1, this.ProductID);
            ps.setLong(2, this.AditionalFieldID);
            ps.setLong(3, this.AditionalFieldDetailsID);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            this.AditionalFieldDetailsProductID = rs.getLong(1);
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

