/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.person;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class PersonVatType {
    private int PersonVatTypeID;
    private String Name;

    public PersonVatType(int PersonVatTypeID, String Name) {
        this.PersonVatTypeID = PersonVatTypeID;
        this.Name = Name;
    }

    public PersonVatType() {
    }

    public int getPersonVatTypeID() {
        return this.PersonVatTypeID;
    }

    public void setPersonVatTypeID(int PersonVatTypeID) {
        this.PersonVatTypeID = PersonVatTypeID;
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public String toString() {
        return this.Name;
    }

    public static PersonVatType getById(Connection connection, int id) {
        try {
            PreparedStatement ps = connection.prepareStatement("select * from personvattype where personVatTypeId = ?");
            ps.setInt(1, id);
            ResultSet rs = ps.executeQuery();
            rs.next();
            PersonVatType pvt = new PersonVatType();
            pvt.setPersonVatTypeID(rs.getInt("personVatTypeId"));
            pvt.setName(rs.getString("Name"));
            ps.close();
            rs.close();
            return pvt;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static PersonVatType getByName(Connection connection, String typeName) {
        try {
            PreparedStatement ps = connection.prepareStatement("select * from personvattype where name = ?");
            ps.setString(1, typeName);
            ResultSet rs = ps.executeQuery();
            rs.next();
            PersonVatType pvt = new PersonVatType();
            pvt.setPersonVatTypeID(rs.getInt("personVatTypeId"));
            pvt.setName(rs.getString("Name"));
            ps.close();
            rs.close();
            return pvt;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ObservableList<PersonVatType> getList(Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        try {
            PreparedStatement ps = connection.prepareStatement("select * from personvattype");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add((Object)new PersonVatType(rs.getInt("PersonVatTypeID"), rs.getString("Name")));
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void insertPersonVatType(Connection connection, int id, String typeName) {
        String query = "INSERT INTO personvattype (personVatTypeId,name) VALUES (?,?)";
        try {
            connection.setAutoCommit(false);
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, id);
            ps.setString(2, typeName);
            ps.execute();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                connection.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    public static void checkPersonVatType(Connection connection, String pvtName) {
        boolean exsist = false;
        ObservableList<PersonVatType> typesList = PersonVatType.getList(connection);
        for (PersonVatType pvt : typesList) {
            if (!pvt.getName().equals(pvtName)) continue;
            exsist = true;
            break;
        }
        if (!exsist) {
            PersonVatType.insertPersonVatType(connection, typesList.size() + 1, pvtName);
        }
    }
}

