/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.person;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;

public class GiftCard {
    private long giftCardID;
    private String name;
    private String code;
    private BigDecimal amount;
    private boolean active;

    public long getGiftCardID() {
        return this.giftCardID;
    }

    public void setGiftCardID(long giftCardID) {
        this.giftCardID = giftCardID;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static ObservableList<GiftCard> getList(ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM giftcard gc";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                GiftCard gCard = new GiftCard();
                gCard.setGiftCardID(rSet.getLong("GiftCardID"));
                gCard.setCode(rSet.getString("Code"));
                gCard.setAmount(rSet.getBigDecimal("Amount"));
                gCard.setActive(rSet.getBoolean("Active"));
                gCard.setName(rSet.getString("Name"));
                list.add((Object)gCard);
            }
            pStatement.close();
            rSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void updateAmount(ScreensController controller) {
        String query = "UPDATE giftcard SET Amount = ? WHERE GiftCardID = ?";
        try {
            PreparedStatement preparedStatement = controller.getSettings().getConnection().prepareStatement(query);
            preparedStatement.setBigDecimal(1, this.amount);
            preparedStatement.setLong(2, this.giftCardID);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void insert(ScreensController controller) throws SQLException {
        String query = "INSERT INTO `giftcard` (`Code`, `Name`, `Amount`, `Active`) VALUES (?,? , ?, ?)";
        PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
        pStatement.setString(1, this.code);
        pStatement.setString(2, this.name);
        pStatement.setBigDecimal(3, this.amount);
        pStatement.setBoolean(4, this.active);
        pStatement.executeUpdate();
        pStatement.close();
    }

    public void update(ScreensController controller) {
        String query = "UPDATE giftcard SET Code = ?,Name = ?, Amount = ?, Active = ? WHERE GiftCardID = ?";
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, this.code);
            pStatement.setString(2, this.name);
            pStatement.setBigDecimal(3, this.amount);
            pStatement.setBoolean(4, this.active);
            pStatement.setLong(5, this.giftCardID);
            pStatement.executeUpdate();
            pStatement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(long giftCardID, Connection connection) {
        try {
            PreparedStatement ps = connection.prepareStatement("DELETE FROM giftcard WHERE GiftCardID = ?");
            ps.setLong(1, giftCardID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

