/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.person;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;

public class CashBuyer {
    private Long cashBuyerID;
    private String name;
    private String PIB;
    private String MB;
    private String address;
    private String city;
    private String ZIP;
    private Date sysDTCreated;
    private Long sysUserAddID;

    public Long getCashBuyerID() {
        return this.cashBuyerID;
    }

    public void setCashBuyerID(Long cashBuyerID) {
        this.cashBuyerID = cashBuyerID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPIB() {
        return this.PIB;
    }

    public void setPIB(String pIB) {
        this.PIB = pIB;
    }

    public String getMB() {
        return this.MB;
    }

    public void setMB(String mB) {
        this.MB = mB;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getZIP() {
        return this.ZIP;
    }

    public void setZIP(String zIP) {
        this.ZIP = zIP;
    }

    public Date getSysDTCreated() {
        return this.sysDTCreated;
    }

    public void setSysDTCreated(Date sysDTCreated) {
        this.sysDTCreated = sysDTCreated;
    }

    public Long getSysUserAddID() {
        return this.sysUserAddID;
    }

    public void setSysUserAddID(Long sysUserAddID) {
        this.sysUserAddID = sysUserAddID;
    }

    public String toString() {
        return this.name;
    }

    public static CashBuyer getById(long id, ScreensController controller) {
        String query = "SELECT * FROM cashbuyers cb WHERE cb.cashBuyerID = ?";
        CashBuyer cashBuyer = new CashBuyer();
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, id);
            ResultSet resultSet = pStatement.executeQuery();
            resultSet.next();
            cashBuyer.setCashBuyerID(resultSet.getLong("cashBuyerID"));
            cashBuyer.name = resultSet.getString("name");
            cashBuyer.PIB = resultSet.getString("PIB");
            cashBuyer.MB = resultSet.getString("MB");
            cashBuyer.address = resultSet.getString("address");
            cashBuyer.city = resultSet.getString("city");
            cashBuyer.ZIP = resultSet.getString("ZIP");
            cashBuyer.sysDTCreated = resultSet.getDate("sysDTCreated");
            cashBuyer.sysUserAddID = resultSet.getLong("sysUserAddID");
        }
        catch (SQLException e) {
            return null;
        }
        return cashBuyer;
    }

    public static CashBuyer getByPib(String pib, ScreensController controller) {
        String query = "SELECT * FROM cashbuyers cb WHERE cb.PIB = ?";
        CashBuyer cashBuyer = new CashBuyer();
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setString(1, pib.trim());
            ResultSet resultSet = pStatement.executeQuery();
            resultSet.next();
            cashBuyer.setCashBuyerID(resultSet.getLong("cashBuyerID"));
            cashBuyer.name = resultSet.getString("name");
            cashBuyer.PIB = resultSet.getString("PIB");
            cashBuyer.MB = resultSet.getString("MB");
            cashBuyer.address = resultSet.getString("address");
            cashBuyer.city = resultSet.getString("city");
            cashBuyer.ZIP = resultSet.getString("ZIP");
            cashBuyer.sysDTCreated = resultSet.getDate("sysDTCreated");
            cashBuyer.sysUserAddID = resultSet.getLong("sysUserAddID");
        }
        catch (SQLException e) {
            return null;
        }
        return cashBuyer;
    }

    public static ObservableList<CashBuyer> getCashBuyerList(String filter, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM cashbuyers cb WHERE ((cb.name LIKE ?) OR (cb.PIB LIKE ?))";
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(query);
            preparedStatement.setString(1, "%" + filter + "%");
            preparedStatement.setString(2, "%" + filter + "%");
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                CashBuyer cashBuyer = new CashBuyer();
                cashBuyer.cashBuyerID = resultSet.getLong("cashBuyerID");
                cashBuyer.name = resultSet.getString("name");
                cashBuyer.PIB = resultSet.getString("PIB");
                cashBuyer.MB = resultSet.getString("MB");
                cashBuyer.address = resultSet.getString("address");
                cashBuyer.city = resultSet.getString("city");
                cashBuyer.ZIP = resultSet.getString("ZIP");
                cashBuyer.sysDTCreated = resultSet.getDate("sysDTCreated");
                cashBuyer.sysUserAddID = resultSet.getLong("sysUserAddID");
                list.add((Object)cashBuyer);
            }
            preparedStatement.close();
            resultSet.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public static ObservableList<CashBuyer> getCashBuyerList(Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT * FROM cashbuyers";
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(query);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                CashBuyer cashBuyer = new CashBuyer();
                cashBuyer.cashBuyerID = resultSet.getLong("cashBuyerID");
                cashBuyer.name = resultSet.getString("name");
                cashBuyer.PIB = resultSet.getString("PIB");
                cashBuyer.MB = resultSet.getString("MB");
                cashBuyer.address = resultSet.getString("address");
                cashBuyer.city = resultSet.getString("city");
                cashBuyer.ZIP = resultSet.getString("ZIP");
                cashBuyer.sysDTCreated = resultSet.getDate("sysDTCreated");
                cashBuyer.sysUserAddID = resultSet.getLong("sysUserAddID");
                list.add((Object)cashBuyer);
            }
            preparedStatement.close();
            resultSet.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        return list;
    }

    public long insert(Connection connection) throws SQLException {
        String query = "INSERT INTO cashbuyers (name, PIB, MB, address, city, ZIP, sysUserAddID) VALUES (?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement preparedStatement = connection.prepareStatement(query, 1);
        preparedStatement.setString(1, this.name);
        preparedStatement.setString(2, this.PIB);
        preparedStatement.setString(3, this.MB);
        preparedStatement.setString(4, this.address);
        preparedStatement.setString(5, this.city);
        preparedStatement.setString(6, this.ZIP);
        preparedStatement.setLong(7, this.sysUserAddID);
        preparedStatement.executeUpdate();
        ResultSet resultSet = preparedStatement.getGeneratedKeys();
        resultSet.next();
        this.cashBuyerID = resultSet.getLong(1);
        preparedStatement.close();
        resultSet.close();
        return this.cashBuyerID;
    }

    public void update(Connection connection) throws SQLException {
        String query = "UPDATE cashbuyers SET name = ?, PIB = ?, MB = ?, address = ?, city = ?, ZIP=?, sysDTCreated = ?, sysUserAddID = ? WHERE cashBuyerID = ?";
        PreparedStatement preparedStatement = connection.prepareStatement(query);
        preparedStatement.setString(1, this.name);
        preparedStatement.setString(2, this.PIB);
        preparedStatement.setString(3, this.MB);
        preparedStatement.setString(4, this.address);
        preparedStatement.setString(5, this.city);
        preparedStatement.setString(6, this.ZIP);
        preparedStatement.setTimestamp(7, Timestamp.valueOf(LocalDateTime.now()));
        preparedStatement.setLong(8, this.sysUserAddID);
        preparedStatement.setLong(9, this.cashBuyerID);
        preparedStatement.executeUpdate();
        preparedStatement.close();
    }

    public void delete(long cashBuyerId, Connection connection) {
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM cashbuyers WHERE cashBuyerID = ?");
            preparedStatement.setLong(1, cashBuyerId);
            preparedStatement.executeUpdate();
            preparedStatement.close();
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }
}

