/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.person;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Date;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;

public class Address {
    private long AddressID;
    private int AddressTypeID;
    private long PersonID;
    private String Address;
    private String City;
    private String State;
    private String Zip;
    private String Municipality;
    private boolean IsPrimary;
    private boolean Active;
    private Date sysDTCreated;
    private Date sysDTEdit;
    private long sysUserAddID;
    private long sysUserEditID;

    public long getAddressID() {
        return this.AddressID;
    }

    public void setAddressID(long addressID) {
        this.AddressID = addressID;
    }

    public int getAddressTypeID() {
        return this.AddressTypeID;
    }

    public void setAddressTypeID(int addressTypeID) {
        this.AddressTypeID = addressTypeID;
    }

    public long getPersonID() {
        return this.PersonID;
    }

    public void setPersonID(long personID) {
        this.PersonID = personID;
    }

    public String getAddress() {
        return this.Address;
    }

    public void setAddress(String address) {
        this.Address = address;
    }

    public String getCity() {
        return this.City;
    }

    public void setCity(String city) {
        this.City = city;
    }

    public String getState() {
        return this.State;
    }

    public void setState(String state) {
        this.State = state;
    }

    public String getZip() {
        return this.Zip;
    }

    public void setZip(String zip) {
        this.Zip = zip;
    }

    public String getMunicipality() {
        return this.Municipality;
    }

    public void setMunicipality(String municipality) {
        this.Municipality = municipality;
    }

    public boolean isIsPrimary() {
        return this.IsPrimary;
    }

    public void setIsPrimary(boolean isPrimary) {
        this.IsPrimary = isPrimary;
    }

    public boolean isActive() {
        return this.Active;
    }

    public void setActive(boolean active) {
        this.Active = active;
    }

    public Date getSysDTCreated() {
        return this.sysDTCreated;
    }

    public void setSysDTCreated(Date sysDTCreated) {
        this.sysDTCreated = sysDTCreated;
    }

    public Date getSysDTEdit() {
        return this.sysDTEdit;
    }

    public void setSysDTEdit(Date sysDTEdit) {
        this.sysDTEdit = sysDTEdit;
    }

    public long getSysUserAddID() {
        return this.sysUserAddID;
    }

    public void setSysUserAddID(long sysUserAddID) {
        this.sysUserAddID = sysUserAddID;
    }

    public long getSysUserEditID() {
        return this.sysUserEditID;
    }

    public void setSysUserEditID(long sysUserEditID) {
        this.sysUserEditID = sysUserEditID;
    }

    public long insert(ScreensController controller) {
        String query = "insert into address (AddressTypeID,Address,City,State,Zip,IsPrimary,Active,sysUserAddID,Municipality) values (?,?,?,?,?,?,?,?,?)";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query, 1);
            ps.setInt(1, this.AddressTypeID);
            ps.setString(2, this.Address);
            ps.setString(3, this.City);
            ps.setString(4, this.State);
            ps.setString(5, this.Zip);
            ps.setBoolean(6, this.IsPrimary);
            ps.setBoolean(7, this.Active);
            ps.setLong(8, controller.getUser().getUserID());
            ps.setString(9, this.Municipality);
            ps.executeUpdate();
            ResultSet rs = ps.getGeneratedKeys();
            rs.next();
            this.AddressID = rs.getLong(1);
            ps.close();
            rs.close();
            return this.AddressID;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public void update(ScreensController controller) {
        String query = " UPDATE address SET  \t\t`AddressTypeID` = ?,\t\t`Address` = ?,\t\t`City` = ?,\t\t`State` = ?,\t\t`Zip` = ?,\t\t`IsPrimary` = ?,\t\t`Active` = ?,\t\t`sysDTEdit` = ?,\t\t`sysUserEditID` = ?,\t\t`Municipality` = ? WHERE `AddressID` = ?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query, 1);
            ps.setInt(1, this.AddressTypeID);
            ps.setString(2, this.Address);
            ps.setString(3, this.City);
            ps.setString(4, this.State);
            ps.setString(5, this.Zip);
            ps.setBoolean(6, this.IsPrimary);
            ps.setBoolean(7, this.Active);
            ps.setDate(8, new java.sql.Date(Settings.DatefromLocalDateTime(LocalDateTime.now()).getTime()));
            ps.setLong(9, controller.getUser().getUserID());
            ps.setString(10, this.Municipality);
            ps.setLong(11, this.AddressID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static Address getByID(long id, Connection connection) {
        String query = "select * from address where AddressID = ? ";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, id);
            ResultSet rs = ps.executeQuery();
            rs.next();
            Address a = new Address();
            a.AddressID = rs.getLong("AddressID");
            a.AddressTypeID = rs.getInt("AddressTypeID");
            a.Address = rs.getString("Address");
            a.City = rs.getString("City");
            a.State = rs.getString("State");
            a.Zip = rs.getString("Zip");
            a.IsPrimary = rs.getBoolean("IsPrimary");
            a.Active = rs.getBoolean("Active");
            a.sysDTCreated = rs.getTimestamp("sysDTCreated");
            a.sysDTEdit = rs.getTimestamp("sysDTEdit");
            a.sysUserAddID = rs.getLong("sysUserAddID");
            a.sysUserEditID = rs.getLong("sysUserEditID");
            try {
                a.Municipality = rs.getString("Municipality");
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            ps.close();
            rs.close();
            return a;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

