/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.WarehouseCentral;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentStatus;
import rs.petcom.master.dal.document.DocumentType;
import rs.petcom.master.dal.person.Person;

public class VeleprodajnaFaktura {
    private long documentID;
    private int departmentID;
    private int documentTypeId;
    private int number;
    private int warehouseId;
    private String note;
    private Date date;
    private Date deliveryDate;
    private Date paymentDate;
    private Person buyer;
    private DocumentStatus documentStatus;
    private double sum;
    private double sumWithDiscount;
    private double discount;
    private boolean locked;

    public long getDocumentID() {
        return this.documentID;
    }

    public void setDocumentID(long documentID) {
        this.documentID = documentID;
    }

    public int getDepartmentID() {
        return this.departmentID;
    }

    public void setDepartmentID(int departmentID) {
        this.departmentID = departmentID;
    }

    public int getWarehouseId() {
        return this.warehouseId;
    }

    public void setWarehouseId(int warehouseId) {
        this.warehouseId = warehouseId;
    }

    public int getDocumentTypeId() {
        return this.documentTypeId;
    }

    public void setDocumentTypeId(int documentTypeId) {
        this.documentTypeId = documentTypeId;
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Date getDeliveryDate() {
        return this.deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public Date getPaymentDate() {
        return this.paymentDate;
    }

    public void setPaymentDate(Date paymentDate) {
        this.paymentDate = paymentDate;
    }

    public Person getBuyer() {
        return this.buyer;
    }

    public void setBuyer(Person buyer) {
        this.buyer = buyer;
    }

    public DocumentStatus getDocumentStatus() {
        return this.documentStatus;
    }

    public void setDocumentStatus(DocumentStatus documentStatus) {
        this.documentStatus = documentStatus;
    }

    public double getSum() {
        return this.sum;
    }

    public void setSum(double sum) {
        this.sum = sum;
    }

    public double getSumWithDiscount() {
        return this.sumWithDiscount;
    }

    public void setSumWithDiscount(double sumWithDiscount) {
        this.sumWithDiscount = sumWithDiscount;
    }

    public double getDiscount() {
        return this.discount;
    }

    public void setDiscount(double discount) {
        this.discount = discount;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public long insert(ScreensController controller) throws SQLException {
        Document document = new Document();
        document.setDocumentTypeID(this.documentTypeId);
        document.setDocumentStatusID(1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        document.setYear(cal.get(1));
        document.setDate(this.date);
        document.setDeliveryDate(this.deliveryDate);
        document.setCurrencyDate(this.paymentDate);
        document.setNumber(this.number);
        document.setSysUserAddID(controller.getUser().getUserID());
        document.setDepartmentID(this.departmentID);
        document.setNote(this.note);
        document.setPersonID(this.buyer.getPersonID());
        document.setSum(this.sum);
        document.setSumWithDiscount(this.sumWithDiscount);
        document.setDiscount(this.discount);
        document.setPointOfSaleID(controller.getPointOfSale().getPointOfSaleID());
        this.documentID = document.insert(controller);
        return document.getDocumentID();
    }

    public void update(ScreensController controller) {
        Document document = Document.getByID(this.documentID, controller.getSettings().getConnection());
        document.setDate(this.date);
        document.setDeliveryDate(this.deliveryDate);
        document.setCurrencyDate(this.paymentDate);
        document.setPersonID(this.buyer.getPersonID());
        document.setDocumentStatusID(this.documentStatus.getDocumentStatusID());
        document.setNote(this.note);
        document.setSysUserAddID(controller.getUser().getUserID());
        document.setSum(this.sum);
        document.setSumWithDiscount(this.sumWithDiscount);
        document.setDiscount(this.discount);
        try {
            document.update(controller);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(Connection connection) throws SQLException {
        String query = "delete from document where DocumentID = ?";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setLong(1, this.documentID);
        ps.executeUpdate();
        ps.close();
    }

    public static ObservableList<VeleprodajnaFaktura> getList(Date dateFrom, Date dateTo, Department department, long selectedPerson, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select *   from document d where DocumentTypeID = ?   and DATE(Date) >= ?    and Date < DATE_ADD(?,INTERVAL 1 DAY)    and DepartmentID = ?   and (? = -1 or d.PersonID = ?) order by Date desc";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setLong(1, DocumentType.getByCode("VPF", controller.getSettings().getConnection()).getDocumentTypeID());
            ps.setTimestamp(2, new Timestamp(dateFrom.getTime()));
            ps.setTimestamp(3, new Timestamp(dateTo.getTime()));
            ps.setInt(4, department.getDepartmentID());
            ps.setLong(5, selectedPerson);
            ps.setLong(6, selectedPerson);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                VeleprodajnaFaktura veleprodajnaFaktura = new VeleprodajnaFaktura();
                veleprodajnaFaktura.documentID = rs.getLong("DocumentID");
                veleprodajnaFaktura.number = rs.getInt("Number");
                veleprodajnaFaktura.date = rs.getTimestamp("Date");
                veleprodajnaFaktura.deliveryDate = rs.getTimestamp("DeliveryDate");
                veleprodajnaFaktura.paymentDate = rs.getTimestamp("CurrencyDate");
                long personID = rs.getLong("PersonID");
                veleprodajnaFaktura.buyer = Person.getById(personID, controller);
                veleprodajnaFaktura.note = rs.getString("Note");
                veleprodajnaFaktura.departmentID = rs.getInt("DepartmentID");
                veleprodajnaFaktura.sum = rs.getDouble("Sum");
                veleprodajnaFaktura.sumWithDiscount = rs.getDouble("SumWithDiscount");
                veleprodajnaFaktura.locked = rs.getBoolean("documentLocked");
                list.add((Object)veleprodajnaFaktura);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<VeleprodajnaFaktura> getWarehouseCentralList(Date dateFrom, Date dateTo, WarehouseCentral warehouseCentral, long selectedPerson, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select *   from document d where DocumentTypeID = ?   and DATE(Date) >= ?    and Date < DATE_ADD(?,INTERVAL 1 DAY)    and WarehouseID = ?   and (? = -1 or d.PersonID = ?) order by Date desc";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setLong(1, DocumentType.getByCode("VPF", controller.getSettings().getConnection()).getDocumentTypeID());
            ps.setTimestamp(2, new Timestamp(dateFrom.getTime()));
            ps.setTimestamp(3, new Timestamp(dateTo.getTime()));
            ps.setInt(4, warehouseCentral.getWarehouseId());
            ps.setLong(5, selectedPerson);
            ps.setLong(6, selectedPerson);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                VeleprodajnaFaktura veleprodajnaFaktura = new VeleprodajnaFaktura();
                veleprodajnaFaktura.documentID = rs.getLong("DocumentID");
                veleprodajnaFaktura.number = rs.getInt("Number");
                veleprodajnaFaktura.date = rs.getTimestamp("Date");
                veleprodajnaFaktura.deliveryDate = rs.getTimestamp("DeliveryDate");
                veleprodajnaFaktura.paymentDate = rs.getTimestamp("CurrencyDate");
                long personID = rs.getLong("PersonID");
                veleprodajnaFaktura.buyer = Person.getById(personID, controller);
                veleprodajnaFaktura.note = rs.getString("Note");
                veleprodajnaFaktura.warehouseId = rs.getInt("WarehouseID");
                veleprodajnaFaktura.sum = rs.getDouble("Sum");
                veleprodajnaFaktura.sumWithDiscount = rs.getDouble("SumWithDiscount");
                list.add((Object)veleprodajnaFaktura);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public boolean getWithExcise(ScreensController controller) {
        String query = "select count(*) as brr from documentdetails dd right join exciseproduct ep on ep.ProductID = dd.ProductID  where dd.DocumentID = ? group by dd.ProductID limit 1";
        boolean check = false;
        try {
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setLong(1, this.documentID);
            ResultSet rSet = pStatement.executeQuery();
            if (rSet.next()) {
                check = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return check;
    }
}

