/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.SravnjenjePoPopisu;
import rs.petcom.master.dal.product.Product;

public class SravnjenjePoPopisuDetailes {
    private long SravnjenjePoPopisuDetailesID;
    private long SravnjenjePoPopisuID;
    private long ProductID;
    private String ProductCode;
    private String ProductName;
    private double PocetnoStanje;
    private double Popisano;
    private double Razlika;
    private String barcode;
    private LocalDateTime Date;

    public SravnjenjePoPopisuDetailes() {
    }

    public SravnjenjePoPopisuDetailes(long SravnjenjePoPopisuDetailesID, long SravnjenjePoPopisuID, long ProductID, String ProductCode, String ProductName, double PocetnoStanje2, double Popisano, double Razlika) {
        this.SravnjenjePoPopisuDetailesID = SravnjenjePoPopisuDetailesID;
        this.SravnjenjePoPopisuID = SravnjenjePoPopisuID;
        this.ProductID = ProductID;
        this.ProductCode = ProductCode;
        this.ProductName = ProductName;
        this.PocetnoStanje = PocetnoStanje2;
        this.Popisano = Popisano;
        this.Razlika = Razlika;
    }

    public void setDate(LocalDateTime date) {
        this.Date = date;
    }

    public LocalDateTime getDate() {
        return this.Date;
    }

    public long getSravnjenjePoPopisuDetailesID() {
        return this.SravnjenjePoPopisuDetailesID;
    }

    public void setSravnjenjePoPopisuDetailesID(long sravnjenjePoPopisuDetailesID) {
        this.SravnjenjePoPopisuDetailesID = sravnjenjePoPopisuDetailesID;
    }

    public long getSravnjenjePoPopisuID() {
        return this.SravnjenjePoPopisuID;
    }

    public void setSravnjenjePoPopisuID(long sravnjenjePoPopisuID) {
        this.SravnjenjePoPopisuID = sravnjenjePoPopisuID;
    }

    public long getProductID() {
        return this.ProductID;
    }

    public void setProductID(long productID) {
        this.ProductID = productID;
    }

    public String getProductCode() {
        return this.ProductCode;
    }

    public void setProductCode(String productCode) {
        this.ProductCode = productCode;
    }

    public String getProductName() {
        return this.ProductName;
    }

    public void setProductName(String productName) {
        this.ProductName = productName;
    }

    public double getPocetnoStanje() {
        return this.PocetnoStanje;
    }

    public void setPocetnoStanje(double pocetnoStanje) {
        this.PocetnoStanje = pocetnoStanje;
    }

    public double getPopisano() {
        return this.Popisano;
    }

    public void setPopisano(double popisano) {
        this.Popisano = popisano;
    }

    public double getRazlika() {
        return this.Razlika;
    }

    public void setRazlika(double razlika) {
        this.Razlika = razlika;
    }

    public String getBarcode() {
        return this.barcode;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public void refreshSravnjenje() {
        this.setRazlika(this.Popisano - this.PocetnoStanje);
    }

    public static ObservableList<SravnjenjePoPopisuDetailes> getlist(SravnjenjePoPopisu sravnjenjePoPopisu, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        PreparedStatement ps = null;
        ResultSet rs = null;
        double selectedProductStock = 0.0;
        try {
            if (sravnjenjePoPopisu.getDocumentID() > 0L) {
                String query = "select \td.DocumentDetailsID,\td.DocumentID,\td.ProductID, b.BarCode,\tp.Code,\tp.Name,\t0 as PocetnoStanje,\td.Quantity as Razlika,\t0 as Razlika, doc.Date, doc.DepartmentID  from documentdetails d left join product p on p.ProductID = d.ProductID LEFT JOIN barcode b ON d.ProductID = b.ProductID  left join document doc on doc.DocumentID = d.DocumentID  where d.DocumentID = ? order by p.Code";
                ps = controller.getSettings().getConnection().prepareStatement(query);
                ps.setLong(1, sravnjenjePoPopisu.getDocumentID());
                System.out.println(ps);
                rs = ps.executeQuery();
                while (rs.next()) {
                    SravnjenjePoPopisuDetailes spp = new SravnjenjePoPopisuDetailes();
                    spp.setSravnjenjePoPopisuDetailesID(rs.getLong("DocumentDetailsID"));
                    spp.setSravnjenjePoPopisuID(rs.getLong("DocumentID"));
                    spp.setProductID(rs.getLong("ProductID"));
                    spp.setProductCode(rs.getString("Code"));
                    spp.setProductName(rs.getString("Name"));
                    spp.setBarcode(rs.getString("BarCode"));
                    spp.setRazlika(rs.getDouble("Razlika"));
                    spp.setDate(rs.getTimestamp("Date").toLocalDateTime());
                    try {
                        selectedProductStock = Product.getNewCurrentStock(controller, WorkDay.datumPocetnogStanja(Department.getByPOS(controller.getPointOfSale(), controller.getSettings().getConnection()).getDepartmentID(), Settings.DatefromLocalDateTime(spp.getDate()), controller.getSettings().getConnection()), WorkDay.getDateToForDep(Settings.fromDate(rs.getTimestamp("Date")), Department.getByPOS(controller.getPointOfSale(), controller.getSettings().getConnection()).getDepartmentID(), controller.getSettings().getConnection()), spp.getProductID());
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                    spp.setPocetnoStanje(selectedProductStock - spp.getRazlika());
                    spp.setPopisano(spp.getPocetnoStanje() + spp.getRazlika());
                    list.add((Object)spp);
                }
            } else {
                String query = "SELECT d.ProductID, -1 AS DocumentDetailsID, -1 AS DocumentID, d.Date , p.Code, p.Name, b.BarCode, 0 AS PocetnoStanje,  0 AS Razlika,  doc.DepartmentID  FROM documentdetails d  LEFT JOIN product p ON p.ProductID = d.ProductID  LEFT JOIN barcode b ON d.ProductID = b.ProductID  LEFT JOIN document doc ON doc.DocumentID = d.DocumentID where doc.DepartmentID = ?  GROUP BY d.ProductID";
                ps = controller.getSettings().getConnection().prepareStatement(query);
                ps.setInt(1, sravnjenjePoPopisu.getDepartmentID());
                rs = ps.executeQuery();
                while (rs.next()) {
                    SravnjenjePoPopisuDetailes spp = new SravnjenjePoPopisuDetailes();
                    spp.setDate(LocalDateTime.now());
                    spp.setSravnjenjePoPopisuDetailesID(-1L);
                    spp.setSravnjenjePoPopisuID(-1L);
                    spp.setProductID(rs.getLong("ProductID"));
                    spp.setProductCode(rs.getString("Code"));
                    spp.setProductName(rs.getString("Name"));
                    spp.setBarcode(rs.getString("BarCode"));
                    spp.setPocetnoStanje(selectedProductStock);
                    spp.setPopisano(0.0);
                    spp.setRazlika(spp.getPopisano() - spp.getPocetnoStanje());
                    if (list.size() != 300) {
                        list.add((Object)spp);
                        continue;
                    }
                    break;
                }
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<SravnjenjePoPopisuDetailes> getFilteredList(String filter, SravnjenjePoPopisu sravnjenjePoPopisu, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        double selectedProductStock = 0.0;
        if (filter.trim().isEmpty()) {
            return list;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            if (sravnjenjePoPopisu.getDocumentID() > 0L) {
                String query = "SELECT d.DocumentDetailsID, d.DocumentID, doc.date, d.ProductID, p.Code, p.Name, b.BarCode,  0 AS PocetnoStanje,\td.Quantity AS Razlika, 0 AS Razlika FROM documentdetails d LEFT JOIN product p ON p.ProductID = d.ProductID LEFT JOIN barcode b ON d.ProductID = b.ProductID LEFT JOIN document doc ON doc.DocumentID = d.DocumentID WHERE d.DocumentID = ? AND (p.Code LIKE ? OR p.Name LIKE ? OR b.BarCode LIKE ?) ORDER BY p.ProductID ";
                ps = controller.getSettings().getConnection().prepareStatement(query);
                ps.setLong(1, sravnjenjePoPopisu.getDocumentID());
                ps.setString(2, "%" + filter + "%");
                ps.setString(3, "%" + filter + "%");
                ps.setString(4, "%" + filter + "%");
                rs = ps.executeQuery();
                while (rs.next()) {
                    SravnjenjePoPopisuDetailes spp = new SravnjenjePoPopisuDetailes();
                    spp.setSravnjenjePoPopisuDetailesID(rs.getLong("DocumentDetailsID"));
                    spp.setSravnjenjePoPopisuID(rs.getLong("DocumentID"));
                    spp.setProductID(rs.getLong("ProductID"));
                    spp.setProductCode(rs.getString("Code"));
                    spp.setProductName(rs.getString("Name"));
                    spp.setBarcode(rs.getString("BarCode"));
                    spp.setRazlika(rs.getDouble("Razlika"));
                    spp.setDate(rs.getTimestamp("Date").toLocalDateTime());
                    try {
                        selectedProductStock = Product.getNewCurrentStock(controller, WorkDay.datumPocetnogStanja(Department.getByPOS(controller.getPointOfSale(), controller.getSettings().getConnection()).getDepartmentID(), Settings.DatefromLocalDateTime(spp.getDate()), controller.getSettings().getConnection()), WorkDay.getDateToForDep(Settings.fromDate(rs.getTimestamp("Date")), Department.getByPOS(controller.getPointOfSale(), controller.getSettings().getConnection()).getDepartmentID(), controller.getSettings().getConnection()), spp.getProductID());
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                    spp.setPocetnoStanje(selectedProductStock);
                    spp.setPopisano(spp.getPocetnoStanje() + spp.getRazlika());
                    if (list.size() != 100) {
                        list.add((Object)spp);
                        continue;
                    }
                    break;
                }
            } else {
                String query = "SELECT d.ProductID, -1 AS DocumentDetailsID, -1 AS DocumentID, d.Date, p.Code, p.Name, b.BarCode, 0 AS PocetnoStanje, 0 AS Razlika, doc.DepartmentID FROM documentdetails d LEFT JOIN product p ON p.ProductID = d.ProductID LEFT JOIN barcode b ON d.ProductID = b.ProductID LEFT JOIN document doc ON doc.DocumentID = d.DocumentID where doc.DepartmentID = ? AND (p.Code LIKE ? OR p.Name LIKE ? OR b.BarCode LIKE ?) GROUP BY p.ProductID ";
                ps = controller.getSettings().getConnection().prepareStatement(query);
                ps.setInt(1, sravnjenjePoPopisu.getDepartmentID());
                ps.setString(2, "%" + filter + "%");
                ps.setString(3, "%" + filter + "%");
                ps.setString(4, "%" + filter + "%");
                rs = ps.executeQuery();
                while (rs.next()) {
                    SravnjenjePoPopisuDetailes spp = new SravnjenjePoPopisuDetailes();
                    spp.setDate(LocalDateTime.now());
                    spp.setSravnjenjePoPopisuDetailesID(-1L);
                    spp.setSravnjenjePoPopisuID(-1L);
                    spp.setProductID(rs.getLong("ProductID"));
                    spp.setProductCode(rs.getString("Code"));
                    spp.setProductName(rs.getString("Name"));
                    spp.setBarcode(rs.getString("BarCode"));
                    spp.setPocetnoStanje(0.0);
                    spp.setPopisano(0.0);
                    spp.setRazlika(spp.getPopisano() - spp.getPocetnoStanje());
                    list.add((Object)spp);
                    if (list.size() != 100) continue;
                    break;
                }
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void delete(Connection connection) {
        DocumentDetails dd = new DocumentDetails();
        dd.setDocumentDetailsID(this.SravnjenjePoPopisuDetailesID);
        dd.delete(connection);
    }

    public void update(ScreensController controller) {
        DocumentDetails dd = DocumentDetails.getByID(this.SravnjenjePoPopisuDetailesID, controller.getSettings().getConnection());
        dd.setQuantity(this.Razlika);
        dd.update(controller);
    }

    public long insert(ScreensController controller) {
        long result;
        Product p = Product.getByID(this.ProductID, controller);
        DocumentDetails dd = new DocumentDetails();
        dd.setDocumentID(this.SravnjenjePoPopisuID);
        dd.setProductID(this.ProductID);
        dd.setDate(this.Date);
        dd.setUnitID(p.getUnitID());
        dd.setVatID(p.getVatID());
        dd.setQuantity(this.Razlika);
        dd.setSysUserAddID(controller.getUser().getUserID());
        this.SravnjenjePoPopisuDetailesID = result = dd.insert(controller.getSettings().getConnection());
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SravnjenjePoPopisuDetailes)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        SravnjenjePoPopisuDetailes that = (SravnjenjePoPopisuDetailes)obj;
        if (this.ProductCode == null ? that.ProductCode != null : !this.ProductCode.equals(that.ProductCode)) {
            return false;
        }
        if (this.ProductName == null ? that.ProductName != null : !this.ProductName.equals(that.ProductName)) {
            return false;
        }
        return !(this.barcode == null ? that.barcode != null : !this.barcode.equals(that.barcode));
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.ProductCode == null ? 0 : this.ProductCode.hashCode());
        result = 31 * result + (this.ProductName == null ? 0 : this.ProductName.hashCode());
        result = 31 * result + (this.barcode == null ? 0 : this.barcode.hashCode());
        return result;
    }

    public String toString() {
        return (this.ProductCode != null ? this.ProductCode + " -- " : "") + (this.ProductName != null ? this.ProductName + " -- " : "") + (this.barcode != null ? this.barcode : "");
    }
}

