/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;

public class SalesReportByDays {
    private Date revenueDate;
    private double Revenue;
    private double fromCash;
    private double fromCard;
    private double fromDocCheck;
    private double fromInvoice;
    private double fromCombined;
    private double cashCombined;
    private double cardCombined;
    private double checkCombined;
    private double NI;

    public Date getRevenueDate() {
        return this.revenueDate;
    }

    public void setRevenueDate(Date revenueDate) {
        this.revenueDate = revenueDate;
    }

    public double getRevenue() {
        return this.Revenue;
    }

    public void setRevenue(double revenue) {
        this.Revenue = revenue;
    }

    public double getFromCash() {
        return this.fromCash;
    }

    public void setFromCash(double fromCash) {
        this.fromCash = fromCash;
    }

    public double getFromCard() {
        return this.fromCard;
    }

    public void setFromCard(double fromCard) {
        this.fromCard = fromCard;
    }

    public double getFromDocCheck() {
        return this.fromDocCheck;
    }

    public void setFromDocCheck(double fromDocCheck) {
        this.fromDocCheck = fromDocCheck;
    }

    public double getFromInvoice() {
        return this.fromInvoice;
    }

    public void setFromInvoice(double fromInvoice) {
        this.fromInvoice = fromInvoice;
    }

    public double getFromCombined() {
        return this.fromCombined;
    }

    public void setFromCombined(double fromCombined) {
        this.fromCombined = fromCombined;
    }

    public double getCashCombined() {
        return this.cashCombined;
    }

    public void setCashCombined(double cashCombined) {
        this.cashCombined = cashCombined;
    }

    public double getCardCombined() {
        return this.cardCombined;
    }

    public void setCardCombined(double cardCombined) {
        this.cardCombined = cardCombined;
    }

    public double getCheckCombined() {
        return this.checkCombined;
    }

    public void setCheckCombined(double checkCombined) {
        this.checkCombined = checkCombined;
    }

    public double getNI() {
        return this.NI;
    }

    public void setNI(double nI) {
        this.NI = nI;
    }

    public static ObservableList<SalesReportByDays> getRevenues(ScreensController controller, Date dateFrom, Date dateTo) {
        Connection connection = controller.getSettings().getConnection();
        ObservableList revenuesList = FXCollections.observableArrayList();
        String query = " SELECT d.DocumentID, d.DocumentTypeID, CAST(d.Date AS DATE) AS Date, SUM(d.SumWithDiscount) AS Revenue,\r\n(SELECT coalesce(SUM(dp.Paid),0) \r\nfrom document d1 \r\nJOIN documentpayment dp ON d1.DocumentID = dp.DocumentID\r\nWHERE dp.PaymentMethodID = 1 AND  d1.DocumentTypeID =3  AND d1.WorkDayID =d.WorkDayID) AS Cash,\r\n (SELECT coalesce(SUM(dp.Paid),0) \r\nfrom document d1 \r\nJOIN documentpayment dp ON d1.DocumentID = dp.DocumentID\r\nWHERE dp.PaymentMethodID = 2 AND  d1.DocumentTypeID =3  AND d1.WorkDayID =d.WorkDayID) AS Card, \r\n(SELECT coalesce(SUM(dp.Paid),0) \r\nfrom document d1 \r\nJOIN documentpayment dp ON d1.DocumentID = dp.DocumentID\r\nWHERE dp.PaymentMethodID = 3 AND  d1.DocumentTypeID =3  AND d1.WorkDayID =d.WorkDayID) AS docCheck, \r\n (SELECT coalesce(SUM(dp.Paid),0) \r\nfrom document d1 \r\nJOIN documentpayment dp ON d1.DocumentID = dp.DocumentID\r\nWHERE dp.PaymentMethodID = 5 AND  d1.DocumentTypeID =3  AND d1.WorkDayID =d.WorkDayID) AS Invoice,(SELECT ROUND((coalesce(SUM(dd2.Quantity * dd2.Price),0) ),2)  FROM document d2 \r\nJOIN documentdetails dd2 ON d2.DocumentID = dd2.DocumentID\r\nWHERE d2.DocumentTypeID = 22\r\nAND CAST(d2.Date AS DATE) = CAST(d.Date AS DATE)) AS NI, \r\n(SELECT COALESCE(SUM(d1.SumWithDiscount),0) from document d1 WHERE d1.PaymentMethodID = 6 AND d1.DocumentTypeID =3  AND d1.WorkDayID = d.WorkDayID ) AS Combined,\r\n(SELECT COALESCE(sum(dp.paid),0)  AS paid FROM  documentpayment dp JOIN document d1 ON dp.DocumentID = d1.DocumentID\r\nWHERE dp.PaymentMethodID = 1 AND d1.WorkDayID = d.WorkDayID AND d1.PaymentMethodID = 6  ) AS cashCombined,\r\n(SELECT COALESCE(sum(dp.paid),0)  AS paid FROM  documentpayment dp JOIN document d1 ON dp.DocumentID = d1.DocumentID\r\nWHERE dp.PaymentMethodID = 2 AND d1.WorkDayID = d.WorkDayID AND d1.PaymentMethodID = 6  ) AS cardCombined,\r\n(SELECT COALESCE(sum(dp.paid),0)  AS paid FROM  documentpayment dp JOIN document d1 ON dp.DocumentID = d1.DocumentID\r\nWHERE dp.PaymentMethodID = 3 AND d1.WorkDayID = d.WorkDayID AND d1.PaymentMethodID = 6  ) AS checkCombined\r\nFROM document d WHERE d.DocumentTypeID = 3 \r\nAND d.workdayId >=(SELECT COALESCE(\r\n\t(SELECT wd.WorkDayID FROM workday wd WHERE wd.Date = ?),\r\n\t(SELECT wd1.WorkdayId FROM workday wd1 order BY wd1.WorkDayID LIMIT 1)) AS idfrom)\r\nAND d.workdayId <= (SELECT COALESCE(\r\n\t(SELECT wd.WorkDayID FROM workday wd WHERE wd.Date = ?),\r\n\t(SELECT wd1.WorkdayId FROM workday wd1 order BY wd1.WorkDayID DESC LIMIT 1)) AS idfrom)\r\nGROUP BY d.Workdayid";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDate(1, new java.sql.Date(dateFrom.getTime()));
            ps.setDate(2, new java.sql.Date(dateTo.getTime()));
            ResultSet rs = ps.executeQuery();
            System.out.println(ps);
            while (rs.next()) {
                SalesReportByDays reportByDays = new SalesReportByDays();
                reportByDays.setRevenueDate(rs.getDate("DATE"));
                reportByDays.setRevenue(rs.getDouble("Revenue"));
                reportByDays.setFromCash(rs.getDouble("Cash"));
                reportByDays.setFromCard(rs.getDouble("Card"));
                reportByDays.setFromDocCheck(rs.getDouble("docCheck"));
                reportByDays.setFromInvoice(rs.getDouble("Invoice"));
                reportByDays.setFromCombined(rs.getDouble("Combined"));
                reportByDays.setCashCombined(rs.getDouble("cashCombined"));
                reportByDays.setCardCombined(rs.getDouble("cardCombined"));
                reportByDays.setCheckCombined(rs.getDouble("checkCombined"));
                reportByDays.setNI(rs.getDouble("NI"));
                revenuesList.add((Object)reportByDays);
            }
            return revenuesList;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

