/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WorkDay;

public class ProdatiArtikli {
    private String code;
    private String barCode;
    private String name;
    private double quantity;
    private double price;
    private double discount;
    private double priceWithDiscount;
    private double value;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getBarCode() {
        return this.barCode;
    }

    public void setBarCode(String barCode) {
        this.barCode = barCode;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public double getDiscount() {
        return this.discount;
    }

    public void setDiscount(double discount) {
        this.discount = discount;
    }

    public double getPriceWithDiscount() {
        return this.priceWithDiscount;
    }

    public void setPriceWithDiscount(double priceWithDiscount) {
        this.priceWithDiscount = priceWithDiscount;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public static ObservableList<ProdatiArtikli> getTableList(ScreensController controller, int objectId, int posID, LocalDate dateFrom, LocalDate dateTo, String vremeOd, String vremeDo, boolean vremeUkljucueno) {
        ObservableList list = FXCollections.observableArrayList();
        try {
            LocalDateTime pocetakdana = Settings.LocalDateTimefromDate(WorkDay.getFromDbByDate(dateFrom, controller.getSettings().getConnection()).getDateFrom());
            LocalDateTime krajDana = WorkDay.getDateToForDep(dateTo, Department.getByPOS(controller.getPointOfSale(), controller.getSettings().getConnection()).getDepartmentID(), controller.getSettings().getConnection());
            String datumVreme = "AND d.Date BETWEEN ? AND ? ";
            if (vremeUkljucueno) {
                datumVreme = "AND DATE(d.Date) BETWEEN DATE(?) AND DATE(?)\r\nAND TIME(d.Date) BETWEEN '" + vremeOd + "' AND '" + vremeDo + "' ";
            }
            String query = "SELECT \r\np.ProductID,\r\np.Code, \r\nbc.BarCode, \r\np.ShortName, \r\nSUM(dd.Quantity) AS Quantity, \r\ndd.Price,\r\ndd.Discount,\r\ndd.PriceWithDiscount,\r\nSUM(dd.PriceWithDiscount * dd.Quantity) AS Value,\r\ndd.sysDTCreated\r\nFROM documentdetails dd\r\nLEFT JOIN document d ON d.DocumentID = dd.DocumentID\r\nLEFT JOIN product p ON p.ProductID = dd.ProductID\r\nLEFT JOIN barcode bc ON bc.ProductID = p.ProductID\r\nWHERE d.DocumentTypeID = 3 \r\nAND d.DocumentStatusID NOT IN (SELECT ds.DocumentStatusID FROM documentstatus ds WHERE ds.Name = 'Storniran')\r\nAND ((  ? = -1 ) OR ((SELECT ps.ObjectID FROM pointofsale ps WHERE ps.PointOfSaleID = d.PointOfSaleID) =  ? )) \r\nAND ((  ?  = -1 ) OR (d.PointOfSaleID =  ?  ))\r\n" + datumVreme + "AND (p.Code LIKE  '%%'  OR bc.BarCode LIKE  '%%' )\r\nGROUP BY p.ProductID, dd.PriceWithDiscount\r\nORDER BY p.ProductID ASC";
            PreparedStatement pStatement = controller.getSettings().getConnection().prepareStatement(query);
            pStatement.setInt(1, objectId);
            pStatement.setInt(2, objectId);
            pStatement.setInt(3, posID);
            pStatement.setInt(4, posID);
            if (vremeUkljucueno) {
                pStatement.setTimestamp(5, Timestamp.valueOf(pocetakdana));
                pStatement.setTimestamp(6, Timestamp.valueOf(krajDana));
            } else {
                pStatement.setTimestamp(5, Timestamp.valueOf(pocetakdana));
                pStatement.setTimestamp(6, Timestamp.valueOf(krajDana));
            }
            System.out.println(pStatement);
            ResultSet rSet = pStatement.executeQuery();
            while (rSet.next()) {
                ProdatiArtikli pArtikli = new ProdatiArtikli();
                pArtikli.setCode(rSet.getString("Code"));
                pArtikli.setBarCode(rSet.getString("BarCode"));
                list.add((Object)pArtikli);
            }
            return list;
        }
        catch (SQLException e) {
            return null;
        }
    }
}

