/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.Unit;
import rs.petcom.master.dal.Vat;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.Prijemnica;
import rs.petcom.master.dal.product.Product;

public class PrijemnicaDetailes {
    private long documentDetailsID;
    private long documentID;
    private long productID;
    private double priceWithDiscount;
    private double price;
    private String productCode;
    private String productName;
    private Product product;
    private double quantity;
    private double priceWithoutVatAndDiscount;
    private double sum;
    private double discount;
    private double sumWithDiscount;
    private double vat;
    private double sumWithVat;
    private double sellPrice;
    private double margin;
    private LocalDateTime dateEdit;
    private LocalDateTime dateCreate;
    private double newSellPrice;
    private double purchasePrice;
    private double sumPurchasePrice;
    private double purchasePriceWithoutRabat;
    private String jedinicaMere;

    public long getDocumentDetailsID() {
        return this.documentDetailsID;
    }

    public void setDocumentDetailsID(long documentDetailsID) {
        this.documentDetailsID = documentDetailsID;
    }

    public long getDocumentID() {
        return this.documentID;
    }

    public void setDocumentID(long documentID) {
        this.documentID = documentID;
    }

    public long getProductID() {
        return this.productID;
    }

    public void setProductID(long productID) {
        this.productID = productID;
    }

    public double getPriceWithDiscount() {
        return this.priceWithDiscount;
    }

    public void setPriceWithDiscount(double priceWithDiscount) {
        this.priceWithDiscount = priceWithDiscount;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public void setProductCode(String productCode) {
        this.productCode = productCode;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setProductName(String productName) {
        this.productName = productName;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public double getPriceWithoutVatAndDiscount() {
        return this.priceWithoutVatAndDiscount;
    }

    public void setPriceWithoutVatAndDiscount(double priceWithoutVatAndDiscount) {
        this.priceWithoutVatAndDiscount = priceWithoutVatAndDiscount;
    }

    public double getSum() {
        return this.sum;
    }

    public void setSum(double sum) {
        this.sum = sum;
    }

    public double getDiscount() {
        return this.discount;
    }

    public void setDiscount(double discount) {
        this.discount = discount;
    }

    public double getSumWithDiscount() {
        return this.sumWithDiscount;
    }

    public void setSumWithDiscount(double sumWithDiscount) {
        this.sumWithDiscount = sumWithDiscount;
    }

    public double getVat() {
        return this.vat;
    }

    public void setVat(double vat) {
        this.vat = vat;
    }

    public double getSumWithVat() {
        return this.sumWithVat;
    }

    public void setSumWithVat(double sumWithVat) {
        this.sumWithVat = sumWithVat;
    }

    public double getSellPrice() {
        return this.sellPrice;
    }

    public void setSellPrice(double sellPrice) {
        this.sellPrice = sellPrice;
    }

    public double getMargin() {
        return this.margin;
    }

    public void setMargin(double margin) {
        this.margin = margin;
    }

    public LocalDateTime getDateEdit() {
        return this.dateEdit;
    }

    public void setDateEdit(LocalDateTime dateEdit) {
        this.dateEdit = dateEdit;
    }

    public LocalDateTime getDateCreate() {
        return this.dateCreate;
    }

    public void setDateCreate(LocalDateTime dateCreate) {
        this.dateCreate = dateCreate;
    }

    public double getNewSellPrice() {
        return this.newSellPrice;
    }

    public void setNewSellPrice(double newSellPrice) {
        this.newSellPrice = newSellPrice;
    }

    public double getPurchasePrice() {
        return this.purchasePrice;
    }

    public void setPurchasePrice(double purchasePrice) {
        this.purchasePrice = purchasePrice;
    }

    public double getSumPurchasePrice() {
        return this.sumPurchasePrice;
    }

    public void setSumPurchasePrice(double sumPurchasePrice) {
        this.sumPurchasePrice = sumPurchasePrice;
    }

    public double getPurchasePriceWithoutRabat() {
        return this.purchasePriceWithoutRabat;
    }

    public void setPurchasePriceWithoutRabat(double purchasePriceWithoutRabat) {
        this.purchasePriceWithoutRabat = purchasePriceWithoutRabat;
    }

    public String getJedinicaMere() {
        return this.jedinicaMere;
    }

    public void setJedinicaMere(String jedinicaMere) {
        this.jedinicaMere = jedinicaMere;
    }

    public static ObservableList<PrijemnicaDetailes> getlist(Prijemnica prijemnica, long departmentID, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT d.*, p.*, doc.Date, doc.DeliveryDate, doc.Sum, doc.SumWithDiscount FROM documentdetails d LEFT JOIN document doc ON doc.DocumentID = d.DocumentID LEFT JOIN product p ON p.ProductID = d.ProductID WHERE d.DocumentID = ? ORDER BY d.DocumentDetailsID";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setLong(1, prijemnica.getDocumentID());
            System.out.println(ps);
            ResultSet resultSet = ps.executeQuery();
            while (resultSet.next()) {
                PrijemnicaDetailes pd = new PrijemnicaDetailes();
                pd.documentDetailsID = resultSet.getLong("DocumentDetailsID");
                pd.documentID = resultSet.getLong("DocumentID");
                pd.productID = resultSet.getLong("ProductID");
                pd.productCode = resultSet.getString("Code");
                pd.productName = resultSet.getString("Name");
                pd.quantity = resultSet.getDouble("Quantity");
                pd.price = resultSet.getDouble("Price");
                pd.discount = resultSet.getDouble("Discount");
                pd.priceWithDiscount = resultSet.getDouble("PriceWithDiscount");
                pd.purchasePrice = resultSet.getDouble("PurchacePrice");
                pd.purchasePriceWithoutRabat = pd.getPurchasePrice() + pd.getPurchasePrice() * pd.getDiscount() / (100.0 - pd.getDiscount());
                pd.dateCreate = resultSet.getTimestamp("DeliveryDate").toLocalDateTime();
                try {
                    pd.dateEdit = resultSet.getTimestamp("sysDTEdit").toLocalDateTime();
                }
                catch (NullPointerException e) {
                    pd.dateEdit = resultSet.getTimestamp("DeliveryDate").toLocalDateTime();
                }
                pd.product = Product.getByID(pd.productID, controller);
                pd.vat = Vat.getById(resultSet.getInt("d.VatID"), controller.getSettings().getConnection()).getValue();
                pd.product.setVatID(resultSet.getInt("d.VatID"));
                pd.setJedinicaMere(Unit.getUnitById(resultSet.getInt("UnitID"), controller.getSettings().getConnection()).getName());
                pd.sum = pd.purchasePriceWithoutRabat * pd.quantity;
                pd.sumWithDiscount = pd.purchasePrice * pd.quantity;
                pd.sumWithVat = pd.sumWithDiscount * pd.vat;
                if (resultSet.getDouble("NewPrice") == 0.0) {
                    pd.setSellPrice(pd.product.getCurrentPriceBeforeDatePrijemnica(Settings.DatefromLocalDateTime(pd.dateCreate), departmentID, controller.getSettings().getConnection()));
                } else {
                    pd.setSellPrice(resultSet.getDouble("NewPrice"));
                    pd.setNewSellPrice(resultSet.getDouble("NewPrice"));
                }
                pd.setMargin((pd.getNewSellPrice() - pd.getPriceWithDiscount()) / pd.getPriceWithDiscount() * 100.0);
                list.add((Object)pd);
            }
            ps.close();
            resultSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void delete(Connection connection) {
        DocumentDetails dd = new DocumentDetails();
        dd.setDocumentDetailsID(this.documentDetailsID);
        dd.delete(connection);
    }

    public void update(ScreensController controller) {
        DocumentDetails dd = DocumentDetails.getByID(this.documentDetailsID, controller.getSettings().getConnection());
        dd.setPrice(this.price);
        dd.setQuantity(this.quantity);
        dd.setPriceWithDiscount(this.priceWithDiscount);
        dd.update(controller);
    }

    public void updateWithDiscount(ScreensController controller) {
        DocumentDetails dd = DocumentDetails.getByID(this.documentDetailsID, controller.getSettings().getConnection());
        dd.setProductID(this.productID);
        dd.setDiscount(this.discount);
        dd.setPriceWithDiscount(Settings.roundOnTwo(this.purchasePrice * Vat.getById(dd.getVatID(), controller.getSettings().getConnection()).getValue()));
        dd.setPrice(Settings.roundOnTwo(dd.getPrice() * 100.0 / (100.0 - dd.getDiscount())));
        dd.setQuantity(this.quantity);
        dd.setNewPrice(this.sellPrice);
        dd.setPurchacePrice(this.purchasePrice);
        dd.update(controller);
    }

    public long insert(ScreensController controller) {
        long result;
        DocumentDetails dd = new DocumentDetails();
        dd.setDocumentID(this.documentID);
        dd.setProductID(this.productID);
        dd.setUnitID(this.product.getUnitID());
        dd.setVatID(this.product.getVatID());
        dd.setPrice(this.price);
        dd.setQuantity(this.quantity);
        dd.setPriceWithDiscount(this.priceWithDiscount);
        dd.setSysUserAddID(controller.getUser().getUserID());
        dd.setNewPrice(this.sellPrice);
        this.documentDetailsID = result = dd.insert(controller.getSettings().getConnection());
        return result;
    }

    public long insertWithDiscount(ScreensController controller) {
        long result;
        DocumentDetails dd = new DocumentDetails();
        dd.setDocumentID(this.documentID);
        dd.setProductID(this.productID);
        dd.setProduct(Product.getByID(this.productID, controller));
        dd.setUnitID(this.product.getUnitID());
        dd.setVatID(this.product.getVatID());
        dd.setDiscount(this.discount);
        dd.setPrice(this.price);
        dd.setQuantity(this.quantity);
        dd.setPriceWithDiscount(this.priceWithDiscount);
        dd.setSysUserAddID(controller.getUser().getUserID());
        dd.setNewPrice(this.newSellPrice);
        dd.setPurchacePrice(this.purchasePrice);
        this.documentDetailsID = result = dd.insert(controller.getSettings().getConnection());
        return result;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return "PrijemnicaDetailes [documentDetailsID=" + this.documentDetailsID + ", documentID=" + this.documentID + ", productID=" + this.productID + ", priceWithDiscount=" + this.priceWithDiscount + ", price=" + this.price + ", productCode=" + this.productCode + ", productName=" + this.productName + ", product=" + this.product + ", quantity=" + this.quantity + ", priceWithoutVatAndDiscount=" + this.priceWithoutVatAndDiscount + ", sum=" + this.sum + ", discount=" + this.discount + ", sumWithDiscount=" + this.sumWithDiscount + ", vat=" + this.vat + ", sumWithVat=" + this.sumWithVat + ", sellPrice=" + this.sellPrice + ", margin=" + this.margin + ", dateEdit=" + this.dateEdit + ", dateCreate=" + this.dateCreate + ", newSellPrice=" + this.newSellPrice + ", purchasePrice=" + this.purchasePrice + ", sumPurchasePrice=" + this.sumPurchasePrice + ", purchasePriceWithoutRabat=" + this.purchasePriceWithoutRabat + ", jedinicaMere=" + this.jedinicaMere + "]";
    }

    public void updatePrijemnica(Connection connection) {
        DocumentDetails dd = new DocumentDetails();
        dd.setDocumentDetailsID(this.documentDetailsID);
        dd.updateDocumentDitailsForPrijemnica(connection);
    }
}

