/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.SQLHelper;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.WarehouseCentral;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentStatus;
import rs.petcom.master.dal.document.PrijemnicaCentralniMagacinDetailes;
import rs.petcom.master.dal.person.Person;

public class PrijemnicaCentralniMagacin {
    private long DocumentID;
    private int WarehouseID;
    private int Number;
    private String ExternalNumber;
    private Date Date;
    private Date DeliveryDate;
    private Date PaymentDate;
    private Person dobavljac;
    private String Place;
    private DocumentStatus DocumentStatus;
    private String comment;
    private double sum;
    private double sumWithDiscount;
    private double DependentExpenses;

    public void setDependentExpenses(double dependentExpenses) {
        this.DependentExpenses = dependentExpenses;
    }

    public double getDependentExpenses() {
        return this.DependentExpenses;
    }

    public long getDocumentID() {
        return this.DocumentID;
    }

    public void setDocumentID(long documnetID) {
        this.DocumentID = documnetID;
    }

    public int getNumber() {
        return this.Number;
    }

    public void setNumber(int number) {
        this.Number = number;
    }

    public Date getDate() {
        return this.Date;
    }

    public void setDate(Date date) {
        this.Date = date;
    }

    public Person getDobavljac() {
        return this.dobavljac;
    }

    public void setDobavljac(Person dobavljac) {
        this.dobavljac = dobavljac;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getExternalNumber() {
        return this.ExternalNumber;
    }

    public void setExternalNumber(String externalNumber) {
        this.ExternalNumber = externalNumber;
    }

    public Date getDeliveryDate() {
        return this.DeliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.DeliveryDate = deliveryDate;
    }

    public Date getPaymentDate() {
        return this.PaymentDate;
    }

    public void setPaymentDate(Date paymentDate) {
        this.PaymentDate = paymentDate;
    }

    public String getPlace() {
        return this.Place;
    }

    public void setPlace(String place) {
        this.Place = place;
    }

    public DocumentStatus getDocumentStatus() {
        return this.DocumentStatus;
    }

    public void setDocumentStatus(DocumentStatus documentStatus) {
        this.DocumentStatus = documentStatus;
    }

    public void setSum(double sum) {
        this.sum = sum;
    }

    public void setSumWithDiscount(double sumWithDiscount) {
        this.sumWithDiscount = sumWithDiscount;
    }

    public int getWarehouseID() {
        return this.WarehouseID;
    }

    public void setWarehouseID(int warehouseID) {
        this.WarehouseID = warehouseID;
    }

    public void delete(Connection connection) throws SQLException {
        String query = "delete from document where DocumentID = ?";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setLong(1, this.DocumentID);
        ps.executeUpdate();
        ps.close();
    }

    public long insert(ScreensController controller) throws SQLException {
        Document document = new Document();
        document.setDocumentTypeID(1);
        document.setDocumentStatusID(1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        document.setYear(cal.get(1));
        document.setDate(this.Date);
        document.setDeliveryDate(this.DeliveryDate);
        document.setCurrencyDate(this.PaymentDate);
        document.setNumber(this.Number);
        document.setSysUserAddID(controller.getUser().getUserID());
        document.setWarehouseID(this.WarehouseID);
        document.setNote(this.comment);
        document.setPersonID(this.dobavljac.getPersonID());
        document.setExternalNumber(this.ExternalNumber);
        document.setDependentExpenses(this.DependentExpenses);
        document.setSum(this.sum);
        this.DocumentID = document.insert(controller);
        return document.getDocumentID();
    }

    public void update(ScreensController controller) {
        Document document = Document.getByID(this.DocumentID, controller.getSettings().getConnection());
        document.setDate(this.Date);
        document.setDeliveryDate(this.DeliveryDate);
        document.setCurrencyDate(this.PaymentDate);
        document.setPersonID(this.dobavljac.getPersonID());
        document.setDocumentStatusID(this.DocumentStatus.getDocumentStatusID());
        document.setPlace(this.Place);
        document.setNote(this.comment);
        document.setSysUserAddID(controller.getUser().getUserID());
        document.setDependentExpenses(this.DependentExpenses);
        document.setSum(this.sum);
        try {
            document.update(controller);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static boolean exists(String externalNumber, Connection connection) {
        boolean result = false;
        String query = "select count(DocumentID)   from document  where DocumentTypeID = 1    and ExternalNumber = '" + externalNumber + "'";
        result = SQLHelper.QueryToInt(query, connection, 0) > 0;
        return result;
    }

    public static ObservableList<PrijemnicaCentralniMagacin> getList(Date dateFrom, Date dateTo, WarehouseCentral warehouse, long selectedPerson, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select *   from document d where DocumentTypeID = 1   and DATE(Date) >= ?    and Date < DATE_ADD(?,INTERVAL 1 DAY)    and WarehouseID = ?   and (? = -1 or d.PersonID = ?) order by Date desc";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setTimestamp(1, new Timestamp(dateFrom.getTime()));
            ps.setTimestamp(2, new Timestamp(dateTo.getTime()));
            ps.setInt(3, warehouse.getWarehouseId());
            ps.setLong(4, selectedPerson);
            ps.setLong(5, selectedPerson);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PrijemnicaCentralniMagacin p = new PrijemnicaCentralniMagacin();
                p.DocumentID = rs.getLong("DocumentID");
                p.Number = rs.getInt("Number");
                p.Date = rs.getTimestamp("Date");
                p.DeliveryDate = rs.getTimestamp("DeliveryDate");
                p.PaymentDate = rs.getTimestamp("CurrencyDate");
                long personID = rs.getLong("PersonID");
                p.dobavljac = Person.getById(personID, controller);
                p.comment = rs.getString("Note");
                p.Place = rs.getString("Place");
                p.WarehouseID = rs.getInt("WarehouseID");
                p.ExternalNumber = rs.getString("ExternalNumber");
                p.DependentExpenses = rs.getDouble("DependentExpenses");
                list.add((Object)p);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void exportToXml(String fileName, ScreensController controller) throws FileNotFoundException, UnsupportedEncodingException, SQLException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        NumberFormat nf4 = Settings.getNumberFormat(4, false);
        WarehouseCentral warehouseCentral = WarehouseCentral.getByID(this.WarehouseID, controller.getSettings().getConnection());
        PrintWriter writer = new PrintWriter(fileName, "UTF-8");
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        writer.println("<Prijemnica>");
        writer.println("\t<PrijemnicaData>");
        writer.println("\t\t<PrijemnicaDataID>" + this.getDocumentID() + "</PrijemnicaDataID>");
        writer.println("\t\t<WarehouseCentralCode>" + warehouseCentral.getCode() + "</WarehouseCentralCode>");
        writer.println("\t\t<WarehouseCentralName>" + warehouseCentral.getName() + "</WarehouseCentralName>");
        writer.println("\t\t<Number>" + this.getNumber() + "</Number>");
        writer.println("\t\t<ExternalNumber>" + this.getExternalNumber() + "</ExternalNumber>");
        writer.println("\t\t<Date>" + sdf.format(this.getDate()) + "</Date>");
        writer.println("\t\t<DeliveryDate>" + sdf.format(this.getDeliveryDate()) + "</DeliveryDate>");
        writer.println("\t\t<PaymentDate>" + sdf.format(this.getPaymentDate()) + "</PaymentDate>");
        writer.println("\t\t<DobavljacCode>" + this.dobavljac.getCode() + "</DobavljacCode>");
        writer.println("\t\t<DobavljacName>" + this.dobavljac.getName() + "</DobavljacName>");
        writer.println("\t\t<DobavljacFirstName>" + this.dobavljac.getFirstName() + "</DobavljacFirstName>");
        writer.println("\t\t<DobavljacLastName>" + this.dobavljac.getLastName() + "</DobavljacLastName>");
        writer.println("\t\t<Place>" + this.Place + "</Place>");
        writer.println("\t\t<DocumentStatus>" + this.DocumentStatus + "</DocumentStatus>");
        writer.println("\t\t<Comment>" + this.comment + "</Comment>");
        writer.println("\t</PrijemnicaData>");
        writer.println("\t<PrijemnicaStavke>");
        for (PrijemnicaCentralniMagacinDetailes pd : PrijemnicaCentralniMagacinDetailes.getlist(this, warehouseCentral.getObjectId(), controller)) {
            writer.println("\t\t<Stavka>");
            writer.println("\t\t\t<ProductCode>" + pd.getProductCode() + "</ProductCode>");
            writer.println("\t\t\t<ProductName>" + pd.getProductName() + "</ProductName>");
            writer.println("\t\t\t<Quantity>" + nf4.format(pd.getQuantity()) + "</Quantity>");
            writer.println("\t\t\t<Price>" + nf4.format(pd.getPrice()) + "</Price>");
            writer.println("\t\t\t<Discount>" + nf4.format(pd.getDiscount()) + "</Discount>");
            writer.println("\t\t\t<PriceWithDiscount>" + nf4.format(pd.getPriceWithDiscount()) + "</PriceWithDiscount>");
            writer.println("\t\t</Stavka>");
        }
        writer.println("\t</PrijemnicaStavke>");
        writer.println("</Prijemnica>");
        writer.close();
    }
}

