/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Calendar;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.SQLHelper;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentStatus;
import rs.petcom.master.dal.document.PrijemnicaDetailes;
import rs.petcom.master.dal.person.Person;

public class Prijemnica {
    private long DocumentID;
    private int DepartmentID;
    private int Number;
    private String ExternalNumber;
    private java.util.Date Date;
    private java.util.Date CreateDate;
    private java.util.Date DeliveryDate;
    private java.util.Date PaymentDate;
    private Person dobavljac;
    private String Place;
    private DocumentStatus DocumentStatus;
    private String comment;
    private double sum;
    private double sumWithDiscount;
    private double discount;
    private double DependentExpenses;
    private boolean realized;
    private boolean locked;

    public void setDependentExpenses(double dependentExpenses) {
        this.DependentExpenses = dependentExpenses;
    }

    public double getDependentExpenses() {
        return this.DependentExpenses;
    }

    public long getDocumentID() {
        return this.DocumentID;
    }

    public void setDocumentID(long documnetID) {
        this.DocumentID = documnetID;
    }

    public int getDepartmentID() {
        return this.DepartmentID;
    }

    public void setDepartmentID(int departmnetID) {
        this.DepartmentID = departmnetID;
    }

    public int getNumber() {
        return this.Number;
    }

    public void setNumber(int number) {
        this.Number = number;
    }

    public java.util.Date getDate() {
        return this.Date;
    }

    public void setDate(java.util.Date date) {
        this.Date = date;
    }

    public java.util.Date getCreateDate() {
        return this.CreateDate;
    }

    public void setCreateDate(java.util.Date createDate) {
        this.CreateDate = createDate;
    }

    public Person getDobavljac() {
        return this.dobavljac;
    }

    public void setDobavljac(Person dobavljac) {
        this.dobavljac = dobavljac;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getExternalNumber() {
        return this.ExternalNumber;
    }

    public void setExternalNumber(String externalNumber) {
        this.ExternalNumber = externalNumber;
    }

    public java.util.Date getDeliveryDate() {
        return this.DeliveryDate;
    }

    public void setDeliveryDate(java.util.Date deliveryDate) {
        this.DeliveryDate = deliveryDate;
    }

    public java.util.Date getPaymentDate() {
        return this.PaymentDate;
    }

    public void setPaymentDate(java.util.Date paymentDate) {
        this.PaymentDate = paymentDate;
    }

    public String getPlace() {
        return this.Place;
    }

    public void setPlace(String place) {
        this.Place = place;
    }

    public DocumentStatus getDocumentStatus() {
        return this.DocumentStatus;
    }

    public void setDocumentStatus(DocumentStatus documentStatus) {
        this.DocumentStatus = documentStatus;
    }

    public void setSum(double sum) {
        this.sum = sum;
    }

    public double getSum() {
        return this.sum;
    }

    public void setSumWithDiscount(double sumWithDiscount) {
        this.sumWithDiscount = sumWithDiscount;
    }

    public double getSumWithDiscount() {
        return this.sumWithDiscount;
    }

    public double getDiscount() {
        return this.discount;
    }

    public void setDiscount(double discount) {
        this.discount = discount;
    }

    public boolean isRealized() {
        return this.realized;
    }

    public void setRealized(boolean realized) {
        this.realized = realized;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void delete(Connection connection) throws SQLException {
        String query = "delete from document where DocumentID = ?";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setLong(1, this.DocumentID);
        ps.executeUpdate();
        ps.close();
    }

    public long insert(ScreensController controller, java.util.Date d) throws SQLException {
        Document document = new Document();
        document.setDocumentTypeID(1);
        document.setDocumentStatusID(1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(d);
        document.setYear(cal.get(1));
        document.setDate(this.Date);
        document.setDeliveryDate(this.DeliveryDate);
        document.setCurrencyDate(this.PaymentDate);
        document.setNumber(this.Number);
        document.setSysUserAddID(controller.getUser().getUserID());
        document.setDepartmentID(this.DepartmentID);
        document.setNote(this.comment);
        document.setPersonID(this.dobavljac.getPersonID());
        document.setExternalNumber(this.ExternalNumber);
        document.setDependentExpenses(this.DependentExpenses);
        document.setSum(this.sum);
        document.setSumWithDiscount(this.sumWithDiscount);
        document.setDiscount(this.discount);
        document.setRealized(this.realized);
        this.DocumentID = document.insert(controller);
        document.setDocumentID(this.DocumentID);
        return this.DocumentID;
    }

    public long insertPovrat(ScreensController controller) throws SQLException {
        Document document = new Document();
        document.setDocumentTypeID(9);
        document.setDocumentStatusID(1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.Date);
        document.setYear(cal.get(1));
        document.setDate(this.Date);
        document.setDeliveryDate(this.DeliveryDate);
        document.setCurrencyDate(this.PaymentDate);
        document.setNumber(this.Number);
        document.setSysUserAddID(controller.getUser().getUserID());
        document.setDepartmentID(this.DepartmentID);
        document.setNote(this.comment);
        document.setPersonID(this.dobavljac.getPersonID());
        document.setExternalNumber(this.ExternalNumber);
        document.setDependentExpenses(this.DependentExpenses);
        document.setSum(this.sum);
        document.setSumWithDiscount(this.sumWithDiscount);
        document.setDiscount(this.discount);
        document.setRealized(this.realized);
        this.DocumentID = document.insert(controller);
        document.setDocumentID(this.DocumentID);
        return this.DocumentID;
    }

    public void update(ScreensController controller) {
        Document document = Document.getByID(this.DocumentID, controller.getSettings().getConnection());
        document.setDate(this.Date);
        document.setNumber(this.Number);
        document.setDeliveryDate(this.DeliveryDate);
        document.setCurrencyDate(this.PaymentDate);
        document.setPersonID(this.dobavljac.getPersonID());
        document.setDocumentStatusID(this.DocumentStatus.getDocumentStatusID());
        document.setExternalNumber(this.ExternalNumber);
        document.setPlace(this.Place);
        document.setNote(this.comment);
        document.setSysUserAddID(controller.getUser().getUserID());
        document.setDependentExpenses(this.DependentExpenses);
        document.setSum(this.sum);
        document.setSumWithDiscount(this.sumWithDiscount);
        document.setDiscount(this.discount);
        document.setRealized(this.realized);
        try {
            document.update(controller);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static boolean exists(String externalNumber, Person person, Connection connection) {
        boolean result = false;
        String query = "select count(DocumentID)   from document  where DocumentTypeID = 1    and ExternalNumber = '" + externalNumber + "' and PersonID = " + person.getPersonID();
        result = SQLHelper.QueryToIntPrijemnica(query, connection, 0) > 0;
        return result;
    }

    public boolean existsNumber(String number, java.util.Date datum, Connection connection) {
        boolean result = false;
        String query = "select count(d.DocumentID) as broj from document d where d.DocumentStatusID <>2 and d.DocumentTypeID = 1 and d.Number = ? and d.Year = YEAR(?)";
        if (this.DocumentID > -1L) {
            query = query + " and d.DocumentID not IN (" + this.DocumentID + ")";
        }
        try {
            PreparedStatement pStatement = connection.prepareStatement(query);
            pStatement.setString(1, number);
            pStatement.setDate(2, new Date(datum.getTime()));
            ResultSet rSet = pStatement.executeQuery();
            rSet.next();
            if (rSet.getInt(1) > 0) {
                result = true;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static ObservableList<Prijemnica> getList(java.util.Date dateFrom, java.util.Date dateTo, Department department, long selectedPerson, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select *   from document d where DocumentTypeID = 1 and d.DocumentStatusID <> 2    and DATE(DeliveryDate) >= ?    and DeliveryDate < DATE_ADD(?,INTERVAL 1 DAY)    and DepartmentID = ?   and (? = -1 or d.PersonID = ?) order by Number desc";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setTimestamp(1, new Timestamp(dateFrom.getTime()));
            ps.setTimestamp(2, new Timestamp(dateTo.getTime()));
            ps.setInt(3, department.getDepartmentID());
            ps.setLong(4, selectedPerson);
            ps.setLong(5, selectedPerson);
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Prijemnica p = new Prijemnica();
                p.DocumentID = rs.getLong("DocumentID");
                p.Number = rs.getInt("Number");
                p.Date = rs.getTimestamp("Date");
                p.CreateDate = rs.getTimestamp("sysDTCreated");
                p.DeliveryDate = rs.getTimestamp("DeliveryDate");
                p.PaymentDate = rs.getTimestamp("CurrencyDate");
                p.sum = rs.getDouble("Sum");
                p.sumWithDiscount = rs.getDouble("SumWithDiscount");
                long personID = rs.getLong("PersonID");
                p.dobavljac = Person.getById(personID, controller);
                p.comment = rs.getString("Note");
                p.Place = rs.getString("Place");
                p.DepartmentID = rs.getInt("DepartmentID");
                p.ExternalNumber = rs.getString("ExternalNumber");
                p.DependentExpenses = rs.getDouble("DependentExpenses");
                p.realized = rs.getBoolean("Realized");
                p.locked = rs.getBoolean("documentLocked");
                list.add((Object)p);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ObservableList<Prijemnica> getPovratList(java.util.Date dateFrom, java.util.Date dateTo, Department department, long selectedPerson, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select *   from document d where DocumentTypeID = 9   and DATE(Date) >= ?    and Date < DATE_ADD(?,INTERVAL 1 DAY)    and DepartmentID = ?   and (? = -1 or d.PersonID = ?) order by Number";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setTimestamp(1, new Timestamp(dateFrom.getTime()));
            ps.setTimestamp(2, new Timestamp(dateTo.getTime()));
            ps.setInt(3, department.getDepartmentID());
            ps.setLong(4, selectedPerson);
            ps.setLong(5, selectedPerson);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Prijemnica p = new Prijemnica();
                p.DocumentID = rs.getLong("DocumentID");
                p.Number = rs.getInt("Number");
                p.Date = rs.getTimestamp("Date");
                p.CreateDate = rs.getTimestamp("sysDTCreated");
                p.DeliveryDate = rs.getTimestamp("DeliveryDate");
                p.PaymentDate = rs.getTimestamp("CurrencyDate");
                p.sum = rs.getDouble("Sum");
                p.sumWithDiscount = rs.getDouble("SumWithDiscount");
                long personID = rs.getLong("PersonID");
                p.dobavljac = Person.getById(personID, controller);
                p.comment = rs.getString("Note");
                p.Place = rs.getString("Place");
                p.DepartmentID = rs.getInt("DepartmentID");
                p.ExternalNumber = rs.getString("ExternalNumber");
                p.DependentExpenses = rs.getDouble("DependentExpenses");
                p.realized = rs.getBoolean("Realized");
                p.locked = rs.getBoolean("documentLocked");
                list.add((Object)p);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void exportToXml(String fileName, ScreensController controller) throws FileNotFoundException, UnsupportedEncodingException, SQLException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        NumberFormat nf4 = Settings.getNumberFormat(4, false);
        Department department = Department.getById(this.DepartmentID, controller.getSettings().getConnection());
        PrintWriter writer = new PrintWriter(fileName, "UTF-8");
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        writer.println("<Prijemnica>");
        writer.println("\t<PrijemnicaData>");
        writer.println("\t\t<PrijemnicaDataID>" + this.getDocumentID() + "</PrijemnicaDataID>");
        writer.println("\t\t<DepartmentCode>" + department.getCode() + "</DepartmentCode>");
        writer.println("\t\t<DepartmentName>" + department.getName() + "</DepartmentName>");
        writer.println("\t\t<Number>" + this.getNumber() + "</Number>");
        writer.println("\t\t<ExternalNumber>" + this.getExternalNumber() + "</ExternalNumber>");
        writer.println("\t\t<Date>" + sdf.format(this.getDate()) + "</Date>");
        writer.println("\t\t<DeliveryDate>" + sdf.format(this.getDeliveryDate()) + "</DeliveryDate>");
        writer.println("\t\t<PaymentDate>" + sdf.format(this.getPaymentDate()) + "</PaymentDate>");
        writer.println("\t\t<DobavljacCode>" + this.dobavljac.getCode() + "</DobavljacCode>");
        writer.println("\t\t<DobavljacName>" + this.dobavljac.getName() + "</DobavljacName>");
        writer.println("\t\t<DobavljacFirstName>" + this.dobavljac.getFirstName() + "</DobavljacFirstName>");
        writer.println("\t\t<DobavljacLastName>" + this.dobavljac.getLastName() + "</DobavljacLastName>");
        writer.println("\t\t<Place>" + this.Place + "</Place>");
        writer.println("\t\t<DocumentStatus>" + this.DocumentStatus + "</DocumentStatus>");
        writer.println("\t\t<Comment>" + this.comment + "</Comment>");
        writer.println("\t</PrijemnicaData>");
        writer.println("\t<PrijemnicaStavke>");
        for (PrijemnicaDetailes pd : PrijemnicaDetailes.getlist(this, this.DepartmentID, controller)) {
            writer.println("\t\t<Stavka>");
            writer.println("\t\t\t<ProductCode>" + pd.getProductCode() + "</ProductCode>");
            writer.println("\t\t\t<ProductName>" + pd.getProductName() + "</ProductName>");
            writer.println("\t\t\t<Quantity>" + nf4.format(pd.getQuantity()) + "</Quantity>");
            writer.println("\t\t\t<Price>" + nf4.format(pd.getPrice()) + "</Price>");
            writer.println("\t\t\t<Discount>" + nf4.format(pd.getDiscount()) + "</Discount>");
            writer.println("\t\t\t<PriceWithDiscount>" + nf4.format(pd.getPriceWithDiscount()) + "</PriceWithDiscount>");
            writer.println("\t\t</Stavka>");
        }
        writer.println("\t</PrijemnicaStavke>");
        writer.println("</Prijemnica>");
        writer.close();
    }

    public static long getIdForInvoice(ScreensController controller, long productId, LocalDateTime d) {
        String query = "SELECT d.DocumentID as id, dd.ProductID FROM document d JOIN documentdetails dd ON d.DocumentID=dd.DocumentID WHERE d.DocumentTypeID = 1 AND dd.ProductID =? AND CAST(d.DeliveryDate AS DATE) = CAST(? AS DATE) ";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setLong(1, productId);
            ps.setTimestamp(2, Timestamp.valueOf(d));
            ResultSet rSet = ps.executeQuery();
            System.out.println(ps + "Nesaaa");
            if (rSet.next()) {
                return rSet.getLong("id");
            }
            return 0L;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public String toString() {
        return "Prijemnica [DocumentID=" + this.DocumentID + ", DepartmentID=" + this.DepartmentID + ", Number=" + this.Number + ", ExternalNumber=" + this.ExternalNumber + ", Date=" + this.Date + ", CreateDate=" + this.CreateDate + ", DeliveryDate=" + this.DeliveryDate + ", PaymentDate=" + this.PaymentDate + ", dobavljac=" + this.dobavljac + ", Place=" + this.Place + ", DocumentStatus=" + this.DocumentStatus + ", comment=" + this.comment + ", sum=" + this.sum + ", sumWithDiscount=" + this.sumWithDiscount + ", discount=" + this.discount + ", DependentExpenses=" + this.DependentExpenses + ", realized=" + this.realized + ", locked=" + this.locked + "]";
    }

    public void updateDocument(Connection connection) throws SQLException {
        String query = "update document set DocumentStatusID = 2 where DocumentID = ?";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setLong(1, this.DocumentID);
        ps.executeUpdate();
        ps.close();
    }
}

