/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.Presifriranje;
import rs.petcom.master.dal.product.Product;

public class PresifriranjeDetailes {
    long PresifriranjeDetailesID;
    long PresifriranjeID;
    long ProductID;
    String ProductCode;
    String ProductName;
    double Quantity;

    public PresifriranjeDetailes() {
    }

    public PresifriranjeDetailes(long PresifriranjeDetailesID, long PresifriranjeID, long ProductID, String ProductCode, String ProductName, double Quantity) {
        this.PresifriranjeDetailesID = PresifriranjeDetailesID;
        this.PresifriranjeID = PresifriranjeID;
        this.ProductID = ProductID;
        this.ProductCode = ProductCode;
        this.ProductName = ProductName;
        this.Quantity = Quantity;
    }

    public long getPresifriranjeDetailesID() {
        return this.PresifriranjeDetailesID;
    }

    public void setSravnjenjePoPopisuDetailesID(long sravnjenjePoPopisuDetailesID) {
        this.PresifriranjeDetailesID = sravnjenjePoPopisuDetailesID;
    }

    public long getPresifriranjeID() {
        return this.PresifriranjeID;
    }

    public void setPresifriranjeID(long PresifriranjeID) {
        this.PresifriranjeID = PresifriranjeID;
    }

    public long getProductID() {
        return this.ProductID;
    }

    public void setProductID(long productID) {
        this.ProductID = productID;
    }

    public String getProductCode() {
        return this.ProductCode;
    }

    public void setProductCode(String productCode) {
        this.ProductCode = productCode;
    }

    public String getProductName() {
        return this.ProductName;
    }

    public void setProductName(String productName) {
        this.ProductName = productName;
    }

    public double getQuantity() {
        return this.Quantity;
    }

    public void setQuantity(double Quantity) {
        this.Quantity = Quantity;
    }

    public static ObservableList<PresifriranjeDetailes> getList(Presifriranje presifriranje, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select \td.DocumentDetailsID,\td.DocumentID,\td.ProductID,\tp.Code,\tp.Name,\tQuantity  from documentdetails d  left join product p on p.ProductID = d.ProductID where DocumentID = ? order by p.Code";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            if (presifriranje.getDocumentID() > 0L) {
                ps.setLong(1, presifriranje.getDocumentID());
                ResultSet rs = ps.executeQuery();
                while (rs.next()) {
                    list.add((Object)new PresifriranjeDetailes(rs.getLong("DocumentDetailsID"), rs.getLong("DocumentID"), rs.getLong("ProductID"), rs.getString("Code"), rs.getString("Name"), rs.getDouble("Quantity")));
                }
                ps.close();
                rs.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void delete(Connection connection) {
        DocumentDetails dd = new DocumentDetails();
        dd.setDocumentDetailsID(this.PresifriranjeDetailesID);
        dd.delete(connection);
    }

    public void update(ScreensController controller) {
        DocumentDetails dd = DocumentDetails.getByID(this.PresifriranjeDetailesID, controller.getSettings().getConnection());
        dd.setQuantity(this.Quantity);
        dd.update(controller);
    }

    public long insert(ScreensController controller) {
        long result;
        Product p = Product.getByID(this.ProductID, controller);
        DocumentDetails dd = new DocumentDetails();
        dd.setDocumentID(this.PresifriranjeID);
        dd.setProductID(this.ProductID);
        dd.setUnitID(p.getUnitID());
        dd.setVatID(p.getVatID());
        dd.setQuantity(this.Quantity);
        dd.setSysUserAddID(controller.getUser().getUserID());
        dd.setProduct(p);
        this.PresifriranjeDetailesID = result = dd.insert(controller.getSettings().getConnection());
        return result;
    }
}

