/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.PresifriranjeDetailes;

public class Presifriranje {
    long DocumentID;
    int Number;
    Date Date;
    int DepartmentID;
    String Note;

    public Presifriranje(long DocumentID, int Number2, Date Date2, int DepartmentID, String Note) {
        this.DocumentID = DocumentID;
        this.Number = Number2;
        this.Date = Date2;
        this.DepartmentID = DepartmentID;
        this.Note = Note;
    }

    public long getDocumentID() {
        return this.DocumentID;
    }

    public void setDocumentID(long documentID) {
        this.DocumentID = documentID;
    }

    public int getNumber() {
        return this.Number;
    }

    public void setNumber(int number) {
        this.Number = number;
    }

    public Date getDate() {
        return this.Date;
    }

    public void setDate(Date date) {
        this.Date = date;
    }

    public int getDepartmentID() {
        return this.DepartmentID;
    }

    public void setDepartmentID(int departmentID) {
        this.DepartmentID = departmentID;
    }

    public String getNote() {
        return this.Note;
    }

    public void setNote(String note) {
        this.Note = note;
    }

    public static ObservableList<Presifriranje> getlist(Department department, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select d.DocumentID,d.Date,d.Number,d.DepartmentID, d.Note  from document d  where d.DocumentTypeID = 19   and d.DepartmentID = ? order by d.Date desc, d.Number desc";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, department.getDepartmentID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                list.add((Object)new Presifriranje(rs.getLong("DocumentID"), rs.getInt("Number"), new Date(rs.getTimestamp("Date").getTime()), rs.getInt("DepartmentID"), rs.getString("Note")));
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public long insert(ScreensController controller) throws SQLException {
        Department department = Department.getById(this.getDepartmentID(), controller.getSettings().getConnection());
        Document document = new Document();
        document.setDocumentTypeID(19);
        document.setDocumentStatusID(1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        document.setYear(cal.get(1));
        document.setDate(this.Date);
        document.setNumber(Document.getNextNumber(19, department, controller, LocalDate.now()));
        document.setSysUserAddID(controller.getUser().getUserID());
        document.setDepartmentID(this.DepartmentID);
        document.setNote(this.Note);
        this.DocumentID = document.insert(controller);
        return document.getDocumentID();
    }

    public void update(ScreensController controller) {
        Document document = Document.getByID(this.DocumentID, controller.getSettings().getConnection());
        document.setDocumentTypeID(19);
        document.setDocumentStatusID(1);
        document.setDate(this.Date);
        document.setDepartmentID(this.DepartmentID);
        document.setNote(this.Note);
        try {
            document.update(controller);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(Connection connection) throws SQLException {
        Document d = Document.getByID(this.DocumentID, connection);
        DocumentDetails.deleteDetailes(d, connection);
        Document.delete(this.DocumentID, connection);
    }

    public void exportToXml(String fileName, Connection connection) throws FileNotFoundException, UnsupportedEncodingException, SQLException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        NumberFormat nf4 = Settings.getNumberFormat(4, false);
        Department department = Department.getById(this.DepartmentID, connection);
        PrintWriter writer = new PrintWriter(fileName, "UTF-8");
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        writer.println("<Presifravanje>");
        writer.println("\t<PresifravanjeData>");
        writer.println("\t\t<PresifravanjeDataID>" + this.getDocumentID() + "</PresifravanjeDataID>");
        writer.println("\t\t<DepartmentCode>" + department.getCode() + "</DepartmentCode>");
        writer.println("\t\t<DepartmentName>" + department.getName() + "</DepartmentName>");
        writer.println("\t\t<Number>" + this.getNumber() + "</Number>");
        writer.println("\t\t<Date>" + sdf.format(this.getDate()) + "</Date>");
        writer.println("\t\t<Comment>" + this.Note + "</Comment>");
        writer.println("\t</PresifravanjeData>");
        writer.println("\t<PresifravanjeStavke>");
        for (PresifriranjeDetailes pd : PresifriranjeDetailes.getList(this, connection)) {
            writer.println("\t\t<Stavka>");
            writer.println("\t\t\t<ProductCode>" + pd.getProductCode() + "</ProductCode>");
            writer.println("\t\t\t<ProductName>" + pd.getProductName() + "</ProductName>");
            writer.println("\t\t\t<Quantity>" + nf4.format(pd.getQuantity()) + "</Quantity>");
            writer.println("\t\t</Stavka>");
        }
        writer.println("\t</PresifravanjeStavke>");
        writer.println("</Presifravanje>");
        writer.close();
    }
}

