/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.SQLHelper;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentStatus;
import rs.petcom.master.dal.person.Person;

public class Povrat {
    private long DocumentID;
    private int DepartmentID;
    private int Number;
    private String ExternalNumber;
    private Date Date;
    private Date DeliveryDate;
    private Date PaymentDate;
    private Person dobavljac;
    private String Place;
    private DocumentStatus DocumentStatus;
    private String comment;

    public long getDocumentID() {
        return this.DocumentID;
    }

    public void setDocumentID(long documnetID) {
        this.DocumentID = documnetID;
    }

    public int getDepartmentID() {
        return this.DepartmentID;
    }

    public void setDepartmentID(int departmnetID) {
        this.DepartmentID = departmnetID;
    }

    public int getNumber() {
        return this.Number;
    }

    public void setNumber(int number) {
        this.Number = number;
    }

    public Date getDate() {
        return this.Date;
    }

    public void setDate(Date date) {
        this.Date = date;
    }

    public Person getDobavljac() {
        return this.dobavljac;
    }

    public void setDobavljac(Person dobavljac) {
        this.dobavljac = dobavljac;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getExternalNumber() {
        return this.ExternalNumber;
    }

    public void setExternalNumber(String externalNumber) {
        this.ExternalNumber = externalNumber;
    }

    public Date getDeliveryDate() {
        return this.DeliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.DeliveryDate = deliveryDate;
    }

    public Date getPaymentDate() {
        return this.PaymentDate;
    }

    public void setPaymentDate(Date paymentDate) {
        this.PaymentDate = paymentDate;
    }

    public String getPlace() {
        return this.Place;
    }

    public void setPlace(String place) {
        this.Place = place;
    }

    public DocumentStatus getDocumentStatus() {
        return this.DocumentStatus;
    }

    public void setDocumentStatus(DocumentStatus documentStatus) {
        this.DocumentStatus = documentStatus;
    }

    public void setSum(double sum) {
    }

    public void setSumWithDiscount(double sumWithDiscount) {
    }

    public void delete(Connection connection) throws SQLException {
        String query = "delete from document where DocumentID = ?";
        PreparedStatement ps = connection.prepareStatement(query);
        ps.setLong(1, this.DocumentID);
        ps.executeUpdate();
        ps.close();
    }

    public long insertPovrat(ScreensController controller) throws SQLException {
        Document document = new Document();
        document.setDocumentTypeID(9);
        document.setDocumentStatusID(1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        document.setYear(cal.get(1));
        document.setDate(this.Date);
        document.setDeliveryDate(this.DeliveryDate);
        document.setCurrencyDate(this.PaymentDate);
        document.setNumber(this.Number);
        document.setSysUserAddID(controller.getUser().getUserID());
        document.setDepartmentID(this.DepartmentID);
        try {
            document.setWorkDayID(WorkDay.getFromDb(controller.getPointOfSale(), controller.getSettings().getConnection()).getWorkDayID());
        }
        catch (NullPointerException e) {
            document.setWorkDayID(WorkDay.getByDate(controller.getSettings().getConnection()).getWorkDayID());
        }
        document.setNote(this.comment);
        document.setPersonID(this.dobavljac.getPersonID());
        document.setExternalNumber(this.ExternalNumber);
        this.DocumentID = document.insert(controller);
        return document.getDocumentID();
    }

    public void update(ScreensController controller) {
        Document document = Document.getByID(this.DocumentID, controller.getSettings().getConnection());
        document.setDate(this.Date);
        document.setDeliveryDate(this.DeliveryDate);
        document.setCurrencyDate(this.PaymentDate);
        document.setPersonID(this.dobavljac.getPersonID());
        document.setDocumentStatusID(this.DocumentStatus.getDocumentStatusID());
        document.setPlace(this.Place);
        document.setNote(this.comment);
        document.setSysUserAddID(controller.getUser().getUserID());
        try {
            document.update(controller);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static boolean exists(String externalNumber, ScreensController controller) {
        boolean result = false;
        String query = "select count(DocumentID)   from document  where DocumentTypeID = 9    and ExternalNumber = '" + externalNumber + "'";
        result = SQLHelper.QueryToInt(query, controller.getSettings().getConnection(), 0) > 0;
        return result;
    }

    public static ObservableList<Povrat> getList(Date dateFrom, Date dateTo, Department department, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select *   from document where DocumentTypeID = 9   and DATE(Date) >= ?    and Date < DATE_ADD(?,INTERVAL 1 DAY)    and DepartmentID = ? order by Date desc";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setTimestamp(1, new Timestamp(dateFrom.getTime()));
            ps.setTimestamp(2, new Timestamp(dateTo.getTime()));
            ps.setInt(3, department.getDepartmentID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Povrat p = new Povrat();
                p.DocumentID = rs.getLong("DocumentID");
                p.Number = rs.getInt("Number");
                p.Date = rs.getTimestamp("Date");
                p.DeliveryDate = rs.getTimestamp("DeliveryDate");
                p.PaymentDate = rs.getTimestamp("CurrencyDate");
                long personID = rs.getLong("PersonID");
                p.dobavljac = Person.getById(personID, controller);
                p.comment = rs.getString("Note");
                p.Place = rs.getString("Place");
                p.DepartmentID = rs.getInt("DepartmentID");
                p.ExternalNumber = rs.getString("ExternalNumber");
                list.add((Object)p);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void exportToXml(String fileName, Connection connection) throws FileNotFoundException, UnsupportedEncodingException, SQLException {
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        Department department = Department.getById(this.DepartmentID, connection);
        PrintWriter writer = new PrintWriter(fileName, "UTF-8");
        writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>");
        writer.println("<Prijemnica>");
        writer.println("\t<PrijemnicaData>");
        writer.println("\t\t<PrijemnicaDataID>" + this.getDocumentID() + "</PrijemnicaDataID>");
        writer.println("\t\t<DepartmentCode>" + department.getCode() + "</DepartmentCode>");
        writer.println("\t\t<DepartmentName>" + department.getName() + "</DepartmentName>");
        writer.println("\t\t<Number>" + this.getNumber() + "</Number>");
        writer.println("\t\t<ExternalNumber>" + this.getExternalNumber() + "</ExternalNumber>");
        writer.println("\t\t<Date>" + sdf.format(this.getDate()) + "</Date>");
        writer.println("\t\t<DeliveryDate>" + sdf.format(this.getDeliveryDate()) + "</DeliveryDate>");
        writer.println("\t\t<PaymentDate>" + sdf.format(this.getPaymentDate()) + "</PaymentDate>");
        writer.println("\t\t<DobavljacCode>" + this.dobavljac.getCode() + "</DobavljacCode>");
        writer.println("\t\t<DobavljacName>" + this.dobavljac.getName() + "</DobavljacName>");
        writer.println("\t\t<DobavljacFirstName>" + this.dobavljac.getFirstName() + "</DobavljacFirstName>");
        writer.println("\t\t<DobavljacLastName>" + this.dobavljac.getLastName() + "</DobavljacLastName>");
        writer.println("\t\t<Place>" + this.Place + "</Place>");
        writer.println("\t\t<DocumentStatus>" + this.DocumentStatus + "</DocumentStatus>");
        writer.println("\t\t<Comment>" + this.comment + "</Comment>");
        writer.println("\t</PrijemnicaData>");
        writer.println("\t<PrijemnicaStavke>");
        writer.println("\t</PrijemnicaStavke>");
        writer.println("</Prijemnica>");
        writer.close();
    }
}

