/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.Settings;
import rs.petcom.master.dal.User;
import rs.petcom.master.dal.WorkDay;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.Popis;
import rs.petcom.master.dal.product.Product;

public class PopisDetailes {
    long DocumentID;
    long PopisDetailesID;
    long tempPopisDetailesID;
    LocalDateTime dateTime;
    long Broj;
    long ProductID;
    String Barcode;
    String ProductName;
    Product product;
    int DepartmentID;
    double PocetnoStanje;
    double Ulazi;
    double Izlazi;
    double Prodaja;
    double Stanje;
    double PopisanaKolicina;
    double Cena;
    double RazlikaKolicina;
    double RazlikaFinansije;
    double Total;
    long UserID;
    String UserName;

    public PopisDetailes() {
    }

    public PopisDetailes(long popisDetailesID, Product product, double pocetnoStanje, double ulazi, double izlazi, double prodaja, double stanje, double popisanaKolicina, double cena, double razlikaKolicina, double razlikaFinansije, double total) {
        this.DocumentID = popisDetailesID;
        this.product = product;
        this.PocetnoStanje = pocetnoStanje;
        this.Ulazi = ulazi;
        this.Izlazi = izlazi;
        this.Prodaja = prodaja;
        this.Stanje = stanje;
        this.PopisanaKolicina = popisanaKolicina;
        this.Cena = cena;
        this.RazlikaKolicina = razlikaKolicina;
        this.RazlikaFinansije = razlikaFinansije;
        this.Total = total;
    }

    public void setPopisDetailesID(long popisDetailesID) {
        this.PopisDetailesID = popisDetailesID;
    }

    public long getPopisDetailesID() {
        return this.PopisDetailesID;
    }

    public void setDateTime(LocalDateTime dateTime) {
        this.dateTime = dateTime;
    }

    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public Product getProduct() {
        return this.product;
    }

    public String getProductName() {
        return this.ProductName;
    }

    public void setProductName(String productName) {
        this.ProductName = productName;
    }

    public double getPocetnoStanje() {
        return this.PocetnoStanje;
    }

    public void setPocetnoStanje(double pocetnoStanje) {
        this.PocetnoStanje = pocetnoStanje;
    }

    public void setBarcode(String barcode) {
        this.Barcode = barcode;
    }

    public String getBarcode() {
        return this.Barcode;
    }

    public void setUlazi(double ulazi) {
        this.Ulazi = ulazi;
    }

    public double getUlazi() {
        return this.Ulazi;
    }

    public void setIzlazi(double izlazi) {
        this.Izlazi = izlazi;
    }

    public double getIzlazi() {
        return this.Izlazi;
    }

    public void setProdaja(double prodaja) {
        this.Prodaja = prodaja;
    }

    public double getProdaja() {
        return this.Prodaja;
    }

    public void setStanje(double stanje) {
        this.Stanje = stanje;
    }

    public double getStanje() {
        return this.Stanje;
    }

    public void setPopisanaKolicina(double popisanaKolicina) {
        this.PopisanaKolicina = popisanaKolicina;
    }

    public double getPopisanaKolicina() {
        return this.PopisanaKolicina;
    }

    public void setCena(double cena) {
        this.Cena = cena;
    }

    public double getCena() {
        return this.Cena;
    }

    public void setRazlikaKolicina(double razlikaKolicina) {
        this.RazlikaKolicina = razlikaKolicina;
    }

    public double getRazlikaKolicina() {
        return this.RazlikaKolicina;
    }

    public void setRazlikaFinansije(double razlikaFinansije) {
        this.RazlikaFinansije = razlikaFinansije;
    }

    public double getRazlikaFinansije() {
        return this.RazlikaFinansije;
    }

    public void setBroj(long broj) {
        this.Broj = broj;
    }

    public long getBroj() {
        return this.Broj;
    }

    public void setDocumentID(long documentID) {
        this.DocumentID = documentID;
    }

    public long getDocumentID() {
        return this.DocumentID;
    }

    public void setProductID(long productID) {
        this.ProductID = productID;
    }

    public long getProductID() {
        return this.ProductID;
    }

    public int getDepartmentID() {
        return this.DepartmentID;
    }

    public void setDepartmentID(int departmentID) {
        this.DepartmentID = departmentID;
    }

    public void setTempPopisDetailesID(long tempPopisDetailesID) {
        this.tempPopisDetailesID = tempPopisDetailesID;
    }

    public long getTempPopisDetailesID() {
        return this.tempPopisDetailesID;
    }

    public void setUserID(long userID) {
        this.UserID = userID;
    }

    public long getUserID() {
        return this.UserID;
    }

    public double getTotal() {
        return this.Total;
    }

    public void setTotal(double total) {
        this.Total = total;
    }

    public void setUserName(String userName) {
        this.UserName = userName;
    }

    public String getUserName() {
        return this.UserName;
    }

    public void refreshPopis(Department department, ScreensController controller) throws SQLException {
        Product product = Product.getByID(this.getProductID(), controller);
        product.getCurrentPrice(1L, controller.getSettings().getConnection());
        this.setProduct(product);
        this.setBarcode(product.getBarcodeLast());
        this.setUserName(User.getUserByID(this.getUserID(), controller.getSettings().getConnection()).getUserName());
        this.setCena(product.getPrice());
        this.setProductName(product.getName());
        this.setRazlikaKolicina(this.getPopisanaKolicina() - this.getStanje());
        this.setRazlikaFinansije(this.getRazlikaKolicina() * this.getCena());
        this.setTotal(this.getCena() * this.getPopisanaKolicina());
    }

    public void refreshPopisWithRazlika(ScreensController controller) throws SQLException {
        Product product = Product.getByID(this.getProductID(), controller);
        product.getCurrentPrice(1L, controller.getSettings().getConnection());
        this.setProduct(product);
        this.setBarcode(product.getBarcodeLast());
        this.setUserName(User.getUserByID(this.getUserID(), controller.getSettings().getConnection()).getUserName());
        this.setCena(product.getPrice());
        this.setProductName(product.getName());
        this.setTotal(this.getCena() * this.getPopisanaKolicina());
    }

    public static ObservableList<PopisDetailes> getlist(Popis popis, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "SELECT d.DepartmentID,\tdd.DocumentDetailsID, dd.DocumentID, dd.ProductID,\tdd.Quantity AS PopisanaKolicina, COALESCE(dd.Date, dd.sysDTCreated) AS Date, dd.sysUserAddID,\tp.Code,\tp.Name, dd.Costs AS Stanje\t\r\nFROM documentdetails dd \r\nLEFT JOIN document d ON d.DocumentID = dd.DocumentID  \r\nLEFT JOIN product p ON p.ProductID = dd.ProductID \r\nWHERE dd.DocumentID = ? \r\nORDER BY dd.DocumentDetailsID";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setLong(1, popis.getDocumentID());
            System.out.println(ps);
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                PopisDetailes popisDetailes = new PopisDetailes();
                popisDetailes.setUserID(rs.getLong("sysUserAddID"));
                popisDetailes.setDepartmentID(rs.getInt("DepartmentID"));
                popisDetailes.setPopisDetailesID(rs.getLong("DocumentDetailsID"));
                popisDetailes.setDateTime(rs.getTimestamp("Date").toLocalDateTime());
                popisDetailes.setProductID(rs.getLong("ProductID"));
                popisDetailes.setPopisanaKolicina(rs.getDouble("PopisanaKolicina"));
                popisDetailes.setStanje(rs.getDouble("Stanje"));
                list.add((Object)popisDetailes);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            list = null;
            e.printStackTrace();
        }
        return list;
    }

    public void delete(Connection connection) {
        DocumentDetails dd = new DocumentDetails();
        dd.setDocumentDetailsID(this.PopisDetailesID);
        dd.delete(connection);
    }

    public void update(ScreensController controller) {
        DocumentDetails dd = DocumentDetails.getByID(this.PopisDetailesID, controller.getSettings().getConnection());
        dd.setQuantity(this.PopisanaKolicina);
        dd.setCosts(this.Stanje);
        dd.update(controller);
    }

    public long insert(ScreensController controller) {
        long result;
        DocumentDetails dd = new DocumentDetails();
        dd.setDate(this.getDateTime());
        dd.setDocumentID(this.DocumentID);
        dd.setProductID(this.product.getProductID());
        dd.setUnitID(this.product.getUnitID());
        dd.setVatID(this.product.getVatID());
        dd.setQuantity(this.PopisanaKolicina);
        dd.setCosts(this.Stanje);
        dd.setSysUserAddID(controller.getUser().getUserID());
        dd.setProduct(this.product);
        this.PopisDetailesID = result = dd.insert(controller.getSettings().getConnection());
        return result;
    }

    public void insertIntoTemp(int popisType, Connection connection) throws SQLException {
        String query = "INSERT INTO `temp_popisdetailes` (`ProductID`, `Quantity`, `DepartmentID`, `DateTime`, `PopisTypeID`, `UserID`) VALUES (?, ?, ?, ?, ?, ?);";
        PreparedStatement ps = connection.prepareStatement(query, 1);
        ps.setLong(1, this.getProduct().getProductID());
        ps.setDouble(2, this.getPopisanaKolicina());
        ps.setInt(3, this.getDepartmentID());
        ps.setTimestamp(4, Timestamp.valueOf(this.getDateTime()));
        ps.setInt(5, popisType);
        ps.setLong(6, this.getUserID());
        ps.executeUpdate();
        ResultSet rs = ps.getGeneratedKeys();
        rs.next();
        this.setTempPopisDetailesID(rs.getInt(1));
        ps.close();
        rs.close();
    }

    public void updateTemp(Connection connection) {
        String query = "UPDATE `temp_popisdetailes` SET `Quantity` = ? WHERE  `ProductID`= ?;";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setDouble(1, this.getPopisanaKolicina());
            ps.setLong(2, this.getProductID());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void deleteFromTemp(Connection connection) {
        String query = "DELETE FROM `temp_popisdetailes` WHERE  `id`=?;";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setLong(1, this.getTempPopisDetailesID());
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void createTempTable(Connection connection) {
        String query = "CREATE TABLE IF NOT EXISTS `temp_popisdetailes`( `id` BIGINT(20) NOT NULL AUTO_INCREMENT, `ProductID` BIGINT(20) NULL DEFAULT NULL, `Quantity` DECIMAL(15,4) NULL DEFAULT NULL, `Stock` DECIMAL(15,4) NULL DEFAULT NULL, `DepartmentID` INT(11) NULL DEFAULT NULL, `DateTime` DATETIME NULL DEFAULT CURRENT_TIMESTAMP, `PopisTypeID` INT(11) NULL DEFAULT NULL, `UserID` BIGINT(20) NULL DEFAULT NULL, PRIMARY KEY (`id`), INDEX `FK_temp_popisdetailes_product` (`ProductID`), INDEX `FK_temp_popisdetailes_department` (`DepartmentID`), CONSTRAINT `FK_temp_popisdetailes_department` FOREIGN KEY (`DepartmentID`) REFERENCES `department` (`DepartmentID`) ON UPDATE CASCADE, CONSTRAINT `FK_temp_popisdetailes_product` FOREIGN KEY (`ProductID`) REFERENCES `product` (`ProductID`) ON UPDATE CASCADE) COLLATE='utf8_general_ci' ENGINE=InnoDB;";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void dropTempTable(Connection connection) {
        String query = "DROP TABLE `temp_popisdetailes`;";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void emptyTempTable(int departmentID, int popisTypeID, Connection connection) {
        String query = "DELETE FROM `temp_popisdetailes` WHERE  `DepartmentID`=? and `PopisTypeID`=?";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, departmentID);
            ps.setInt(2, popisTypeID);
            ps.executeUpdate();
            ps.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static PopisDetailes getProductFromTempTable(Long productID, ScreensController controller) {
        String query = "SELECT tpd.* FROM `temp_popisdetailes` tpd WHERE tpd.ProductID = ?";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setLong(1, productID);
            ResultSet rs = ps.executeQuery();
            rs.next();
            PopisDetailes pd = new PopisDetailes();
            pd.setUserID(rs.getLong("UserID"));
            pd.setTempPopisDetailesID(rs.getLong("id"));
            pd.setProductID(rs.getLong("ProductID"));
            pd.setProduct(Product.getByID(pd.getProductID(), controller));
            pd.setPopisanaKolicina(rs.getDouble("Quantity"));
            pd.setDepartmentID(rs.getInt("DepartmentID"));
            pd.setDateTime(rs.getTimestamp("DateTime").toLocalDateTime());
            pd.setStanje(rs.getDouble("Stock"));
            ps.close();
            rs.close();
            return pd;
        }
        catch (SQLException e) {
            return null;
        }
    }

    public static ObservableList<PopisDetailes> getListFromTempTable(int departmentID, boolean group, ScreensController controller) throws SQLException {
        String query = "SELECT tpd.id, tpd.ProductID, " + (group ? "sum(tpd.Quantity) AS Quantity" : "tpd.Quantity") + ", tpd.DepartmentID, tpd.DateTime, tpd.PopisTypeID, tpd.UserID FROM `temp_popisdetailes` tpd WHERE DepartmentID = ? " + (group ? "group by tpd.ProductID;" : ";");
        if (group) {
            // empty if block
        }
        ObservableList list = FXCollections.observableArrayList();
        PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
        ps.setInt(1, departmentID);
        System.out.println(ps);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            PopisDetailes pd = new PopisDetailes();
            pd.setUserID(rs.getLong("UserID"));
            pd.setTempPopisDetailesID(rs.getLong("id"));
            pd.setProductID(rs.getLong("ProductID"));
            pd.setProduct(Product.getByID(pd.getProductID(), controller));
            pd.setPopisanaKolicina(rs.getDouble("Quantity"));
            pd.setDepartmentID(rs.getInt("DepartmentID"));
            pd.setDateTime(rs.getTimestamp("DateTime").toLocalDateTime());
            pd.setStanje(Product.getStockByProduct(Product.getByID(pd.getProductID(), controller), WorkDay.datumPocetnogStanja(pd.getDepartmentID(), Settings.DatefromLocalDateTime(pd.getDateTime()), controller.getSettings().getConnection()), controller));
            list.add((Object)pd);
        }
        ps.close();
        rs.close();
        return list;
    }
}

