/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.Department;
import rs.petcom.master.dal.document.Document;
import rs.petcom.master.dal.document.DocumentDetails;

public class Popis {
    long DocumentID;
    int Number;
    Date Date;
    int DepartmentID;
    String Note;
    long UserID;

    public Popis(long DocumentID, int Number2, Date Date2, int DepartmentID, String Note) {
        this.DocumentID = DocumentID;
        this.Number = Number2;
        this.Date = Date2;
        this.DepartmentID = DepartmentID;
        this.Note = Note;
    }

    public Popis() {
    }

    public long getDocumentID() {
        return this.DocumentID;
    }

    public void setDocumentID(long documentID) {
        this.DocumentID = documentID;
    }

    public int getNumber() {
        return this.Number;
    }

    public void setNumber(int number) {
        this.Number = number;
    }

    public Date getDate() {
        return this.Date;
    }

    public void setDate(Date date) {
        this.Date = date;
    }

    public int getDepartmentID() {
        return this.DepartmentID;
    }

    public void setDepartmentID(int departmentID) {
        this.DepartmentID = departmentID;
    }

    public String getNote() {
        return this.Note;
    }

    public void setNote(String note) {
        this.Note = note;
    }

    public void setUserID(long userID) {
        this.UserID = userID;
    }

    public long getUserID() {
        return this.UserID;
    }

    public static ObservableList<Popis> getList(Date dateFrom, Date dateTo, Department department, int popisTypeID, Connection connection) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select *   from document where DocumentTypeID = ?   and Date >= ?    and Date < DATE_ADD(?,INTERVAL 1 DAY)    and DepartmentID = ? order by Date desc";
        try {
            PreparedStatement ps = connection.prepareStatement(query);
            ps.setInt(1, popisTypeID);
            ps.setTimestamp(2, new Timestamp(dateFrom.getTime()));
            ps.setTimestamp(3, new Timestamp(dateTo.getTime()));
            ps.setInt(4, department.getDepartmentID());
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                Popis p = new Popis();
                p.setUserID(rs.getLong("sysUserAddID"));
                p.setDocumentID(rs.getLong("DocumentID"));
                p.setNumber(rs.getInt("Number"));
                p.setDate(rs.getTimestamp("Date"));
                p.setNote(rs.getString("Note"));
                p.setDepartmentID(rs.getInt("DepartmentID"));
                list.add((Object)p);
            }
            ps.close();
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public long insert(int popisTypeID, ScreensController controller) throws SQLException {
        Document document = new Document();
        document.setDocumentTypeID(popisTypeID);
        document.setDocumentStatusID(1);
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        document.setYear(cal.get(1));
        document.setDate(this.Date);
        document.setNumber(this.getNumber());
        document.setSysUserAddID(controller.getUser().getUserID());
        document.setDepartmentID(this.DepartmentID);
        this.DocumentID = document.insertWithModifiedDate(controller.getSettings().getConnection());
        return document.getDocumentID();
    }

    public void update(int popistTypeID, ScreensController controller) {
        Document document = Document.getByID(this.DocumentID, controller.getSettings().getConnection());
        document.setDocumentTypeID(popistTypeID);
        document.setDocumentStatusID(1);
        document.setDate(this.Date);
        document.setDepartmentID(this.DepartmentID);
        document.setNote(this.Note);
        try {
            document.update(controller);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void delete(Connection connection) throws SQLException {
        Document d = Document.getByID(this.DocumentID, connection);
        DocumentDetails.deleteDetailes(d, connection);
        Document.delete(this.DocumentID, connection);
    }
}

