/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.Otpis;
import rs.petcom.master.dal.product.Product;

public class OtpisDetalji {
    private long DocumentDetailsID;
    private long DocumentID;
    private long ProductID;
    private double PriceWithDiscount;
    private double Price;
    private String ProductCode;
    private String ProductName;
    private Product product;
    private double Quantity;
    private double PriceWithoutVatAndDiscount;
    private double Sum;
    private double Discount;
    private double SumWithDiscount;
    private double Vat;
    private double SumWithVat;
    private double SellPrice;
    private LocalDateTime dateEdit;
    private LocalDateTime dateCreate;
    private double NewSellPrice;
    private double PurchasePrice;

    public void setDateCreate(LocalDateTime dateCreate) {
        this.dateCreate = dateCreate;
    }

    public LocalDateTime getDateCreate() {
        return this.dateCreate;
    }

    public void setDateEdit(LocalDateTime dateEdit) {
        this.dateEdit = dateEdit;
    }

    public LocalDateTime getDateEdit() {
        return this.dateEdit;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setSellPrice(double sellPrice) {
        this.SellPrice = sellPrice;
    }

    public double getSellPrice() {
        return this.SellPrice;
    }

    public void setPriceWithoutVatAndDiscount(double priceWithoutVatAndDiscount) {
        this.PriceWithoutVatAndDiscount = priceWithoutVatAndDiscount;
    }

    public double getPriceWithoutVatAndDiscount() {
        return this.PriceWithoutVatAndDiscount;
    }

    public double getSumWithVat() {
        return this.SumWithVat;
    }

    public void setSumWithVat(double sumWithVat) {
        this.SumWithVat = sumWithVat;
    }

    public void setVat(double vat) {
        this.Vat = vat;
    }

    public double getVat() {
        return this.Vat;
    }

    public void setSumWithDiscount(double sumWithDiscount) {
        this.SumWithDiscount = sumWithDiscount;
    }

    public double getSumWithDiscount() {
        return this.SumWithDiscount;
    }

    public void setSum(double sum) {
        this.Sum = sum;
    }

    public double getSum() {
        return this.Sum;
    }

    public void setPurchasePrice(double nabavnaCenaProizvoda) {
        this.PurchasePrice = nabavnaCenaProizvoda;
    }

    public double getPurchasePrice() {
        return this.PurchasePrice;
    }

    public double getNewSellPrice() {
        return this.NewSellPrice;
    }

    public void setNewSellPrice(double sellPrice) {
        this.NewSellPrice = sellPrice;
    }

    public long getDocumentDetailsID() {
        return this.DocumentDetailsID;
    }

    public void setDocumentDetailsID(long documentDetailsID) {
        this.DocumentDetailsID = documentDetailsID;
    }

    public long getDocumentID() {
        return this.DocumentID;
    }

    public void setDocumentID(long documentID) {
        this.DocumentID = documentID;
    }

    public long getProductID() {
        return this.ProductID;
    }

    public void setProductID(long productID) {
        this.ProductID = productID;
    }

    public String getProductCode() {
        return this.ProductCode;
    }

    public void setProductCode(String productCode) {
        this.ProductCode = productCode;
    }

    public String getProductName() {
        return this.ProductName;
    }

    public void setProductName(String productName) {
        this.ProductName = productName;
    }

    public double getQuantity() {
        return this.Quantity;
    }

    public void setQuantity(double quantity) {
        this.Quantity = quantity;
    }

    public void setPrice(double price) {
        this.Price = price;
    }

    public double getPrice() {
        return this.Price;
    }

    public double getDiscount() {
        return this.Discount;
    }

    public void setDiscount(double discount) {
        this.Discount = discount;
    }

    public double getPriceWithDiscount() {
        return this.PriceWithDiscount;
    }

    public void setPriceWithDiscount(double priceWithDiscount) {
        this.PriceWithDiscount = priceWithDiscount;
    }

    public static ObservableList<OtpisDetalji> getlist(Otpis otpis, long departmentID, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select \td.DocumentDetailsID,\td.DocumentID,\td.ProductID,\tp.Code,\tp.Name,\td.Quantity,    d.Price,    d.Discount,    d.PriceWithDiscount, d.sysDTEdit, d.sysDTCreated  from documentdetails d  left join product p on p.ProductID = d.ProductID where DocumentID = ? order by d.documentdetailsid asc";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setLong(1, otpis.getDocumentID());
            ResultSet resultSet = ps.executeQuery();
            while (resultSet.next()) {
                OtpisDetalji pd = new OtpisDetalji();
                pd.DocumentDetailsID = resultSet.getLong("DocumentDetailsID");
                pd.DocumentID = resultSet.getLong("DocumentID");
                pd.ProductID = resultSet.getLong("ProductID");
                pd.ProductCode = resultSet.getString("Code");
                pd.ProductName = resultSet.getString("Name");
                pd.Quantity = resultSet.getDouble("Quantity");
                pd.Price = resultSet.getDouble("Price");
                pd.Discount = resultSet.getDouble("Discount");
                pd.PriceWithDiscount = resultSet.getDouble("PriceWithDiscount");
                try {
                    pd.dateEdit = resultSet.getTimestamp("sysDTEdit").toLocalDateTime();
                }
                catch (NullPointerException e) {
                    pd.dateEdit = resultSet.getTimestamp("sysDTCreated").toLocalDateTime();
                }
                pd.product = Product.getByID(pd.ProductID, controller);
                pd.PriceWithoutVatAndDiscount = pd.Price - pd.Price * pd.product.getVatValue3();
                pd.Sum = pd.PriceWithoutVatAndDiscount * pd.Quantity;
                pd.SumWithDiscount = pd.Sum - pd.Sum * pd.Discount / 100.0;
                pd.SumWithVat = pd.SumWithDiscount * pd.product.getVatValue();
                pd.Vat = pd.product.getVatValue();
                pd.setSellPrice(pd.product.getCurrentPriceBeforeDate(pd.dateEdit, departmentID, controller.getSettings().getConnection()));
                pd.setNewSellPrice(pd.SellPrice);
                list.add((Object)pd);
            }
            ps.close();
            resultSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void delete(Connection connection) {
        DocumentDetails dd = new DocumentDetails();
        dd.setDocumentDetailsID(this.DocumentDetailsID);
        dd.delete(connection);
    }

    public void update(ScreensController controller) {
        DocumentDetails dd = DocumentDetails.getByID(this.DocumentDetailsID, controller.getSettings().getConnection());
        dd.setPrice(this.Price);
        dd.setQuantity(this.Quantity);
        dd.setPriceWithDiscount(this.PriceWithDiscount);
        dd.update(controller);
    }

    public void updateWithDiscount(ScreensController controller) {
        DocumentDetails dd = DocumentDetails.getByID(this.DocumentDetailsID, controller.getSettings().getConnection());
        dd.setProductID(this.ProductID);
        dd.setPrice(this.Price);
        dd.setQuantity(this.Quantity);
        dd.setPriceWithDiscount(this.PriceWithDiscount);
        dd.setDiscount(this.Discount);
        dd.update(controller);
    }

    public long insert(ScreensController controller) {
        long result;
        Product p = Product.getByID(this.ProductID, controller);
        DocumentDetails dd = new DocumentDetails();
        dd.setDocumentID(this.DocumentID);
        dd.setProductID(this.ProductID);
        dd.setUnitID(p.getUnitID());
        dd.setVatID(p.getVatID());
        dd.setPrice(this.Price);
        dd.setQuantity(this.Quantity);
        dd.setPriceWithDiscount(this.PriceWithDiscount);
        dd.setSysUserAddID(controller.getUser().getUserID());
        this.DocumentDetailsID = result = dd.insert(controller.getSettings().getConnection());
        return result;
    }

    public long insertWithDiscount(ScreensController controller) {
        long result;
        Product p = Product.getByID(this.ProductID, controller);
        DocumentDetails dd = new DocumentDetails();
        dd.setDocumentID(this.DocumentID);
        dd.setProductID(this.ProductID);
        dd.setUnitID(p.getUnitID());
        dd.setVatID(p.getVatID());
        dd.setDiscount(this.Discount);
        dd.setPrice(this.Price);
        dd.setQuantity(this.Quantity);
        dd.setPriceWithDiscount(this.PriceWithDiscount);
        dd.setSysUserAddID(controller.getUser().getUserID());
        this.DocumentDetailsID = result = dd.insert(controller.getSettings().getConnection());
        return result;
    }
}

