/*
 * Decompiled with CFR 0.152.
 */
package rs.petcom.master.dal.document;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import rs.petcom.master.ScreensController;
import rs.petcom.master.dal.document.DocumentDetails;
import rs.petcom.master.dal.document.Otpis;
import rs.petcom.master.dal.product.Product;

public class OtpisDetailes {
    private long documentDetailsID;
    private long documentID;
    private double purchasePriceWithoutVat;
    private double purchasePriceWithVat;
    private Product product;
    private double quantity;
    private double purchasePriceWithoutVatSum;
    private double purchasePriceWithVatSum;
    private double currentPriceSumWithoutPDV;
    private double currentPriceSumWithPDV;
    private double currentPrice;
    private double vat;
    private LocalDateTime dateEdit;
    private LocalDateTime dateCreate;

    public long getDocumentDetailsID() {
        return this.documentDetailsID;
    }

    public void setDocumentDetailsID(long documentDetailsID) {
        this.documentDetailsID = documentDetailsID;
    }

    public long getDocumentID() {
        return this.documentID;
    }

    public void setDocumentID(long documentID) {
        this.documentID = documentID;
    }

    public double getPurchasePriceWithoutVat() {
        return this.purchasePriceWithoutVat;
    }

    public void setPurchasePriceWithoutVat(double purchasePriceWithoutVat) {
        this.purchasePriceWithoutVat = purchasePriceWithoutVat;
    }

    public double getPurchasePriceWithVat() {
        return this.purchasePriceWithVat;
    }

    public void setPurchasePriceWithVat(double purchasePriceWithVat) {
        this.purchasePriceWithVat = purchasePriceWithVat;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public double getPurchasePriceWithoutVatSum() {
        return this.purchasePriceWithoutVatSum;
    }

    public void setPurchasePriceWithoutVatSum(double purchasePriceWithoutVatSum) {
        this.purchasePriceWithoutVatSum = purchasePriceWithoutVatSum;
    }

    public double getPurchasePriceWithVatSum() {
        return this.purchasePriceWithVatSum;
    }

    public void setPurchasePriceWithVatSum(double purchasePriceWithVatSum) {
        this.purchasePriceWithVatSum = purchasePriceWithVatSum;
    }

    public double getCurrentPriceSumWithoutPDV() {
        return this.currentPriceSumWithoutPDV;
    }

    public void setCurrentPriceSumWithoutPDV(double currentPriceSumWithoutPDV) {
        this.currentPriceSumWithoutPDV = currentPriceSumWithoutPDV;
    }

    public double getCurrentPriceSumWithPDV() {
        return this.currentPriceSumWithPDV;
    }

    public void setCurrentPriceSumWithPDV(double currentPriceSumWithPDV) {
        this.currentPriceSumWithPDV = currentPriceSumWithPDV;
    }

    public double getVat() {
        return this.vat;
    }

    public void setVat(double vat) {
        this.vat = vat;
    }

    public LocalDateTime getDateEdit() {
        return this.dateEdit;
    }

    public void setDateEdit(LocalDateTime dateEdit) {
        this.dateEdit = dateEdit;
    }

    public LocalDateTime getDateCreate() {
        return this.dateCreate;
    }

    public void setDateCreate(LocalDateTime dateCreate) {
        this.dateCreate = dateCreate;
    }

    public double getCurrentPrice() {
        return this.currentPrice;
    }

    public void setCurrentPrice(double currentPrice) {
        this.currentPrice = currentPrice;
    }

    public static ObservableList<OtpisDetailes> getlist(Otpis otpis, ScreensController controller) {
        ObservableList list = FXCollections.observableArrayList();
        String query = "select \td.DocumentDetailsID,\td.DocumentID,\td.ProductID,\tp.Code,\tp.Name,\td.Quantity,    d.Price,   d.PurchacePrice , d.Discount,    d.PriceWithDiscount, d.sysDTEdit, d.sysDTCreated, d.NewPrice  from documentdetails d  left join product p on p.ProductID = d.ProductID where DocumentID = ? order by d.documentdetailsid asc";
        try {
            PreparedStatement ps = controller.getSettings().getConnection().prepareStatement(query);
            ps.setLong(1, otpis.getDocumentID());
            ResultSet resultSet = ps.executeQuery();
            while (resultSet.next()) {
                OtpisDetailes otpisDetailes = new OtpisDetailes();
                otpisDetailes.setDocumentDetailsID(resultSet.getLong("DocumentDetailsID"));
                otpisDetailes.setDocumentID(resultSet.getLong("DocumentID"));
                Product product = Product.getByID(resultSet.getLong("ProductID"), controller);
                otpisDetailes.setProduct(product);
                otpisDetailes.setPurchasePriceWithoutVat(OtpisDetailes.round2Decimals(resultSet.getDouble("PurchacePrice")));
                otpisDetailes.setPurchasePriceWithVat(OtpisDetailes.round2Decimals(resultSet.getDouble("Price")));
                otpisDetailes.setCurrentPrice(OtpisDetailes.round2Decimals(resultSet.getDouble("NewPrice")));
                otpisDetailes.setQuantity(resultSet.getDouble("Quantity"));
                otpisDetailes.setPurchasePriceWithoutVatSum(OtpisDetailes.round2Decimals(otpisDetailes.getPurchasePriceWithoutVat() * otpisDetailes.getQuantity()));
                otpisDetailes.setPurchasePriceWithVatSum(OtpisDetailes.round2Decimals(otpisDetailes.getPurchasePriceWithVat() * otpisDetailes.getQuantity()));
                otpisDetailes.setCurrentPriceSumWithoutPDV(OtpisDetailes.round2Decimals((otpisDetailes.getCurrentPrice() - otpisDetailes.getCurrentPrice() * otpisDetailes.getProduct().getVatValue3()) * otpisDetailes.getQuantity()));
                otpisDetailes.setCurrentPriceSumWithPDV(OtpisDetailes.round2Decimals(otpisDetailes.getCurrentPrice() * otpisDetailes.getQuantity()));
                try {
                    otpisDetailes.setDateEdit(resultSet.getTimestamp("sysDTEdit").toLocalDateTime());
                }
                catch (NullPointerException e) {
                    otpisDetailes.setDateEdit(resultSet.getTimestamp("sysDTCreated").toLocalDateTime());
                }
                list.add((Object)otpisDetailes);
            }
            ps.close();
            resultSet.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return list;
    }

    public long insert(ScreensController controller) {
        long result;
        Product p = Product.getByID(this.product.getProductID(), controller);
        DocumentDetails dd = new DocumentDetails();
        dd.setDocumentID(this.documentID);
        dd.setProductID(p.getProductID());
        dd.setUnitID(p.getUnitID());
        dd.setVatID(p.getVatID());
        dd.setPrice(this.purchasePriceWithVat);
        dd.setQuantity(this.quantity);
        dd.setPriceWithDiscount(this.purchasePriceWithVat);
        dd.setNewPrice(this.currentPrice);
        dd.setPurchacePrice(this.purchasePriceWithoutVat);
        dd.setSysUserAddID(controller.getUser().getUserID());
        this.documentDetailsID = result = dd.insert(controller.getSettings().getConnection());
        return result;
    }

    public void update(ScreensController controller) {
        DocumentDetails dd = DocumentDetails.getByID(this.documentDetailsID, controller.getSettings().getConnection());
        dd.setProductID(this.product.getProductID());
        dd.setPrice(this.purchasePriceWithVat);
        dd.setQuantity(this.quantity);
        dd.setPriceWithDiscount(this.purchasePriceWithVat);
        dd.setPurchacePrice(this.purchasePriceWithoutVat);
        dd.setNewPrice(this.currentPrice);
        dd.update(controller);
    }

    public void delete(Connection connection) {
        DocumentDetails dd = new DocumentDetails();
        dd.setDocumentDetailsID(this.documentDetailsID);
        dd.delete(connection);
    }

    private static double round2Decimals(double x) {
        return (double)Math.round(x * 100.0) / 100.0;
    }
}

